/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen;

import de.slashbinbash.hexen.ExceptionLogger;
import de.slashbinbash.hexen.GameState;
import de.slashbinbash.hexen.HexenConfig;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.message.EventBus;
import de.slashbinbash.hexen.message.MessageBus;
import de.slashbinbash.hexen.renderer.Assets;
import de.slashbinbash.hexen.renderer.BackgroundRenderer;
import de.slashbinbash.hexen.renderer.Map3DRenderer;
import de.slashbinbash.opengl.AppConfig;
import de.slashbinbash.opengl.GLByteBuffer;
import de.slashbinbash.opengl.IApp;
import de.slashbinbash.opengl.JoystickEvent;
import de.slashbinbash.opengl.KeyboardEvent;
import de.slashbinbash.opengl.LWJGL3;
import de.slashbinbash.opengl.MouseEvent;
import de.slashbinbash.opengl.renderer.Draw2D;
import java.io.File;

public class Hexen
implements IApp {
    private static final String TITLE = "HexenRPG";
    public static int SCALE = 1;
    public static int SCR_WIDTH = 640;
    public static int SCR_HEIGHT = 360;
    public static int WND_WIDTH = SCR_WIDTH * SCALE;
    public static int WND_HEIGHT = SCR_HEIGHT * SCALE;
    public static GameState game;
    private AppConfig config;
    private Draw2D gl;

    public static GameState getInstance() {
        return game;
    }

    public static void main(String[] stringArray) {
        HexenConfig.load("app.properties");
        Factory.setPAK(".", HexenConfig.pak);
        if (HexenConfig.validatePak) {
            long l = System.currentTimeMillis();
            if (!Factory.validatePak()) {
                System.exit(-1);
            }
            long l2 = System.currentTimeMillis();
            System.out.println("Validated PAK: " + HexenConfig.pak + " " + (l2 - l) + "ms");
        }
        Hexen hexen = new Hexen(HexenConfig.scale);
        try {
            LWJGL3.runApp(hexen);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            ExceptionLogger.log(throwable);
        }
    }

    public Hexen(int n) {
        SCALE = n;
        WND_WIDTH = SCR_WIDTH * SCALE;
        WND_HEIGHT = SCR_HEIGHT * SCALE;
        this.config = new AppConfig(TITLE, WND_WIDTH, WND_HEIGHT);
    }

    @Override
    public void draw() {
        this.gl.clear();
        game.draw(this.gl);
    }

    @Override
    public void drawFPS(int n) {
    }

    @Override
    public void exit() {
    }

    @Override
    public AppConfig getConfig() {
        return this.config;
    }

    @Override
    public void handleJoystickEvent(JoystickEvent joystickEvent) {
        game.handleJoystickEvent(joystickEvent);
    }

    @Override
    public void handleKeyboardEvent(KeyboardEvent keyboardEvent) {
        switch (keyboardEvent.key) {
            case 301: {
                if (keyboardEvent.down) {
                    long l = System.currentTimeMillis();
                    LWJGL3.createScreenshot("screenshots/" + l);
                    EventBus.Screenshot();
                }
                return;
            }
        }
        game.handleKeyboard(keyboardEvent);
    }

    @Override
    public void handleMouseEvent(MouseEvent mouseEvent) {
        if (SCALE == 1) {
            game.handleMouse(mouseEvent);
        } else {
            MouseEvent mouseEvent2 = new MouseEvent(mouseEvent);
            mouseEvent2.x = mouseEvent.x / (float)SCALE;
            mouseEvent2.y = mouseEvent.y / (float)SCALE;
            game.handleMouse(mouseEvent2);
        }
    }

    @Override
    public void handleResizeEvent(int n, int n2) {
    }

    @Override
    public void init() {
        GLByteBuffer gLByteBuffer = new GLByteBuffer(0);
        gLByteBuffer.capacity(8000000);
        Map3DRenderer.getInstance().init(gLByteBuffer);
        this.gl = new Draw2D();
        this.gl.checkCapacity(4000000);
        this.gl.init2D(WND_WIDTH, WND_HEIGHT, SCR_WIDTH, SCR_HEIGHT);
        this.gl.setFont(Assets.ibmcga);
        this.gl.setFontSize(8, 8);
        File file = new File("saves/" + HexenConfig.pak + "/autosave.xml");
        if (!file.exists()) {
            file = new File(Factory.PAK_PATH + "/save0.xml");
        }
        BackgroundRenderer.load("bathroom-floor-32");
        game = new GameState();
        try {
            game.loadGame(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public void tick() {
        MessageBus.sendAll();
    }
}

