/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen;

import java.io.File;
import java.io.IOException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PAKValidator {
    public static void validateXMLSchema(File file, File file2) throws SAXException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(file);
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(file2));
    }

    public static int validateXMLSchema(File file, File[] fileArray) {
        Validator validator = null;
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            File[] fileArray2 = schemaFactory.newSchema(file);
            validator = fileArray2.newValidator();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            System.exit(-1);
        }
        int n = 0;
        for (File file2 : fileArray) {
            if (!file2.getName().endsWith(".xml")) continue;
            StreamSource streamSource = new StreamSource(file2);
            try {
                validator.validate(streamSource);
            }
            catch (SAXParseException sAXParseException) {
                System.out.println(file2.getAbsolutePath() + ":" + sAXParseException.getLineNumber() + ":" + sAXParseException.getColumnNumber() + ":\n   " + sAXParseException.getMessage() + " [" + file.getName() + "]");
                ++n;
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
                System.exit(-1);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(-1);
            }
        }
        return n;
    }

    public static int validateDbDirectory(String string, String string2) {
        File file = new File("data/schema/" + string2 + ".xsd");
        File file2 = new File(string + "/" + string2);
        return PAKValidator.validateXMLSchema(file, file2.listFiles());
    }

    public static boolean validatePak(String string) {
        String[] stringArray = new String[]{"ability", "combat_action", "condition", "creature", "guild", "inn", "item", "mod", "modder", "quest", "scene", "shop", "temple", "trait", "travel", "workbench"};
        int n = 0;
        for (String string2 : stringArray) {
            n += PAKValidator.validateDbDirectory(string + "/db", string2);
        }
        if (n > 0) {
            System.out.println("Found " + n + " errors.");
        }
        return n == 0;
    }
}

