/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.action;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.action.Action;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.Condition;
import de.slashbinbash.hexen.model.Party;

public class AddCondition
extends Action {
    public String condition;
    public long duration = Long.MAX_VALUE;
    public Type type = Type.All;
    public float chance = 1.0f;

    public AddCondition(String string) {
        this.condition = string;
    }

    public AddCondition(String string, long l) {
        this.condition = string;
        this.duration = l;
    }

    @Override
    public void perform(Object object) {
        Condition condition = new Condition(this.condition, this.duration);
        if (object instanceof ClassCreature) {
            ClassCreature classCreature = (ClassCreature)object;
            if (this.roll()) {
                classCreature.addCondition(condition);
            }
        } else {
            Object object2;
            Party party = null;
            if (object instanceof Party) {
                object2 = (Party)object;
                party = object2;
            } else {
                party = RPG.getInstance().party;
            }
            switch (this.type.ordinal()) {
                case 0: {
                    for (ClassCreature classCreature : party.getMembers()) {
                        if (!this.roll()) continue;
                        classCreature.addCondition(condition);
                    }
                    break;
                }
                case 1: {
                    if (!this.roll()) break;
                    object2 = RPG.getInstance().party.pickRandom();
                    ((ClassCreature)object2).addCondition(condition);
                    break;
                }
            }
        }
    }

    private boolean roll() {
        return this.chance >= 1.0f || RPG.rand.nextFloat() <= this.chance;
    }

    public static enum Type {
        All,
        Random;

    }
}

