/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.audio;

import de.slashbinbash.hexen.audio.SoundEngine;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.model.Scene;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Sample {
    public String id = null;
    public SoundEngine.Layer layer = null;
    public boolean loop = false;
    public File file = null;
    private Clip clip = null;

    public Sample() {
    }

    public Sample(Scene.Sound sound) {
        this.id = sound.id;
        this.layer = SoundEngine.Layer.valueOf(sound.layer);
        this.loop = sound.loop;
        this.file = new File(Factory.WAV_PATH + this.id + ".wav");
    }

    public void close() {
        this.clip.close();
    }

    public boolean isLoaded() {
        return this.clip != null;
    }

    public boolean isOpen() {
        return this.clip.isOpen();
    }

    public boolean isRunning() {
        return this.clip.isRunning();
    }

    public void open() {
        try {
            this.clip = AudioSystem.getClip();
            this.clip.open(AudioSystem.getAudioInputStream(this.file));
        }
        catch (LineUnavailableException lineUnavailableException) {
            lineUnavailableException.printStackTrace();
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            unsupportedAudioFileException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void start() {
        this.clip.setFramePosition(0);
        if (this.loop) {
            this.clip.loop(-1);
        } else {
            this.clip.start();
        }
    }

    public void stop() {
        this.clip.stop();
    }
}

