/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.audio;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.audio.SoundEngine;
import de.slashbinbash.hexen.message.ISubscriber;
import de.slashbinbash.hexen.message.Message;
import de.slashbinbash.hexen.message.MessageBase;
import de.slashbinbash.hexen.message.MessageBus;
import de.slashbinbash.hexen.model.Scene;

public class SoundSystem
implements ISubscriber {
    public SoundEngine engine = new SoundEngine();
    private Scene curr = null;

    public SoundSystem() {
        MessageBus.subscribe(this);
    }

    public void clear() {
        this.engine.clear();
    }

    private Scene getScene(Object object) {
        if (object instanceof Scene) {
            Scene scene = (Scene)object;
            return scene;
        }
        return RPG.getInstance().party.getLocation().getScene();
    }

    private void handleEvent(MessageBase messageBase) {
        switch (messageBase.event) {
            case DOOR_LOCKED: {
                break;
            }
            case DOOR_UNLOCKED: {
                break;
            }
            case FAILED_ABILITY_CHECK: {
                break;
            }
            case ITEM_ADDED: {
                break;
            }
            case QUEST_ADDED: {
                break;
            }
            case RECIPE_LEARNED: {
                break;
            }
            case RUN_AGAINST_WALL: {
                break;
            }
        }
    }

    @Override
    public void notify(Message message, Object object) {
        switch (message) {
            case SCENE_CHANGED: {
                Scene scene = this.getScene(object);
                if (scene == null || scene.sounds == null || this.curr != null && scene.sounds == this.curr.sounds) break;
                this.curr = scene;
                for (Scene.Sound sound : scene.sounds) {
                    this.engine.openSample(sound);
                }
                this.engine.swapSamples(scene.sounds);
                break;
            }
            case POST_EVENT_BUS: {
                if (!(object instanceof MessageBase)) break;
                MessageBase messageBase = (MessageBase)object;
                this.handleEvent(messageBase);
                break;
            }
        }
    }
}

