/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.check;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.check.ICheck;
import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.model.Abilities;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.Party;

public class AbilityRateCheck
implements ICheck {
    public Ability ability = null;
    public int dc = 0;
    public Mode mode = Mode.Default;

    public AbilityRateCheck(Ability ability, int n) {
        this.ability = ability;
        this.dc = n;
        this.mode = Mode.Default;
    }

    @Override
    public boolean check(Object object) {
        block40: {
            int n;
            float f;
            block39: {
                int n2 = 0;
                if (object instanceof Abilities) {
                    Abilities abilities = (Abilities)object;
                    n2 = abilities.get(this.ability);
                } else if (object instanceof ClassCreature) {
                    ClassCreature classCreature = (ClassCreature)object;
                    n2 = classCreature.calcAbilityScore(this.ability);
                } else if (object instanceof Party) {
                    Object object2 = (Party)object;
                    n2 = ((Party)object2).getAbilityScoreMax(this.ability);
                } else {
                    n2 = RPG.getInstance().party.getAbilityScoreMax(this.ability);
                }
                f = RPG.rand.nextFloat();
                n = n2 - this.dc;
                if (this.mode != Mode.Default) break block39;
                switch (this.ability.skillLevel) {
                    case "easy": {
                        if (n >= 0) {
                            return true;
                        }
                        if (n == -1) {
                            return f <= 0.4f;
                        }
                        if (n == -2) {
                            return f <= 0.25f;
                        }
                        if (n == -3) {
                            return f <= 0.05f;
                        }
                        if (n <= -4) {
                            return false;
                        }
                        break block40;
                    }
                    case "average": {
                        if (n >= 0) {
                            return true;
                        }
                        if (n == -1) {
                            return f <= 0.25f;
                        }
                        if (n == -2) {
                            return f <= 0.05f;
                        }
                        if (n <= -3) {
                            return false;
                        }
                        break block40;
                    }
                    case "hard": {
                        if (n >= 0) {
                            return true;
                        }
                        if (n == -1) {
                            return f <= 0.05f;
                        }
                        if (n <= -2) {
                            return false;
                        }
                        break block40;
                    }
                    case "very hard": {
                        return n >= 0;
                    }
                    default: {
                        assert (false);
                        break block40;
                    }
                }
            }
            if (this.mode == Mode.Wasteland2) {
                if (n <= -3) {
                    return false;
                }
                if (n == -2) {
                    return f <= 0.1f;
                }
                if (n == -1) {
                    return f <= 0.25f;
                }
                if (n == 0) {
                    return f <= 0.6f;
                }
                if (n == 1) {
                    return f <= 0.75f;
                }
                if (n == 2) {
                    return f <= 0.9f;
                }
                if (n >= 3) {
                    return true;
                }
            }
        }
        return true;
    }

    public static enum Mode {
        Default,
        Wasteland2;

    }
}

