/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.check;

import de.slashbinbash.hexen.check.AbilityCheck;
import de.slashbinbash.hexen.check.AbilityRateCheck;
import de.slashbinbash.hexen.check.AbilityRollCheck;
import de.slashbinbash.hexen.check.AndCheck;
import de.slashbinbash.hexen.check.AttributeCheck;
import de.slashbinbash.hexen.check.Checks;
import de.slashbinbash.hexen.check.CombatActionCheck;
import de.slashbinbash.hexen.check.ConditionCheck;
import de.slashbinbash.hexen.check.CountMembersCheck;
import de.slashbinbash.hexen.check.DonationCheck;
import de.slashbinbash.hexen.check.DoorCheck;
import de.slashbinbash.hexen.check.ICheck;
import de.slashbinbash.hexen.check.ItemCheck;
import de.slashbinbash.hexen.check.LearnCombatActionCheck;
import de.slashbinbash.hexen.check.NotCheck;
import de.slashbinbash.hexen.check.OrCheck;
import de.slashbinbash.hexen.check.QuestCheck;
import de.slashbinbash.hexen.check.QuestDurationCheck;
import de.slashbinbash.hexen.check.RandCheck;
import de.slashbinbash.hexen.check.RollCheck;
import de.slashbinbash.hexen.check.StateCheck;
import de.slashbinbash.hexen.check.TimeOfDayCheck;
import de.slashbinbash.hexen.check.TraitCheck;
import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.enums.Attribute;
import de.slashbinbash.hexen.factory.CombatActionFactory;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.model.CombatAction;
import de.slashbinbash.hexen.model.Trait;
import de.slashbinbash.hexen.quest.QuestState;
import de.slashbinbash.util.StaticXML;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class CheckFactory {
    public static AbilityCheck createAbilityCheck(Element element) {
        Ability ability = null;
        int n = 0;
        for (Attr attr : StaticXML.getAttributes(element)) {
            switch (attr.getName()) {
                case "ability": 
                case "name": 
                case "ref": {
                    ability = Ability.valueOf(attr.getValue());
                    break;
                }
                case "dc": 
                case "value": {
                    n = Integer.valueOf(attr.getValue());
                }
            }
        }
        assert (ability != null);
        return new AbilityCheck(ability, n);
    }

    public static AbilityRateCheck createAbilityRateCheck(Element element) {
        Ability ability = null;
        int n = 0;
        for (Attr attr : StaticXML.getAttributes(element)) {
            switch (attr.getName()) {
                case "ability": 
                case "name": 
                case "ref": {
                    ability = Ability.valueOf(attr.getValue());
                    break;
                }
                case "dc": 
                case "value": {
                    n = Integer.valueOf(attr.getValue());
                }
            }
        }
        assert (ability != null);
        return new AbilityRateCheck(ability, n);
    }

    public static AbilityRollCheck createAbilityRollCheck(Element element) {
        Ability ability = null;
        int n = 0;
        for (Attr attr : StaticXML.getAttributes(element)) {
            switch (attr.getName()) {
                case "ability": 
                case "name": 
                case "ref": {
                    ability = Ability.valueOf(attr.getValue());
                    break;
                }
                case "dc": 
                case "value": {
                    n = Integer.valueOf(attr.getValue());
                }
            }
        }
        assert (ability != null);
        return new AbilityRollCheck(ability, n);
    }

    public static AndCheck createAndCheck(Element element) {
        Checks checks = CheckFactory.createChecks(element);
        return new AndCheck(checks);
    }

    public static AttributeCheck createAttributeCheck(Element element) {
        Attribute attribute = null;
        int n = 0;
        for (Attr attr : StaticXML.getAttributes(element)) {
            switch (attr.getName()) {
                case "attribute": 
                case "name": 
                case "ref": {
                    attribute = Attribute.valueOf(attr.getValue());
                    break;
                }
                case "dc": 
                case "value": {
                    n = Integer.valueOf(attr.getValue());
                }
            }
        }
        assert (attribute != null);
        return new AttributeCheck(attribute, n);
    }

    public static Checks createChecks(Element element) {
        Checks checks = new Checks();
        block61: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "AND": {
                    checks.add(CheckFactory.createAndCheck(element2));
                    continue block61;
                }
                case "OR": {
                    checks.add(CheckFactory.createOrCheck(element2));
                    continue block61;
                }
                case "NOT": {
                    checks.add(CheckFactory.createNotCheck(element2));
                    continue block61;
                }
                case "ability": 
                case "abilityCheck": {
                    checks.add(CheckFactory.createAbilityCheck(element2));
                    continue block61;
                }
                case "abilityRateCheck": {
                    checks.add(CheckFactory.createAbilityRateCheck(element2));
                    continue block61;
                }
                case "abilityRollCheck": {
                    checks.add(CheckFactory.createAbilityRollCheck(element2));
                    continue block61;
                }
                case "attribute": 
                case "attributeCheck": {
                    checks.add(CheckFactory.createAttributeCheck(element2));
                    continue block61;
                }
                case "combatAction": 
                case "combatActionCheck": {
                    checks.add(CheckFactory.createCombatActionCheck(element2));
                    continue block61;
                }
                case "condition": 
                case "conditionCheck": {
                    checks.add(CheckFactory.createConditionCheck(element2));
                    continue block61;
                }
                case "countMembers": 
                case "countMembersCheck": {
                    int n = StaticXML.getInt(element2, "value");
                    checks.add(new CountMembersCheck(n));
                    continue block61;
                }
                case "donation": 
                case "donationCheck": {
                    checks.add(CheckFactory.createDonationCheck(element2));
                    continue block61;
                }
                case "doorCheck": {
                    checks.add(CheckFactory.createDoorCheck(element2));
                    continue block61;
                }
                case "item": 
                case "itemCheck": {
                    checks.add(CheckFactory.createItemCheck(element2));
                    continue block61;
                }
                case "learnCombatAction": 
                case "learnCombatActionCheck": {
                    checks.add(CheckFactory.createLearnCombatActionCheck(element2));
                    continue block61;
                }
                case "quest": 
                case "questCheck": {
                    checks.add(CheckFactory.createQuestCheck(element2));
                    continue block61;
                }
                case "questDuration": 
                case "questDurationCheck": {
                    checks.add(CheckFactory.createQuestDurationCheck(element2));
                    continue block61;
                }
                case "random": 
                case "randomCheck": {
                    checks.add(CheckFactory.createRandomCheck(element2));
                    continue block61;
                }
                case "roll": 
                case "rollCheck": {
                    checks.add(CheckFactory.createRollCheck(element2));
                    continue block61;
                }
                case "state": 
                case "stateCheck": {
                    checks.add(CheckFactory.createStateCheck(element2));
                    continue block61;
                }
                case "time": 
                case "timeCheck": {
                    checks.add(CheckFactory.createTimeOfDayCheck(element2));
                    continue block61;
                }
                case "trait": 
                case "traitCheck": {
                    checks.add(CheckFactory.createTraitCheck(element2));
                    continue block61;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return checks;
    }

    public static CombatActionCheck createCombatActionCheck(Element element) {
        CombatAction combatAction = CombatActionFactory.createCombatAction(StaticXML.getAttribute(element, "ref"));
        return new CombatActionCheck(combatAction);
    }

    public static ConditionCheck createConditionCheck(Element element) {
        String string = element.getAttribute("ref");
        ConditionCheck conditionCheck = new ConditionCheck(string);
        if (element.hasAttribute("type")) {
            conditionCheck.type = ConditionCheck.Type.valueOf(element.getAttribute("type"));
        }
        return conditionCheck;
    }

    public static DonationCheck createDonationCheck(Element element) {
        String string = StaticXML.getAttribute(element, "id");
        int n = StaticXML.getInt(element, "amount");
        return new DonationCheck(string, n);
    }

    public static DoorCheck createDoorCheck(Element element) {
        String string = StaticXML.getAttribute(element, "id");
        String string2 = StaticXML.getAttribute(element, "state");
        return new DoorCheck(string, string2);
    }

    public static ItemCheck createItemCheck(Element element) {
        String string = StaticXML.getAttribute(element, "ref");
        int n = StaticXML.getInt(element, "count", 1);
        return new ItemCheck(string, n);
    }

    public static LearnCombatActionCheck createLearnCombatActionCheck(Element element) {
        CombatAction combatAction = CombatActionFactory.createCombatAction(StaticXML.getAttribute(element, "ref"));
        return new LearnCombatActionCheck(combatAction);
    }

    public static NotCheck createNotCheck(Element element) {
        Checks checks = CheckFactory.createChecks(element);
        assert (checks.size() == 1);
        return new NotCheck((ICheck)checks.get(0));
    }

    public static OrCheck createOrCheck(Element element) {
        Checks checks = CheckFactory.createChecks(element);
        return new OrCheck(checks);
    }

    public static QuestCheck createQuestCheck(Element element) {
        String string = StaticXML.getAttribute(element, "ref");
        QuestState questState = QuestState.valueOf(StaticXML.getAttribute(element, "state", null));
        return new QuestCheck(string, questState);
    }

    public static QuestDurationCheck createQuestDurationCheck(Element element) {
        String string = StaticXML.getAttribute(element, "ref");
        long l = Factory.parseDuration(element);
        return new QuestDurationCheck(string, l);
    }

    public static RandCheck createRandomCheck(Element element) {
        float f = StaticXML.getFloat(element, "value");
        return new RandCheck(f);
    }

    public static RollCheck createRollCheck(Element element) {
        int n = StaticXML.getInt(element, "min");
        int n2 = StaticXML.getInt(element, "max");
        int n3 = StaticXML.getInt(element, "dc");
        return new RollCheck(n, n2, n3);
    }

    public static StateCheck createStateCheck(Element element) {
        String string = StaticXML.getAttribute(element, "name");
        String string2 = StaticXML.getAttribute(element, "value", null);
        return new StateCheck(string, string2);
    }

    public static TimeOfDayCheck createTimeOfDayCheck(Element element) {
        int n = Factory.parseTime(StaticXML.getAttribute(element, "from"));
        int n2 = Factory.parseTime(StaticXML.getAttribute(element, "to"));
        return new TimeOfDayCheck(n, n2);
    }

    public static TraitCheck createTraitCheck(Element element) {
        Trait trait = null;
        for (Attr attr : StaticXML.getAttributes(element)) {
            switch (attr.getName()) {
                case "trait": 
                case "name": 
                case "ref": {
                    trait = Trait.valueOf(attr.getValue());
                }
            }
        }
        assert (trait != null);
        return new TraitCheck(trait);
    }
}

