/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.chest;

import de.slashbinbash.hexen.action.ActionFactory;
import de.slashbinbash.hexen.check.CheckFactory;
import de.slashbinbash.hexen.chest.Chest;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.factory.SceneFactory;
import de.slashbinbash.hexen.model.ItemGroup;
import de.slashbinbash.util.StaticXML;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class ChestFactory {
    public static Chest.Data createChestDesc(Element element) {
        Chest.Data data = new Chest.Data();
        data.saveId = StaticXML.getAttribute(element, "id");
        block18: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "scene": {
                    data.scene = SceneFactory.createScene(element2);
                    break;
                }
                case "items": {
                    block19: for (Element element3 : StaticXML.getChildElements(element2)) {
                        switch (element3.getTagName()) {
                            case "item": {
                                if (data.items == null) {
                                    data.items = new ArrayList<ItemGroup>();
                                }
                                data.items.add(Factory.createItemGroup(element3));
                                continue block19;
                            }
                        }
                        StaticXML.errUnknownTag(element3);
                    }
                    continue block18;
                }
                case "lock": {
                    data.lock = ChestFactory.createLockDesc(element2);
                    break;
                }
                case "trap": {
                    data.trap = ChestFactory.createTrapDesc(element2);
                    break;
                }
                default: {
                    StaticXML.errUnknownTag(element2);
                }
            }
        }
        return data;
    }

    public static Chest.Data.Lock createLockDesc(Element element) {
        Chest.Data.Lock lock = new Chest.Data.Lock();
        block13: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "key": {
                    lock.keyItem = StaticXML.getText(element2);
                    continue block13;
                }
                case "password": {
                    lock.password = StaticXML.getText(element2);
                    continue block13;
                }
                case "perception": {
                    lock.perceptionCheck = CheckFactory.createAbilityCheck(element2);
                    continue block13;
                }
                case "hacking": 
                case "lockpicking": {
                    lock.lockpickingCheck = CheckFactory.createAbilityRateCheck(element2);
                    if (!StaticXML.hasAttribute(element2, "item")) continue block13;
                    lock.lockpickItem = StaticXML.getAttribute(element2, "item");
                    continue block13;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return lock;
    }

    public static Chest.Data.Trap createTrapDesc(Element element) {
        Chest.Data.Trap trap = new Chest.Data.Trap();
        block10: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "actions": {
                    trap.actions = ActionFactory.createActions(element2);
                    continue block10;
                }
                case "disarm": {
                    trap.disarmCheck = CheckFactory.createAbilityCheck(element2);
                    if (!StaticXML.hasAttribute(element2, "item")) continue block10;
                    trap.disarmItem = StaticXML.getAttribute(element2, "item");
                    continue block10;
                }
                case "perception": {
                    trap.perceptionCheck = CheckFactory.createAbilityCheck(element2);
                    continue block10;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return trap;
    }
}

