/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.combat;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.combat.CombatFactory;
import de.slashbinbash.hexen.combat.CombatState;
import de.slashbinbash.hexen.combat.Combatant;
import de.slashbinbash.hexen.combat.CombatantGroup;
import de.slashbinbash.hexen.combat.StaticCombat;
import de.slashbinbash.hexen.model.CombatAction;
import java.util.HashMap;
import java.util.List;

public class CombatAI {
    private static final float FRONT_ROW_CHANCE = 0.8f;
    private HashMap<String, Data> dts = new HashMap();
    public CombatState state;

    public CombatAI(CombatState combatState) {
        this.state = combatState;
    }

    private Data getAiData(Combatant combatant) {
        String string = combatant.getId();
        assert (string != null);
        if (this.dts.containsKey(string)) {
            return this.dts.get(string);
        }
        Data data = CombatFactory.createCombatAiData(string);
        this.dts.put(string, data);
        return data;
    }

    public CombatState.Action handle(Combatant combatant) {
        List<Object> list;
        boolean bl;
        assert (!combatant.isSkippingTurn());
        Data data = this.getAiData(combatant);
        boolean bl2 = data != null ? data.canRunAway : true;
        boolean bl3 = bl = data != null ? data.canCallForHelp : false;
        if (this.state.model.canRunAway && bl2 && combatant.canRunAway()) {
            if (combatant.getHitPoints() == 1) {
                return CombatState.Action.RunAway(combatant);
            }
            if (combatant.getActionPoints() == 0) {
                return CombatState.Action.RunAway(combatant);
            }
            if (combatant.team == CombatState.Team.ALLY) {
                list = this.state.getTeam(combatant);
                int n = 0;
                for (Combatant combatant2 : list) {
                    if (combatant2.isActive()) continue;
                    ++n;
                }
                int n2 = RPG.rand.nextInt(list.size()) + 1;
                if (n2 <= n) {
                    return CombatState.Action.RunAway(combatant);
                }
            }
        }
        if (combatant.team == CombatState.Team.ENEMY && bl) {
            float f = data.callForHelpChance;
            CombatantGroup combatantGroup = this.state.getGroup(combatant);
            float f2 = f / (float)combatantGroup.size();
            if (combatantGroup.size() < combatantGroup.maxSize && RPG.rand.nextFloat() < f2) {
                return CombatState.Action.CallForHelp(combatant);
            }
        }
        if ((list = this.state.filterCombatActions(combatant, combatant.getCombatActions())).isEmpty()) {
            return CombatState.Action.Pass(combatant);
        }
        CombatAction combatAction = this.pickCombatAction(combatant, list);
        if (combatAction == null) {
            return CombatState.Action.Pass(combatant);
        }
        CombatantGroup combatantGroup = this.pickObjects(combatant, combatAction);
        if (combatantGroup.isEmpty()) {
            return CombatState.Action.Pass(combatant);
        }
        return CombatState.Action.Attack(combatAction, combatant, combatantGroup);
    }

    private CombatAction pickCombatAction(Combatant combatant, List<CombatAction> list) {
        int n;
        Data data = this.getAiData(combatant);
        if (data != null && data.combatActionWeights != null) {
            n = 0;
            for (CombatAction combatAction : list) {
                n += data.getWeight(combatAction);
            }
            if (n > 0) {
                int n2 = RPG.rand.nextInt(n);
                int n3 = 0;
                for (CombatAction combatAction : list) {
                    int n4 = data.getWeight(combatAction);
                    if (n4 == 0 || n2 >= (n3 += n4)) continue;
                    return combatAction;
                }
            }
            assert (false);
        }
        n = RPG.rand.nextInt(list.size());
        return list.get(n);
    }

    private CombatantGroup pickObjects(Combatant combatant2, CombatAction combatAction) {
        switch (combatAction.getTarget()) {
            case ENEMY_ALL: {
                return new CombatantGroup(this.state.getEnemies(combatant2));
            }
            case ENEMY_GROUP_ALL: 
            case ENEMY_GROUP_ONE: {
                List<CombatantGroup> list = StaticCombat.filterRangeGroups(combatAction, combatant2, this.state.getEnemyGroups(combatant2));
                if (list.isEmpty()) {
                    return new CombatantGroup();
                }
                Combatant combatant3 = combatant2.getHighestDamageDealer();
                if (combatant3 != null) {
                    for (CombatantGroup combatantGroup : list) {
                        if (!combatantGroup.contains(combatant3)) continue;
                        return combatantGroup;
                    }
                }
                return list.get(RPG.rand.nextInt(list.size()));
            }
            case ENEMY_ONE: {
                List<Combatant> list = StaticCombat.filterRangeCombatants(combatAction, combatant2, this.state.getEnemies(combatant2));
                if (list.isEmpty()) {
                    return new CombatantGroup();
                }
                Combatant combatant4 = combatant2.getHighestDamageDealer();
                if (combatant4 == null) {
                    int n = list.size();
                    if (!combatAction.isRanged() && RPG.rand.nextFloat() <= 0.8f) {
                        n = Math.min(3, n);
                    }
                    combatant4 = list.get(RPG.rand.nextInt(n));
                }
                return new CombatantGroup(combatant4);
            }
            case PARTY_ALL: {
                return new CombatantGroup(this.state.getAllies(combatant2));
            }
            case PARTY_ONE: {
                List<Combatant> list = this.state.getAllies(combatant2).stream().filter(combatant -> combatant.isActive()).toList();
                if (list.isEmpty()) {
                    return new CombatantGroup();
                }
                Combatant combatant5 = list.get(RPG.rand.nextInt(list.size()));
                return new CombatantGroup(combatant5);
            }
            case SELF: {
                return new CombatantGroup(combatant2);
            }
        }
        return null;
    }

    public static class Data {
        public HashMap<String, Integer> combatActionWeights = null;
        public int groupSizeMin = 0;
        public int groupSizeMax = 0;
        public boolean canRunAway = true;
        public boolean canCallForHelp = false;
        public float callForHelpChance = 0.0f;

        public int getWeight(CombatAction combatAction) {
            String string = combatAction.getId();
            return this.combatActionWeights.containsKey(string) ? this.combatActionWeights.get(string) : 0;
        }
    }
}

