/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.combat;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.action.ActionFactory;
import de.slashbinbash.hexen.combat.CombatAI;
import de.slashbinbash.hexen.combat.CombatDescriptor;
import de.slashbinbash.hexen.combat.CombatModel;
import de.slashbinbash.hexen.combat.CombatState;
import de.slashbinbash.hexen.factory.CreatureFactory;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.model.ItemLoot;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CombatFactory {
    public static CombatDescriptor createCombatDescriptor(Element element) {
        CombatDescriptor combatDescriptor = new CombatDescriptor();
        block47: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "ambush": 
                case "ambushed": {
                    combatDescriptor.ambushed = Boolean.valueOf(StaticXML.getText(element2));
                    break;
                }
                case "canRunAway": {
                    combatDescriptor.canRunAway = Boolean.valueOf(StaticXML.getText(element2));
                    break;
                }
                case "runAwayChance": {
                    combatDescriptor.runAwayChance = Float.valueOf(StaticXML.getText(element2)).floatValue();
                    break;
                }
                case "groups": {
                    Object object;
                    block48: for (Element element3 : StaticXML.getChildElements(element2)) {
                        switch (element3.getTagName()) {
                            case "group": {
                                object = new CombatDescriptor.Group();
                                ((CombatDescriptor.Group)object).creature = StaticXML.getAttribute(element3, "ref");
                                if (StaticXML.hasAttribute(element3, "min") && StaticXML.hasAttribute(element3, "max")) {
                                    ((CombatDescriptor.Group)object).min = StaticXML.getInt(element3, "min");
                                    ((CombatDescriptor.Group)object).max = StaticXML.getInt(element3, "max");
                                }
                                if (StaticXML.hasAttribute(element3, "range")) {
                                    ((CombatDescriptor.Group)object).range = StaticXML.getInt(element3, "range");
                                }
                                combatDescriptor.enemyGroups.add((CombatDescriptor.Group)object);
                                continue block48;
                            }
                        }
                        StaticXML.errUnknownTag(element3);
                    }
                    continue block47;
                }
                case "begin": {
                    block49: for (Element element3 : StaticXML.getChildElements(element2)) {
                        switch (element3.getTagName()) {
                            case "text": {
                                combatDescriptor.beginText = Factory.unformatMD(StaticXML.getText(element3));
                                continue block49;
                            }
                            case "actions": {
                                combatDescriptor.beginActions = ActionFactory.createActions(element3);
                                continue block49;
                            }
                        }
                        StaticXML.errUnknownTag(element3);
                    }
                    continue block47;
                }
                case "end": {
                    block50: for (Element element3 : StaticXML.getChildElements(element2)) {
                        switch (element3.getTagName()) {
                            case "text": {
                                combatDescriptor.endText = Factory.unformatMD(StaticXML.getText(element3));
                                continue block50;
                            }
                            case "actions": {
                                combatDescriptor.endActions = ActionFactory.createActions(element3);
                                continue block50;
                            }
                        }
                        StaticXML.errUnknownTag(element3);
                    }
                    continue block47;
                }
                case "loot": {
                    Object object;
                    combatDescriptor.customLoot = new ArrayList<ItemLoot>();
                    block51: for (Element element3 : StaticXML.getChildElements(element2)) {
                        switch (element3.getTagName()) {
                            case "item": {
                                object = new ItemLoot();
                                ((ItemLoot)object).itemID = StaticXML.getAttribute(element3, "ref");
                                ((ItemLoot)object).amount = StaticXML.getInt(element3, "amount");
                                combatDescriptor.customLoot.add((ItemLoot)object);
                                continue block51;
                            }
                        }
                        StaticXML.errUnknownTag(element3);
                    }
                    continue block47;
                }
                default: {
                    StaticXML.errUnknownTag(element2);
                }
            }
        }
        return combatDescriptor;
    }

    public static CombatModel createCombatModel(CombatDescriptor combatDescriptor) {
        CombatModel combatModel = new CombatModel();
        combatModel.customLoot = combatDescriptor.customLoot;
        combatModel.canRunAway = combatDescriptor.canRunAway;
        combatModel.runAwayChance = combatDescriptor.runAwayChance;
        combatModel.ambushed = combatDescriptor.ambushed;
        combatModel.ambushing = combatDescriptor.ambushing;
        combatModel.beginText = combatDescriptor.beginText;
        combatModel.beginActions = combatDescriptor.beginActions;
        combatModel.endText = combatDescriptor.endText;
        combatModel.endActions = combatDescriptor.endActions;
        for (CombatDescriptor.Group group : combatDescriptor.enemyGroups) {
            CombatAI.Data data = CombatFactory.createCombatAiData(group.creature);
            int n = 0;
            int n2 = 0;
            if (data != null) {
                n = data.groupSizeMin;
                n2 = data.groupSizeMax;
            }
            if (group.min > 0 && group.max > 0) {
                n = group.min;
                n2 = group.max;
            }
            if (n == 0) {
                n = 1;
            }
            if (n2 == 0) {
                n2 = 1;
            }
            assert (n > 0);
            assert (n2 > 0);
            CombatModel.Group group2 = new CombatModel.Group();
            group2.maxSize = n2;
            group2.range = group.range;
            int n3 = 1;
            n3 = n == n2 ? n2 : RPG.rand.nextInt(n, n2 + 1);
            for (int i = 0; i < n3; ++i) {
                group2.creatures.add(CreatureFactory.createCreature(group.creature));
            }
            combatModel.enemyGroups.add(group2);
        }
        return combatModel;
    }

    public static CombatState createCombatState(CombatDescriptor combatDescriptor) {
        CombatModel combatModel = CombatFactory.createCombatModel(combatDescriptor);
        return new CombatState(combatModel);
    }

    public static CombatAI.Data createCombatAiData(String string) {
        if (string == null) {
            return null;
        }
        try {
            Document document = StaticXML.loadXML(new File(Factory.CREATURE_PATH + string + ".xml"));
            Element element = document.getDocumentElement();
            Element element2 = StaticXML.getElement(element, "combatAi");
            if (element2 != null) {
                CombatAI.Data data = new CombatAI.Data();
                block15: for (Element element3 : StaticXML.getChildElements(element2)) {
                    switch (element3.getTagName()) {
                        case "canRunAway": {
                            data.canRunAway = Boolean.valueOf(StaticXML.getText(element3));
                            break;
                        }
                        case "callForHelpChance": {
                            float f = Float.valueOf(StaticXML.getText(element3)).floatValue();
                            data.canCallForHelp = f > 0.0f;
                            data.callForHelpChance = f;
                            break;
                        }
                        case "combatActions": {
                            data.combatActionWeights = new HashMap();
                            for (Element element4 : StaticXML.getChildElements(element3)) {
                                String string2 = StaticXML.getAttribute(element4, "ref");
                                int n = StaticXML.getInt(element4, "weight");
                                data.combatActionWeights.put(string2, n);
                            }
                            continue block15;
                        }
                        case "groupSize": {
                            data.groupSizeMin = StaticXML.getInt(element3, "min");
                            data.groupSizeMax = StaticXML.getInt(element3, "max");
                            break;
                        }
                        default: {
                            StaticXML.errUnknownTag(element3);
                        }
                    }
                }
                return data;
            }
            return null;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }
}

