/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.combat;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.Roll;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.action.SummonCreature;
import de.slashbinbash.hexen.combat.CombatAI;
import de.slashbinbash.hexen.combat.CombatLog;
import de.slashbinbash.hexen.combat.CombatModel;
import de.slashbinbash.hexen.combat.Combatant;
import de.slashbinbash.hexen.combat.CombatantGroup;
import de.slashbinbash.hexen.combat.StaticCombat;
import de.slashbinbash.hexen.factory.CreatureFactory;
import de.slashbinbash.hexen.factory.ItemFactory;
import de.slashbinbash.hexen.message.Message;
import de.slashbinbash.hexen.message.MessageBus;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.CombatAction;
import de.slashbinbash.hexen.model.CombatActions;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.ItemData;
import de.slashbinbash.hexen.model.ItemLoot;
import de.slashbinbash.hexen.model.ItemType;
import java.util.ArrayList;
import java.util.List;

public class CombatState {
    public CombatModel model = null;
    public CombatAI combatAI = new CombatAI(this);
    public List<Combatant> initiatives = new ArrayList<Combatant>();
    public List<Combatant> allies = new ArrayList<Combatant>();
    public List<Combatant> enemies = new ArrayList<Combatant>();
    public List<CombatantGroup> allyGroups = new ArrayList<CombatantGroup>(2);
    public List<CombatantGroup> enemyGroups = new ArrayList<CombatantGroup>(3);
    public List<ItemLoot> loot = null;
    public Stat state = Stat.INIT;
    public CombatLog combatLog = new CombatLog();

    public CombatState(CombatModel combatModel) {
        RPG rPG = RPG.getInstance();
        this.model = combatModel;
        for (int i = 0; i < 2; ++i) {
            this.allyGroups.add(new CombatantGroup());
        }
        for (ClassCreature object : rPG.party.getMembers()) {
            this.allies.add(new Combatant(object, Team.ALLY, object.playable));
        }
        this.updateAllyPositions();
        for (CombatModel.Group group : combatModel.enemyGroups) {
            CombatantGroup combatantGroup = new CombatantGroup();
            combatantGroup.maxSize = group.maxSize;
            combatantGroup.range = group.range;
            this.enemyGroups.add(combatantGroup);
            for (ClassCreature classCreature : group.creatures) {
                Combatant combatant = new Combatant(classCreature, Team.ENEMY, false);
                this.enemies.add(combatant);
                combatantGroup.add(combatant);
            }
        }
        this.updateEnemyPositions();
        this.updateInitiatives(this.allies, this.enemies, this.initiatives);
        if (!combatModel.ambushed && !combatModel.ambushing) {
            int n = Roll.d20();
            combatModel.ambushed = n == 1;
            boolean bl = combatModel.ambushing = n == 20;
        }
        if (combatModel.ambushed) {
            for (Combatant combatant : this.allies) {
                combatant.ambushed = combatModel.ambushed;
            }
        }
        if (combatModel.ambushing) {
            for (Combatant combatant : this.enemies) {
                combatant.ambushed = combatModel.ambushing;
            }
        }
        for (Combatant combatant : this.allies) {
            if (!combatant.isAlive()) continue;
            ++combatant.creature.numCombats;
        }
    }

    private void doAction(Action action) {
        if (action == null) {
            return;
        }
        Combatant combatant = action.subject;
        if (action.objects != null && !action.objects.isActive()) {
            action.action = ActionEnum.PASS;
        }
        switch (action.action.ordinal()) {
            case 0: {
                if (this.isSummonAction(action.combatAction)) {
                    StaticCombat.doSummonAction(action.combatAction, action.subject, this.getTeam(combatant.team), this.combatLog);
                    break;
                }
                StaticCombat.doCombatAction(action.combatAction, action.subject, action.objects, this.combatLog);
                break;
            }
            case 1: {
                StaticRPG.Result result = StaticRPG.useItem(action.subject.creature, action.item, action.subject.creature);
                this.combatLog.UseItem(action.subject, action.item, result == StaticRPG.Result.OK);
                break;
            }
            case 2: {
                if (!this.model.canRunAway || combatant.cannotRun()) {
                    this.combatLog.RunAway(combatant, false);
                    break;
                }
                StaticCombat.doRunAway(combatant, this.model.runAwayChance, this.combatLog);
                break;
            }
            case 3: {
                this.combatLog.Pass(action.subject);
                break;
            }
            case 4: {
                CombatantGroup combatantGroup;
                assert (action.subject.team == Team.ENEMY);
                int n = 0;
                int n2 = combatantGroup.maxSize;
                combatantGroup = this.getGroup(action.subject);
                int n3 = n2 - combatantGroup.size();
                if (n3 > 0) {
                    int n4 = RPG.rand.nextInt(n3) + 1;
                    List<Combatant> list = this.getTeam(action.subject.team);
                    for (int i = 0; i < n4; ++i) {
                        ClassCreature classCreature = CreatureFactory.createCreature(action.subject.getId());
                        Combatant combatant2 = new Combatant(classCreature, action.subject.team, action.subject.isPlayable);
                        list.add(combatant2);
                        combatantGroup.add(combatant2);
                        ++n;
                    }
                }
                this.combatLog.CallForHelp(action.subject, n);
                break;
            }
            case 5: {
                assert (false) : "TODO implement";
                break;
            }
            case 6: {
                assert (false) : "TODO implement";
                break;
            }
        }
    }

    public void exit() {
        if (this.state == Stat.EXIT) {
            this.removeExpiredConditions();
            this.initiatives.clear();
            this.enemies.clear();
            this.allies.clear();
            this.combatLog.clear();
            if (this.model.endActions != null) {
                this.model.endActions.performAll(null);
            }
            MessageBus.push(Message.COMBAT_ON_EXIT, this);
        }
    }

    public List<CombatAction> filterCombatActions(Combatant combatant, CombatActions combatActions) {
        ArrayList<CombatAction> arrayList = new ArrayList<CombatAction>();
        assert (combatActions.size() <= 6);
        int n = Math.min(combatActions.size(), 6);
        block7: for (int i = 0; i < n; ++i) {
            CombatAction combatAction = combatActions.get(i);
            if (combatAction.getActionPointCost() > combatant.getActionPoints()) continue;
            switch (combatAction.getTarget()) {
                case ENEMY_ALL: 
                case PARTY_ALL: 
                case PARTY_GROUP_ALL: 
                case PARTY_ONE: 
                case SELF: {
                    arrayList.add(combatAction);
                    continue block7;
                }
                default: {
                    int n2 = combatAction.getRangeFrom().ordinal() - combatant.range - 1;
                    int n3 = combatAction.getRangeTo().ordinal() - combatant.range - 1;
                    if (n2 < 0 && n3 < 0) continue block7;
                    n2 = Math.max(n2, 0);
                    switch (combatAction.getTarget()) {
                        case ENEMY_GROUP_ALL: 
                        case ENEMY_GROUP_ONE: {
                            for (CombatantGroup combatantGroup : this.getEnemyGroups(combatant)) {
                                if (!combatantGroup.isActive() || combatantGroup.range < n2 || combatantGroup.range > n3) continue;
                                arrayList.add(combatAction);
                                continue block7;
                            }
                            continue block7;
                        }
                        case ENEMY_ONE: {
                            for (Combatant combatant2 : this.getEnemies(combatant)) {
                                if (!combatant2.isActive() || combatant2.range < n2 || combatant2.range > n3) continue;
                                arrayList.add(combatAction);
                                continue block7;
                            }
                            continue block7;
                        }
                        default: {
                            assert (false) : "Bad option";
                            arrayList.add(combatAction);
                        }
                    }
                }
            }
        }
        return arrayList;
    }

    public Action findAction(List<Action> list, Combatant combatant) {
        for (Action action : list) {
            if (action.subject != combatant) continue;
            return action;
        }
        return null;
    }

    public List<Combatant> getAllies(Combatant combatant) {
        switch (combatant.team.ordinal()) {
            case 0: {
                return this.allies;
            }
            case 1: {
                return this.enemies;
            }
        }
        return null;
    }

    public List<CombatantGroup> getAllyGroups(Combatant combatant) {
        switch (combatant.team.ordinal()) {
            case 0: {
                return this.allyGroups;
            }
            case 1: {
                return this.enemyGroups;
            }
        }
        return null;
    }

    public List<Combatant> getEnemies(Combatant combatant) {
        switch (combatant.team.ordinal()) {
            case 0: {
                return this.enemies;
            }
            case 1: {
                return this.allies;
            }
        }
        return null;
    }

    public List<CombatantGroup> getEnemyGroups(Combatant combatant) {
        switch (combatant.team.ordinal()) {
            case 0: {
                return this.enemyGroups;
            }
            case 1: {
                return this.allyGroups;
            }
        }
        return null;
    }

    public CombatantGroup getGroup(Combatant combatant) {
        switch (combatant.team.ordinal()) {
            case 0: {
                for (CombatantGroup combatantGroup : this.allyGroups) {
                    if (!combatantGroup.contains(combatant)) continue;
                    return combatantGroup;
                }
                break;
            }
            case 1: {
                for (CombatantGroup combatantGroup : this.enemyGroups) {
                    if (!combatantGroup.contains(combatant)) continue;
                    return combatantGroup;
                }
                break;
            }
        }
        return null;
    }

    public List<Combatant> getTeam(Combatant combatant) {
        switch (combatant.team.ordinal()) {
            case 0: {
                return this.allies;
            }
            case 1: {
                return this.enemies;
            }
        }
        return null;
    }

    public List<Combatant> getTeam(Team team) {
        switch (team.ordinal()) {
            case 0: {
                return this.allies;
            }
            case 1: {
                return this.enemies;
            }
        }
        return null;
    }

    public void init() {
        assert (this.state == Stat.INIT);
        if (this.model.beginText != null) {
            this.combatLog.add(this.model.beginText + "\n", new Object[0]);
        }
        if (this.model.ambushed) {
            this.combatLog.AmbushedBy(this.enemyGroups);
        } else if (this.model.ambushing) {
            this.combatLog.Ambushing(this.enemyGroups);
        } else {
            this.combatLog.AttackedBy(this.enemyGroups);
        }
        MessageBus.push(Message.COMBAT_ON_ENTER, this);
        this.state = Stat.RUN;
    }

    private boolean isActive(List<Combatant> list) {
        for (Combatant combatant : list) {
            if (!combatant.isAlive() || combatant.hasRunAway()) continue;
            return true;
        }
        return false;
    }

    private boolean isCombatOver() {
        return !this.isActive(this.allies) || !this.isActive(this.enemies);
    }

    private boolean isSummonAction(CombatAction combatAction) {
        for (de.slashbinbash.hexen.action.Action action : combatAction.getActions()) {
            if (!(action instanceof SummonCreature)) continue;
            return true;
        }
        return false;
    }

    public int calcValue(List<ItemLoot> list, float f) {
        int n = 0;
        for (ItemLoot itemLoot : list) {
            ItemData itemData = ItemFactory.createItemDesc(itemLoot.itemID);
            if (itemData.type == ItemType.Quest) continue;
            n += itemData.value * itemLoot.amount;
        }
        return (int)((float)n * f);
    }

    public void loot(boolean bl) {
        assert (this.state == Stat.LOOT);
        if (this.isActive(this.allies)) {
            if (bl) {
                for (ItemLoot itemLoot : this.loot) {
                    RPG.getInstance().party.inventory.add(itemLoot.itemID, itemLoot.amount);
                }
            } else {
                int n = 0;
                for (ItemLoot itemLoot : this.loot) {
                    ItemData itemData = ItemFactory.createItemDesc(itemLoot.itemID);
                    if (itemData.type == ItemType.Quest) {
                        RPG.getInstance().party.inventory.add(itemLoot.itemID, itemLoot.amount);
                        continue;
                    }
                    n += itemData.value * itemLoot.amount;
                }
                n = (int)((float)n * 0.5f);
                RPG.getInstance().party.inventory.addCurrency(n);
            }
        }
        this.state = Stat.EXIT;
    }

    public List<ItemLoot> getLoot() {
        assert (this.state == Stat.LOOT);
        return this.loot;
    }

    private void prepareLoot() {
        List<ItemLoot> list = StaticCombat.lootCombatants(this.enemies);
        if (this.model.customLoot != null) {
            list.addAll(this.model.customLoot);
        }
        this.loot = list;
    }

    private void removeExpiredConditions() {
        RPG rPG = RPG.getInstance();
        for (ClassCreature classCreature : rPG.party.getMembers()) {
            classCreature.removeConditionsIf(condition -> condition.timeLeftSeconds == 0L);
        }
    }

    public void runCombat(List<Action> list) {
        assert (this.state == Stat.RUN);
        this.combatLog.clear();
        MessageBus.push(Message.COMBAT_ON_TURN, this);
        for (Combatant combatant : this.initiatives) {
            if (combatant.isDead() || combatant.hasRunAway()) continue;
            StaticCombat.doConditions(combatant, this.combatLog);
            if (combatant.ambushed) {
                combatant.ambushed = false;
                continue;
            }
            if (combatant.isDead()) {
                this.combatLog.Defeated(combatant);
                continue;
            }
            if (combatant.isSkippingTurn()) {
                this.combatLog.Pass(combatant);
                continue;
            }
            Action action = combatant.isPlayable ? this.findAction(list, combatant) : this.combatAI.handle(combatant);
            this.doAction(action);
        }
        StaticCombat.tickConditions(1, this.initiatives);
        this.updateAllyPositions();
        this.updateEnemyPositions();
        this.updateInitiatives(this.allies, this.enemies, this.initiatives);
        RPG.getInstance().passTime(1L);
        if (this.isCombatOver()) {
            this.updateBestiary(this.enemies);
            if (this.isActive(this.allies)) {
                this.prepareLoot();
                this.state = this.loot != null && !this.loot.isEmpty() ? Stat.LOOT : Stat.EXIT;
            } else {
                this.state = Stat.EXIT;
            }
        }
    }

    public boolean tryRunAway() {
        boolean bl;
        boolean bl2 = bl = this.model.canRunAway && StaticCombat.tryRunAway(this.allies, this.model.runAwayChance);
        if (bl || this.model.ambushing) {
            this.state = Stat.EXIT;
            return true;
        }
        return false;
    }

    private void updateAllyPositions() {
        for (Combatant object : this.allies) {
            if (object.hasRunAway()) {
                object.sorter = 2;
                continue;
            }
            if (object.isDead()) {
                object.sorter = 1;
                continue;
            }
            object.sorter = 0;
        }
        this.allies.sort((combatant, combatant2) -> combatant.sorter - combatant2.sorter);
        int n = 0;
        while (n < this.allyGroups.size()) {
            CombatantGroup combatantGroup = this.allyGroups.get(n);
            combatantGroup.clear();
            combatantGroup.range = n++;
        }
        for (n = 0; n < this.allies.size(); ++n) {
            int n2 = Math.min(n / 3, 1);
            Combatant combatant3 = this.allies.get(n);
            combatant3.range = n2;
            this.allyGroups.get(n2).add(combatant3);
        }
    }

    private void updateBestiary(List<Combatant> list) {
        if (!this.isActive(this.allies)) {
            return;
        }
        RPG rPG = RPG.getInstance();
        for (Combatant combatant : list) {
            if (combatant.hasRunAway()) continue;
            assert (combatant.isDead());
            rPG.bestiarySystem.defeated(combatant.getId(), 1);
        }
    }

    private void updateEnemyPositions() {
        this.enemies.removeIf(combatant -> combatant.hasRunAway());
        for (Combatant object : this.enemies) {
            object.sorter = object.isDead() ? 1 : 0;
        }
        this.enemies.sort((combatant, combatant2) -> combatant.sorter - combatant2.sorter);
        for (CombatantGroup combatantGroup2 : this.enemyGroups) {
            combatantGroup2.removeIf(combatant -> combatant.isDead() || combatant.hasRunAway());
        }
        this.enemyGroups.removeIf(combatantGroup -> combatantGroup.isEmpty());
        if (!this.enemyGroups.isEmpty()) {
            boolean bl = false;
            for (CombatantGroup combatantGroup3 : this.enemyGroups) {
                if (combatantGroup3.range != 0) continue;
                bl = true;
                break;
            }
            if (!bl) {
                for (CombatantGroup combatantGroup4 : this.enemyGroups) {
                    if (combatantGroup4.range <= 0) continue;
                    --combatantGroup4.range;
                }
            }
        }
        for (CombatantGroup combatantGroup5 : this.enemyGroups) {
            for (Combatant combatant3 : combatantGroup5) {
                combatant3.range = combatantGroup5.range;
            }
        }
    }

    private void updateInitiatives(List<Combatant> list, List<Combatant> list2, List<Combatant> list3) {
        list3.clear();
        for (Combatant combatant3 : list) {
            if (!combatant3.isAlive() || combatant3.hasRunAway()) continue;
            list3.add(combatant3);
        }
        for (Combatant combatant3 : list2) {
            if (!combatant3.isAlive() || combatant3.hasRunAway()) continue;
            list3.add(combatant3);
        }
        list3.sort((combatant, combatant2) -> combatant2.getInitiative() - combatant.getInitiative());
    }

    public static enum Stat {
        unknown,
        INIT,
        RUN,
        LOOT,
        EXIT;

    }

    public static enum Team {
        ALLY,
        ENEMY;

    }

    public static class Action {
        public ActionEnum action = null;
        public CombatAction combatAction = null;
        public Combatant subject = null;
        public CombatantGroup objects = null;
        public Item item = null;

        public static Action Attack(CombatAction combatAction, Combatant combatant, Combatant combatant2) {
            assert (combatAction != null);
            assert (combatant != null);
            assert (combatant2 != null);
            CombatantGroup combatantGroup = new CombatantGroup();
            combatantGroup.add(combatant2);
            return Action.Attack(combatAction, combatant, combatantGroup);
        }

        public static Action Attack(CombatAction combatAction, Combatant combatant, CombatantGroup combatantGroup) {
            assert (combatAction != null);
            assert (combatant != null);
            assert (combatantGroup != null);
            assert (!combatantGroup.isEmpty());
            Action action = new Action(ActionEnum.ATTACK);
            action.combatAction = combatAction;
            action.subject = combatant;
            action.objects = combatantGroup;
            return action;
        }

        public static Action CallForHelp(Combatant combatant) {
            assert (combatant != null);
            Action action = new Action(ActionEnum.CALL_FOR_HELP);
            action.subject = combatant;
            return action;
        }

        public static Action Pass(Combatant combatant) {
            assert (combatant != null);
            Action action = new Action(ActionEnum.PASS);
            action.subject = combatant;
            return action;
        }

        public static Action RunAway(Combatant combatant) {
            assert (combatant != null);
            Action action = new Action(ActionEnum.RUN_AWAY);
            action.subject = combatant;
            return action;
        }

        public static Action MoveBackward(Combatant combatant) {
            assert (combatant != null);
            Action action = new Action(ActionEnum.MOVE_BACKWARD);
            action.subject = combatant;
            return action;
        }

        public static Action MoveForward(Combatant combatant) {
            assert (combatant != null);
            Action action = new Action(ActionEnum.MOVE_FORWARD);
            action.subject = combatant;
            return action;
        }

        public static Action UseItem(Item item, Combatant combatant) {
            assert (item != null);
            assert (combatant != null);
            Action action = new Action(ActionEnum.USE_ITEM);
            action.item = item;
            action.subject = combatant;
            return action;
        }

        public Action(ActionEnum actionEnum) {
            this.action = actionEnum;
        }

        public void clear() {
            this.action = null;
            this.combatAction = null;
            this.subject = null;
            this.objects = null;
            this.item = null;
        }
    }

    public static enum ActionEnum {
        ATTACK,
        USE_ITEM,
        RUN_AWAY,
        PASS,
        CALL_FOR_HELP,
        MOVE_FORWARD,
        MOVE_BACKWARD;

    }
}

