/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.combat;

import de.slashbinbash.hexen.combat.CombatState;
import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.CombatActions;
import de.slashbinbash.hexen.model.Condition;
import de.slashbinbash.hexen.model.Damage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class Combatant {
    public ClassCreature creature;
    public CombatState.Team team;
    public int range = 0;
    public boolean runAway = false;
    public boolean isPlayable = false;
    public boolean checkDefeated = false;
    public boolean ambushed = false;
    public int sorter = 0;
    private CombatActions combatActions = new CombatActions();
    private HashMap<Combatant, Integer> dmgstats = new HashMap();

    public Combatant(ClassCreature classCreature, CombatState.Team team, boolean bl) {
        this.creature = classCreature;
        this.team = team;
        this.isPlayable = bl;
        int n = Math.min(6, classCreature.combatActions.size());
        for (int i = 0; i < n; ++i) {
            this.combatActions.add(classCreature.combatActions.get(i));
        }
    }

    public void addCondition(Condition condition) {
        this.creature.addCondition(condition);
    }

    public boolean cannotDefend() {
        for (Condition condition : this.creature.getConditions()) {
            if (!condition.cannotDefend()) continue;
            return true;
        }
        return false;
    }

    public boolean cannotRun() {
        if (this.creature.hasConditions()) {
            for (Condition condition : this.creature.getConditions()) {
                if (!condition.cannotRunAway()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canRunAway() {
        return !this.cannotRun();
    }

    public int getActionPoints() {
        return this.creature.actionPoints;
    }

    public CombatActions getCombatActions() {
        return this.combatActions;
    }

    public List<Condition> getConditions() {
        return this.creature.getConditions();
    }

    public float getCritChance() {
        return this.creature.calcCritChance();
    }

    public float getCritMultiplier() {
        return this.creature.calcCritMultiplier();
    }

    public int getDamageAttack(Damage damage) {
        return this.creature.calcDamageAttack(damage);
    }

    public float getDamageMultiplier(Damage damage) {
        return this.creature.calcDamageMultiplier(damage);
    }

    private int getDamageRecord(Combatant combatant) {
        return this.dmgstats.containsKey(combatant) ? this.dmgstats.get(combatant) : 0;
    }

    public int getDamageReduction(Damage damage) {
        return this.creature.calcDamageReduction(damage);
    }

    public float getDamageResistance(Damage damage) {
        return this.creature.calcDamageResistance(damage);
    }

    public Combatant getHighestDamageDealer() {
        Map.Entry<Combatant, Integer> entry = null;
        for (Map.Entry<Combatant, Integer> entry2 : this.dmgstats.entrySet()) {
            if (entry == null) {
                entry = entry2;
                continue;
            }
            if (entry2.getValue() <= entry.getValue()) continue;
            entry = entry2;
        }
        return entry != null ? (Combatant)entry.getKey() : null;
    }

    public float getHitChanceAttacker() {
        return this.creature.calcHitChanceAttacker();
    }

    public float getHitChanceDefender() {
        return this.creature.calcHitChanceDefender();
    }

    public int getHitPoints() {
        return this.creature.hitPoints;
    }

    public String getId() {
        return this.creature.__id__;
    }

    public int getInitiative() {
        return this.creature.calcAbilityScore(Ability.valueOf("initiative"));
    }

    public int getMaxActionPoints() {
        return this.creature.calcMaxActionPoints();
    }

    public int getMaxHitPoints() {
        return this.creature.calcMaxHitPoints();
    }

    public String getName() {
        return this.creature.name;
    }

    public float getRunAwayChance() {
        return this.creature.calcRunAwayChance();
    }

    public boolean hasCondition(Condition condition) {
        return this.creature.hasCondition(condition);
    }

    public boolean hasConditions() {
        return this.creature.hasConditions();
    }

    public boolean hasImmunities() {
        return this.creature.hasImmunities();
    }

    public boolean hasRunAway() {
        return this.runAway;
    }

    public boolean isActive() {
        return this.isAlive() && !this.hasRunAway();
    }

    public boolean isAlive() {
        return !this.creature.isDead();
    }

    public boolean isDead() {
        return this.creature.isDead();
    }

    public boolean isImmuneToCondition(Condition condition) {
        return this.creature.isImmuneToCondition(condition);
    }

    public boolean isImmuneToCrits() {
        return this.creature.isImmuneToCrits();
    }

    public boolean isSkippingTurn() {
        if (!this.creature.hasConditions()) {
            return false;
        }
        for (Condition condition : this.creature.getConditions()) {
            if (!condition.skipCombatTurn()) continue;
            return true;
        }
        return false;
    }

    public void recordDamage(Combatant combatant, int n) {
        this.dmgstats.put(combatant, this.getDamageRecord(combatant) + n);
    }

    public void removeCondition(Condition condition) {
        this.creature.removeCondition(condition);
    }

    public void removeCondition(String string) {
        this.creature.removeCondition(string);
    }

    public List<Condition> removeConditionsIf(Predicate<Condition> predicate) {
        return this.creature.removeConditionsIf(predicate);
    }

    public void tickConditions(int n) {
        this.creature.tickConditions(n);
    }
}

