/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.deadpool;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.deadpool.DeadpoolSystem;
import de.slashbinbash.hexen.guild.Guild;
import de.slashbinbash.hexen.guild.GuildFactory;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.ItemType;
import de.slashbinbash.hexen.model.Party;
import java.util.ArrayList;
import java.util.List;

public class StaticDeadpool {
    public static void abandonParty() {
        RPG.getInstance().deadpoolSystem.set(null);
    }

    public static boolean leaveParty() {
        RPG rPG = RPG.getInstance();
        if (rPG.party.getMembers().isEmpty()) {
            return false;
        }
        String string = rPG.party.guild;
        if (string == null) {
            return false;
        }
        List<Item> list = null;
        Object object = rPG.deadpoolSystem;
        ((DeadpoolSystem)object).set(rPG.party);
        list = StaticDeadpool.removeQuestItems(rPG.party);
        rPG.party = null;
        object = GuildFactory.createGuildData(string);
        Guild.Location location = ((Guild.Data)object).location;
        Party party = new Party();
        party.guild = string;
        for (Item item : list) {
            party.inventory.add(item);
        }
        rPG.party = party;
        StaticRPG.relocate(rPG.party, location.map, location.level, location.x, location.y);
        return true;
    }

    private static List<Item> removeQuestItems(Party party) {
        ArrayList<Item> arrayList = new ArrayList<Item>();
        for (Item item : party.inventory) {
            if (item.getType() != ItemType.Quest) continue;
            arrayList.add(item);
        }
        for (Item item : arrayList) {
            party.inventory.remove(item);
        }
        return arrayList;
    }

    public static SearchResult searchParty() {
        Location location = RPG.getInstance().party.getLocation();
        DeadpoolSystem deadpoolSystem = RPG.getInstance().deadpoolSystem;
        DeadpoolSystem.Entry entry = deadpoolSystem.searchLevel(location.mapId, location.level);
        if (entry == null) {
            return null;
        }
        SearchResult searchResult = new SearchResult();
        searchResult.x = entry.location.x;
        searchResult.y = entry.location.y;
        searchResult.partySize = entry.party.getMembers().size();
        searchResult.inventorySize = entry.party.inventory.size();
        return searchResult;
    }

    public static class SearchResult {
        public int x;
        public int y;
        public int partySize;
        public int inventorySize;
    }
}

