/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.encounter;

import de.slashbinbash.hexen.EngineConfig;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.action.Action;
import de.slashbinbash.hexen.combat.CombatDescriptor;
import de.slashbinbash.hexen.combat.CombatFactory;
import de.slashbinbash.hexen.combat.CombatState;
import de.slashbinbash.hexen.encounter.Encounter;
import de.slashbinbash.hexen.event.Event;
import de.slashbinbash.hexen.event.EventData;
import de.slashbinbash.hexen.event.EventDescriptor;
import de.slashbinbash.hexen.event.EventFactory;
import de.slashbinbash.hexen.event.EventState;
import de.slashbinbash.hexen.map.Level;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.message.ISubscriber;
import de.slashbinbash.hexen.message.Message;
import de.slashbinbash.hexen.message.MessageBus;

public class EncounterSystem
implements ISubscriber {
    public EncounterSystem() {
        if (EngineConfig.enableEncounterSystem) {
            MessageBus.subscribe(this);
        }
    }

    public Encounter.Entry getRandomEncounter(boolean bl) {
        Encounter encounter;
        Location location = RPG.getInstance().party.getLocation();
        Level level = location.getLevel();
        if (level.encounters == null) {
            return null;
        }
        Encounter.Type type = null;
        Encounter.Type type2 = null;
        Encounter.Type type3 = null;
        Encounter encounter2 = level.encounters.global;
        if (encounter2 != null) {
            boolean bl2 = true;
            if (encounter2.condition != null) {
                bl2 = encounter2.condition.checkAll(encounter2);
            }
            if (bl2) {
                type = encounter2.resting;
                type2 = encounter2.always;
                type3 = encounter2.once;
            }
        }
        if ((encounter = level.encounters.get(location.x, location.y)) != null) {
            boolean bl3 = true;
            if (encounter.condition != null) {
                bl3 = encounter.condition.checkAll(encounter);
            }
            if (bl3) {
                if (encounter.resting != null) {
                    type = encounter.resting;
                }
                if (encounter.always != null) {
                    type2 = encounter.always;
                }
                if (encounter.once != null) {
                    type3 = encounter.once;
                }
            }
        }
        Encounter.Type type4 = null;
        type4 = bl ? (type != null ? type : type2) : (type3 != null ? type3 : type2);
        if (type4 == null) {
            return null;
        }
        if (type4 == type3 && type4.type == 2) {
            level.encounters.reset(location.x, location.y);
        }
        return type4.getRandomEntry();
    }

    public void pushEncounter(Encounter.Entry entry) {
        if (entry.actions != null) {
            for (Action action : entry.actions) {
                action.perform(null);
            }
        } else if (entry.combat != null) {
            CombatDescriptor combatDescriptor = entry.combat;
            CombatState combatState = CombatFactory.createCombatState(combatDescriptor);
            combatState.init();
            MessageBus.push(Message.STATE_PUSH, combatState);
        } else if (entry.event != null) {
            EventDescriptor eventDescriptor = entry.event;
            EventData eventData = EventFactory.createEventData(eventDescriptor);
            Event.State state = RPG.getInstance().eventSystem.getState(eventDescriptor.eventID);
            EventState eventState = new EventState(eventData, state);
            eventState.run();
            MessageBus.push(Message.STATE_PUSH, eventState);
        }
    }

    private void handleEnterSpace() {
        Encounter.Entry entry = this.getRandomEncounter(false);
        if (entry == null) {
            return;
        }
        this.pushEncounter(entry);
    }

    @Override
    public void notify(Message message, Object object) {
        switch (message) {
            case SPACE_ON_ENTER: {
                this.handleEnterSpace();
                break;
            }
        }
    }
}

