/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.event;

import de.slashbinbash.hexen.action.ActionFactory;
import de.slashbinbash.hexen.check.CheckFactory;
import de.slashbinbash.hexen.event.EventData;
import de.slashbinbash.hexen.event.EventDescriptor;
import de.slashbinbash.hexen.event.EventInput;
import de.slashbinbash.hexen.event.EventNode;
import de.slashbinbash.hexen.event.EventNodeSelector;
import de.slashbinbash.hexen.event.EventOption;
import de.slashbinbash.hexen.event.EventOptionCheck;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.factory.SceneFactory;
import de.slashbinbash.hexen.struct.Vars;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EventFactory {
    public static EventNodeSelector createEventNodeSelector(Element element) {
        EventNodeSelector eventNodeSelector = new EventNodeSelector();
        for (Element element2 : StaticXML.getChildElements(element)) {
            EventNodeSelector.Entry entry = new EventNodeSelector.Entry();
            entry.successId = StaticXML.getAttribute(element2, "success", null);
            entry.failureId = StaticXML.getAttribute(element2, "failure", null);
            entry.checks = CheckFactory.createChecks(element2);
            eventNodeSelector.list.add(entry);
        }
        return eventNodeSelector;
    }

    public static EventDescriptor createEventDescriptor(Element element) {
        EventDescriptor eventDescriptor = new EventDescriptor();
        eventDescriptor.eventID = StaticXML.getAttribute(element, "ref");
        eventDescriptor.vars = EventFactory.createVars(element);
        return eventDescriptor;
    }

    public static EventData createEventData(EventDescriptor eventDescriptor) {
        return EventFactory.createEventData(eventDescriptor.eventID);
    }

    public static EventData createEventData(String string) {
        EventData eventData = new EventData();
        eventData.id = string;
        File file = new File(Factory.EVENT_PATH + string + ".xml");
        assert (file.exists()) : "File does not exist: " + file.getAbsolutePath();
        if (file.exists()) {
            try {
                Document document = StaticXML.loadXML(file);
                EventFactory.createEventNodes(document.getDocumentElement(), eventData);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return eventData;
    }

    public static EventData createEventData(Element element) {
        String string = StaticXML.getAttribute(element, "ref");
        if (string != null) {
            return EventFactory.createEventData(string);
        }
        assert (false);
        return null;
    }

    private static EventInput createEventInput(Element element) {
        EventInput eventInput = new EventInput();
        for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "test": {
                    EventInput.Test test = new EventInput.Test();
                    test.next = StaticXML.getAttribute(element2, "next");
                    for (Element element3 : StaticXML.getChildElements(element2)) {
                        switch (element3.getTagName()) {
                            case "text": {
                                test.words.add(StaticXML.getText(element3).trim());
                            }
                        }
                    }
                    eventInput.tests.add(test);
                }
            }
        }
        return eventInput;
    }

    private static EventOption createEventOption(Element element) {
        EventOption eventOption = new EventOption();
        eventOption.id = StaticXML.getAttribute(element, "id", null);
        eventOption.next = StaticXML.getAttribute(element, "next", null);
        block12: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "text": {
                    eventOption.text = StaticXML.getText(element2);
                    continue block12;
                }
                case "next": {
                    EventOptionCheck eventOptionCheck = new EventOptionCheck();
                    eventOptionCheck.successId = StaticXML.getAttribute(element2, "success");
                    eventOptionCheck.failureId = StaticXML.getAttribute(element2, "failure");
                    eventOptionCheck.checks = CheckFactory.createChecks(element2);
                    eventOption.nextChecks = eventOptionCheck;
                    continue block12;
                }
                case "actions": {
                    eventOption.actions = ActionFactory.createActions(element2);
                    continue block12;
                }
                case "visible": {
                    eventOption.visibleChecks = CheckFactory.createChecks(element2);
                    continue block12;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        assert (eventOption.text != null);
        return eventOption;
    }

    private static void createEventNodes(Element element, EventData eventData) {
        Element element2;
        Element element3 = StaticXML.getElement(element, "scene");
        if (element3 != null) {
            eventData.scene = SceneFactory.createScene(element3);
        }
        if ((element2 = StaticXML.getElement(element, "selections")) != null) {
            eventData.selector = EventFactory.createEventNodeSelector(element2);
        }
        for (Element element4 : StaticXML.getElements(element, "node")) {
            EventNode eventNode = new EventNode();
            eventNode.id = StaticXML.getAttribute(element4, "id");
            block15: for (Element element5 : StaticXML.getChildElements(element4)) {
                switch (element5.getTagName()) {
                    case "scene": {
                        eventNode.scene = SceneFactory.createScene(element5);
                        continue block15;
                    }
                    case "text": {
                        eventNode.text = Factory.unformatMD(StaticXML.getText(element5));
                        continue block15;
                    }
                    case "option": {
                        eventNode.options.add(EventFactory.createEventOption(element5));
                        continue block15;
                    }
                    case "input": {
                        eventNode.input = EventFactory.createEventInput(element5);
                        continue block15;
                    }
                    case "actions": {
                        eventNode.actions = ActionFactory.createActions(element5);
                        continue block15;
                    }
                }
                StaticXML.errUnknownTag(element5);
            }
            assert (eventNode.id != null);
            assert (!eventData.nodes.containsKey(eventNode.id)) : "Dialog node with id=" + eventNode.id + " already exists";
            eventData.nodes.put(eventNode.id, eventNode);
        }
    }

    private static Vars createVars(Element element) {
        Vars vars = new Vars();
        for (Element element2 : StaticXML.getElements(element, "var")) {
            String string = StaticXML.getAttribute(element2, "name");
            String string2 = StaticXML.getAttribute(element2, "value");
            if (string2 == null) {
                string2 = StaticXML.getText(element2);
            }
            assert (string != null);
            assert (string2 != null);
            Object object = null;
            object = EventFactory.isBoolean(string2) ? Boolean.valueOf(Boolean.parseBoolean(string2)) : (EventFactory.isInteger(string2) ? Integer.valueOf(Integer.parseInt(string2)) : string2);
            if (object == null) continue;
            vars.set(string, object);
        }
        return vars;
    }

    private static boolean isBoolean(String string) {
        return string.equals("true") || string.equals("false");
    }

    private static boolean isInteger(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('0' <= c && c <= '9') continue;
            return false;
        }
        return true;
    }
}

