/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.factory;

import de.slashbinbash.hexen.action.ActionFactory;
import de.slashbinbash.hexen.check.CheckFactory;
import de.slashbinbash.hexen.enums.Target;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.model.CombatAction;
import de.slashbinbash.hexen.model.CombatActionRange;
import de.slashbinbash.hexen.model.CombatActions;
import de.slashbinbash.hexen.struct.CacheMap;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CombatActionFactory {
    private static CacheMap<CombatAction> cache = new CacheMap();

    public static void clear() {
        cache.clear();
    }

    public static CombatAction createCombatAction(Element element) {
        return CombatActionFactory.createCombatAction(StaticXML.getAttribute(element, "ref"));
    }

    public static CombatAction createCombatAction(String string) {
        if (cache.has(string)) {
            return cache.get(string);
        }
        CombatAction combatAction = new CombatAction();
        File file = new File(Factory.COMBAT_ACTION_PATH + string + ".xml");
        try {
            Document document = StaticXML.loadXML(file);
            CombatAction.Data data = CombatActionFactory.createCombatActionData(document.getDocumentElement());
            data.__id__ = string;
            combatAction._data = data;
            cache.put(string, combatAction);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            CombatAction.Data data = new CombatAction.Data();
            data.__id__ = string;
            data.name = "<ERR:" + string + ">";
            data.description = "Failed to read " + file.getAbsolutePath();
            combatAction._data = data;
        }
        return combatAction;
    }

    private static CombatAction.Data createCombatActionData(Element element) {
        CombatAction.Data data = new CombatAction.Data();
        block28: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "name": {
                    data.name = StaticXML.getText(element2);
                    continue block28;
                }
                case "description": {
                    data.description = Factory.unformatMD(StaticXML.getText(element2));
                    continue block28;
                }
                case "cost": {
                    data.actionPointCost = Integer.valueOf(StaticXML.getText(element2));
                    continue block28;
                }
                case "critChance": {
                    data.critChance = Float.valueOf(StaticXML.getText(element2)).floatValue();
                    continue block28;
                }
                case "critMultiplier": {
                    data.critMultiplier = Float.valueOf(StaticXML.getText(element2)).floatValue();
                    continue block28;
                }
                case "hitChance": {
                    data.hitChance = Float.valueOf(StaticXML.getText(element2)).floatValue();
                    continue block28;
                }
                case "range": {
                    data.rangeFrom = CombatActionRange.valueOf(StaticXML.getAttribute(element2, "from"));
                    data.rangeTo = CombatActionRange.valueOf(StaticXML.getAttribute(element2, "to"));
                    continue block28;
                }
                case "target": {
                    data.target = Target.valueOf(StaticXML.getText(element2));
                    continue block28;
                }
                case "requirements": {
                    data.requirements = CheckFactory.createChecks(element2);
                    continue block28;
                }
                case "actions": {
                    data.actions = ActionFactory.createActions(element2);
                    continue block28;
                }
                case "actionsOnCritHit": {
                    data.actionsOnCritHit = ActionFactory.createActions(element2);
                    continue block28;
                }
                case "base": {
                    data.base = StaticXML.getText(element2);
                    continue block28;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return data;
    }

    public static CombatActions createCombatActions(Element element) {
        CombatActions combatActions = new CombatActions();
        block6: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "combatAction": {
                    CombatAction combatAction = CombatActionFactory.createCombatAction(element2);
                    combatActions.add(combatAction);
                    continue block6;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return combatActions;
    }
}

