/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.factory;

import de.slashbinbash.hexen.action.ActionFactory;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.factory.ModifierFactory;
import de.slashbinbash.hexen.model.Condition;
import de.slashbinbash.hexen.struct.CacheMap;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConditionFactory {
    private static CacheMap<Condition.Data> cache = new CacheMap();

    private static Condition.Data initCondition(Element element, Condition.Data data) {
        block30: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "name": {
                    data.name = StaticXML.getText(element2);
                    continue block30;
                }
                case "description": {
                    data.description = StaticXML.getText(element2);
                    continue block30;
                }
                case "cannotDefend": {
                    data.cannotDefend = Boolean.parseBoolean(StaticXML.getText(element2));
                    continue block30;
                }
                case "cannotMove": {
                    data.cannotMove = Boolean.parseBoolean(StaticXML.getText(element2));
                    continue block30;
                }
                case "cannotRunAway": {
                    data.cannotRunAway = Boolean.parseBoolean(StaticXML.getText(element2));
                    continue block30;
                }
                case "cannotUseAbilities": {
                    data.cannotUseAbilities = Boolean.valueOf(StaticXML.getText(element2));
                    continue block30;
                }
                case "durationStacks": {
                    data.stackDuration = Boolean.valueOf(StaticXML.getText(element2));
                    continue block30;
                }
                case "removeOnAttack": {
                    data.removeOnAttack = Boolean.parseBoolean(StaticXML.getText(element2));
                    continue block30;
                }
                case "removeOnDamage": {
                    data.removeOnDamage = Boolean.parseBoolean(StaticXML.getText(element2));
                    continue block30;
                }
                case "removeOnRest": {
                    data.removeOnRest = Boolean.parseBoolean(StaticXML.getText(element2));
                    continue block30;
                }
                case "skipTurn": {
                    data.skipCombatTurn = Boolean.parseBoolean(StaticXML.getText(element2));
                    continue block30;
                }
                case "actions": {
                    data.actions = ActionFactory.createActions(element2);
                    continue block30;
                }
                case "modifiers": {
                    data.modifiers = ModifierFactory.createModifiers(element2);
                    continue block30;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return data;
    }

    public static void clear() {
        cache.clear();
    }

    public static Condition createCondition(String string, long l) {
        return new Condition(ConditionFactory.createCondition(string), l);
    }

    public static Condition.Data createCondition(String string) {
        if (cache.has(string)) {
            return cache.get(string);
        }
        Condition.Data data = new Condition.Data();
        data.__id__ = string;
        File file = new File(Factory.CONDITION_PATH + string + ".xml");
        try {
            Document document = StaticXML.loadXML(file);
            ConditionFactory.initCondition(document.getDocumentElement(), data);
            cache.put(string, data);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            data.name = "ERR " + string;
            data.description = "Failed to read " + file.getAbsolutePath();
        }
        return data;
    }

    public static Condition.Data createCondition(Element element) {
        return ConditionFactory.createCondition(StaticXML.getAttribute(element, "ref"));
    }

    public static List<Condition.Data> createConditions(Element element) {
        ArrayList<Condition.Data> arrayList = new ArrayList<Condition.Data>();
        for (Element element2 : StaticXML.getChildElements(element)) {
            Condition.Data data = ConditionFactory.createCondition(element2);
            arrayList.add(data);
        }
        return arrayList;
    }
}

