/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.factory;

import de.slashbinbash.hexen.factory.AbilityFactory;
import de.slashbinbash.hexen.factory.AttributeFactory;
import de.slashbinbash.hexen.factory.CombatActionFactory;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.factory.ModifierFactory;
import de.slashbinbash.hexen.factory.TraitFactory;
import de.slashbinbash.hexen.model.Abilities;
import de.slashbinbash.hexen.model.Attributes;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.Modifiers;
import de.slashbinbash.hexen.model.Slot;
import de.slashbinbash.hexen.model.Slots;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CreatureFactory {
    public static ClassCreature createCreature(String string) {
        ClassCreature classCreature = new ClassCreature();
        classCreature.__id__ = string;
        try {
            File file = new File(Factory.CREATURE_PATH + string + ".xml");
            Document document = StaticXML.loadXML(file);
            return CreatureFactory.initCreature(document.getDocumentElement(), classCreature);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            classCreature.name = "<ERR:" + string + ">";
            return classCreature;
        }
    }

    public static Slots createSlots(String string) {
        try {
            Document document = StaticXML.loadXML(new File(Factory.PAK_DB + "/slots.xml"));
            Element element = document.getDocumentElement();
            for (Element element2 : StaticXML.getChildElements(element)) {
                String string2 = StaticXML.getAttribute(element2, "id");
                if (!string2.equals(string)) continue;
                List<Element> list = StaticXML.getChildElements(element2);
                Slot[] slotArray = new Slot[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    Element element3 = list.get(i);
                    String string3 = StaticXML.getAttribute(element3, "id");
                    String string4 = StaticXML.getAttribute(element3, "name");
                    slotArray[i] = new Slot(string3, string4);
                }
                return new Slots(string2, slotArray);
            }
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    private static ClassCreature initCreature(Element element, ClassCreature classCreature) {
        Abilities abilities = null;
        Attributes attributes = null;
        classCreature.vim = 100;
        block34: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "name": {
                    classCreature.name = StaticXML.getText(element2);
                    continue block34;
                }
                case "portrait": {
                    classCreature.portrait = StaticXML.getText(element2);
                    continue block34;
                }
                case "hp": {
                    classCreature.hitPoints = classCreature.maxHitPoints = Integer.parseInt(StaticXML.getText(element2));
                    continue block34;
                }
                case "ap": {
                    classCreature.actionPoints = classCreature.maxActionPoints = Integer.parseInt(StaticXML.getText(element2));
                    continue block34;
                }
                case "vim": {
                    classCreature.vim = Integer.valueOf(StaticXML.getText(element2));
                    continue block34;
                }
                case "job": {
                    classCreature.job = StaticXML.getText(element2);
                    continue block34;
                }
                case "playable": {
                    classCreature.playable = Boolean.parseBoolean(StaticXML.getText(element2));
                    continue block34;
                }
                case "abilities": {
                    abilities = AbilityFactory.createAbilities(element2);
                    continue block34;
                }
                case "attributes": {
                    attributes = AttributeFactory.createAttributes(element2);
                    continue block34;
                }
                case "combatActions": {
                    classCreature.combatActions = CombatActionFactory.createCombatActions(element2);
                    continue block34;
                }
                case "modifiers": {
                    classCreature.modifiers = ModifierFactory.createModifiers(element2);
                    continue block34;
                }
                case "mods": {
                    String string = StaticXML.getAttribute(element2, "slots");
                    classCreature.mods = CreatureFactory.createSlots(string);
                    continue block34;
                }
                case "traits": {
                    classCreature.traits = TraitFactory.createTraits(element2);
                    continue block34;
                }
                case "bestiary": 
                case "combatAi": 
                case "itemDrops": {
                    continue block34;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        if (abilities != null || attributes != null) {
            if (classCreature.modifiers == null) {
                classCreature.modifiers = new Modifiers();
            }
            classCreature.modifiers.modAbilities = abilities;
            classCreature.modifiers.modAttributes = attributes;
        }
        return classCreature;
    }
}

