/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.general;

import de.slashbinbash.hexen.bank.Bank;
import de.slashbinbash.hexen.event.EventFactory;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.factory.SceneFactory;
import de.slashbinbash.hexen.general.AskFactory;
import de.slashbinbash.hexen.general.General;
import de.slashbinbash.hexen.guild.GuildFactory;
import de.slashbinbash.hexen.inn.InnFactory;
import de.slashbinbash.hexen.shop.ShopFactory;
import de.slashbinbash.hexen.temple.TempleFactory;
import de.slashbinbash.hexen.travel.TravelFactory;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GeneralFactory {
    private static General.Entry createEntry(Element element) {
        General.Entry entry = new General.Entry();
        switch (element.getTagName()) {
            case "ask": {
                entry.set(General.Type.Ask, AskFactory.createAskData(element));
                break;
            }
            case "bank": {
                entry.set(General.Type.Bank, new Bank());
                break;
            }
            case "buy": {
                entry.set(General.Type.Buy, ShopFactory.createBuyData(element));
                break;
            }
            case "donate": {
                entry.set(General.Type.Donate, TempleFactory.createDonateData(element));
                break;
            }
            case "guild": {
                entry.set(General.Type.Guild, GuildFactory.createGuildData(element));
                break;
            }
            case "heal": {
                entry.set(General.Type.Heal, TempleFactory.createHealData(element));
                break;
            }
            case "hire": {
                entry.set(General.Type.Hire, GuildFactory.createHireData(element));
                break;
            }
            case "identify": {
                entry.set(General.Type.Identify, ShopFactory.createIdentifyData(element));
                break;
            }
            case "pray": {
                entry.set(General.Type.Pray, TempleFactory.createPrayData(element));
                break;
            }
            case "rest": {
                entry.set(General.Type.Rest, InnFactory.createRestData(element));
                break;
            }
            case "retire": {
                entry.set(General.Type.Retire, GuildFactory.createRetireData(element));
                break;
            }
            case "sell": {
                entry.set(General.Type.Sell, ShopFactory.createSellData(element));
                break;
            }
            case "trade": {
                entry.set(General.Type.Trade, ShopFactory.createTradeData(element));
                break;
            }
            case "train": {
                entry.set(General.Type.Train, GuildFactory.createTrainData(element));
                break;
            }
            case "talk": {
                entry.set(General.Type.Talk, EventFactory.createEventData(element));
                break;
            }
            case "travel": {
                entry.set(General.Type.Travel, TravelFactory.createTravelData(element));
                break;
            }
            default: {
                StaticXML.errUnknownTag(element);
            }
        }
        if (StaticXML.hasAttribute(element, "label")) {
            entry.label = StaticXML.getAttribute(element, "label");
        }
        return entry;
    }

    private static General.Data createGenericData(Element element) {
        General.Data data = new General.Data();
        block8: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "scene": {
                    data.scene = SceneFactory.createScene(element2);
                    continue block8;
                }
                case "description": {
                    data.description = Factory.unformatMD(StaticXML.getText(element2));
                    continue block8;
                }
            }
            data.entries.add(GeneralFactory.createEntry(element2));
        }
        return data;
    }

    public static General.Data createGenericData(String string, String string2) {
        try {
            File file = new File(string + string2 + ".xml");
            Document document = StaticXML.loadXML(file);
            General.Data data = GeneralFactory.createGenericData(document.getDocumentElement());
            data.__id__ = string2;
            return data;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

