/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.general.Ask;
import de.slashbinbash.hexen.general.StaticAsk;
import de.slashbinbash.hexen.handler.HandlerBase;

public class AskHandler
extends HandlerBase {
    private static final int INPUT = 0;
    private static final int ANSWER = 1;
    private Ask ask = null;
    private String answer = null;

    public AskHandler(HandlerBase handlerBase) {
        super.setScene(handlerBase.scene);
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 0: {
                this.handleInput(commandEvent, object);
                break;
            }
            case 1: {
                super.popState();
                super.setMode(HandlerBase.Mode.Input);
                break;
            }
        }
    }

    private void handleInput(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                String string = super.getInput().trim().toLowerCase();
                if (string.isEmpty()) {
                    super.popState();
                    break;
                }
                this.answer = StaticAsk.findAnswer(this.ask._data, string);
                super.pushState(1);
                super.setMode(HandlerBase.Mode.Default);
                break;
            }
            case CANCEL: {
                super.popState();
                break;
            }
        }
    }

    public void init(Ask ask) {
        this.ask = ask;
        super.init();
        super.setMode(HandlerBase.Mode.Input);
    }

    @Override
    public void updateButtons() {
    }

    @Override
    public void updateLeftText() {
        switch (this.state) {
            case 0: {
                this.leftText = "ASK ABOUT";
                break;
            }
            case 1: {
                this.leftText = this.answer;
                break;
            }
            default: {
                this.leftText = null;
            }
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
    }

    @Override
    public void updateScene() {
        if (this.ask._data.scene != null) {
            super.setScene(this.ask._data.scene);
        }
    }
}

