/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.bestiary.Bestiary;
import de.slashbinbash.hexen.bestiary.BestiaryFactory;
import de.slashbinbash.hexen.bestiary.BestiarySystem;
import de.slashbinbash.hexen.factory.CreatureFactory;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.model.ClassCreature;

public class BestiaryHandler
extends HandlerBase {
    private static final int PICK_CREATURE = 0;
    private static final int SHOW_MESSAGE = 1;
    private final int maxCreaturesPerPage = 25;
    private int numCreatures = 0;
    private int numPages = 0;
    private int currPage = 0;

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 0: {
                this.handlePickCreature(commandEvent, object);
                break;
            }
            case 1: {
                this.reset();
            }
        }
    }

    private void handlePickCreature(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                break;
            }
            case TAB_LEFT: {
                --this.currPage;
                if (this.currPage >= 0) break;
                this.currPage = this.numPages - 1;
                break;
            }
            case TAB_RIGHT: {
                this.currPage = (this.currPage + 1) % this.numPages;
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    public void init(Bestiary bestiary) {
        BestiarySystem bestiarySystem = RPG.getInstance().bestiarySystem;
        this.numCreatures = bestiarySystem.map.size();
        this.numPages = this.numCreatures / 25 + 1;
        super.init();
    }

    private void reset() {
        this.resetState();
        super.init();
    }

    private void showMessage(String string) {
        this.leftText = string;
        this.pushState(1);
    }

    @Override
    public void updateButtons() {
        BestiarySystem bestiarySystem = RPG.getInstance().bestiarySystem;
        switch (this.state) {
            case 0: {
                int n = this.currPage * 25;
                for (int i = 0; i < 25; ++i) {
                    if (i >= bestiarySystem.list.size()) continue;
                    String string = bestiarySystem.list.get(n + i);
                    Bestiary.State state = bestiarySystem.map.get(string);
                    if (state != null) {
                        super.addButton(state.creatureName, state);
                        continue;
                    }
                    super.addButton("???");
                }
                break;
            }
        }
    }

    @Override
    public void updateLeftText() {
        if (this.state != 1) {
            this.leftText = null;
        }
        switch (this.state) {
            case 0: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Page ").append(this.currPage + 1).append("/").append(this.numPages).append("\n");
                this.leftText = stringBuilder.toString();
                break;
            }
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
        switch (this.state) {
            case 0: {
                Bestiary.State state;
                if (this.buttons.isEmpty() || (state = (Bestiary.State)super.getSelectedButton().data) == null) break;
                Bestiary.Data data = BestiaryFactory.createBestiaryData(state.creatureId);
                ClassCreature classCreature = CreatureFactory.createCreature(state.creatureId);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(classCreature.name).append("\n");
                stringBuilder.append("\n     Defeated ").append(state.recorded);
                stringBuilder.append("\n   Hit Points ").append(classCreature.calcMaxHitPoints());
                stringBuilder.append("\nAction Points ").append(classCreature.calcMaxActionPoints());
                stringBuilder.append("\n   Group Size ");
                if (data.groupSizeMin == 0 && data.groupSizeMax == 0) {
                    stringBuilder.append("?");
                } else if (data.groupSizeMin < data.groupSizeMax) {
                    stringBuilder.append(data.groupSizeMin).append("-").append(data.groupSizeMax);
                } else {
                    stringBuilder.append(data.groupSizeMin);
                }
                stringBuilder.append("\n\n");
                stringBuilder.append(data.description);
                this.rightText = stringBuilder.toString();
                break;
            }
        }
    }

    @Override
    public void updateScene() {
        switch (this.state) {
            case 0: {
                Bestiary.State state = (Bestiary.State)super.getSelectedButton().data;
                if (state != null) {
                    ClassCreature classCreature = CreatureFactory.createCreature(state.creatureId);
                    this.scene.portrait = classCreature.portrait;
                    this.scene.portraitTitle = classCreature.name;
                    break;
                }
                this.scene.portrait = null;
                this.scene.portraitTitle = "???";
                break;
            }
        }
    }
}

