/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.Documentation;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.model.Inventory;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.Party;
import de.slashbinbash.hexen.shop.Buy;
import de.slashbinbash.hexen.shop.StaticShop;
import de.slashbinbash.hexen.ui.Button;
import de.slashbinbash.hexen.view.StaticView;

public class BuyHandler
extends HandlerBase {
    private static final int PICK_ITEM = 0;
    private Buy buy = null;

    public BuyHandler(HandlerBase handlerBase) {
        super.setScene(handlerBase.scene);
    }

    private void handleBuyItem(CommandEvent commandEvent, Object object) {
        if (this.buttons.isEmpty()) {
            return;
        }
        switch (commandEvent) {
            case CONFIRM: {
                Item item = (Item)super.getSelectedButton().data;
                StaticShop.buyItem(this.buy._data, item, 1);
                break;
            }
            case CANCEL: {
                super.popState();
                break;
            }
            case SHOW_DOCUMENTATION: {
                Item item = (Item)super.getSelectedButton().data;
                Documentation.showItem(item);
                break;
            }
        }
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 0: {
                this.handleBuyItem(commandEvent, object);
                break;
            }
        }
    }

    public void init(Buy buy) {
        this.buy = buy;
        super.init();
    }

    @Override
    public void updateButtons() {
        Party party = RPG.getInstance().party;
        Inventory inventory = party.inventory;
        if (this.state == 0) {
            for (Item item : this.buy._data.buyList) {
                int n = inventory.count(item.getId());
                int n2 = this.buy._data.getBuyPrice(item, 1);
                String string = item.getName();
                if (string.length() > 19) {
                    string = item.getName().substring(0, Math.min(item.getName().length(), 19));
                }
                String string2 = String.format("%-3d%-21s%4d", n, string, n2);
                super.addButton(string2, item);
            }
        }
    }

    @Override
    public void updateLeftText() {
        this.leftText = null;
        if (this.state == 0 && this.buttons.isEmpty()) {
            this.leftText = "No items to buy.";
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
        if (this.state == 0) {
            Button button;
            StringBuilder stringBuilder = new StringBuilder();
            Inventory inventory = RPG.getInstance().party.inventory;
            int n = inventory.getCurrency();
            if (this.buy._data.currency != null) {
                n = inventory.count(this.buy._data.currency);
                stringBuilder.append("Payment:\n").append(n).append(" ").append(this.buy._data.currency).append("\n\n");
            }
            if ((button = super.getSelectedButton()) != null) {
                Item item = (Item)button.data;
                StaticView.printItem(stringBuilder, item);
            }
            this.rightText = stringBuilder.toString();
        }
    }

    @Override
    public void updateScene() {
        if (this.buy._data.scene != null) {
            super.setScene(this.buy._data.scene);
        }
    }
}

