/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.Documentation;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.camp.Camp;
import de.slashbinbash.hexen.camp.StaticCamp;
import de.slashbinbash.hexen.factory.ItemFactory;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.ItemData;
import de.slashbinbash.hexen.model.ItemType;
import de.slashbinbash.hexen.model.Party;
import de.slashbinbash.hexen.model.Recipe;
import de.slashbinbash.hexen.shop.ShopSystem;
import de.slashbinbash.hexen.shop.StaticIdentify;
import de.slashbinbash.hexen.ui.Button;
import de.slashbinbash.hexen.view.StaticView;
import de.slashbinbash.hexen.workbench.Craft;
import de.slashbinbash.hexen.workbench.RecipeSystem;
import de.slashbinbash.hexen.workbench.StaticWorkbench;
import de.slashbinbash.hexen.workbench.WorkbenchFactory;

public class CampHandler
extends HandlerBase {
    private static final int STATE_PICK = 0;
    private static final int STATE_CRAFT = 1;
    private static final int STATE_REST = 2;
    private static final int STATE_IDENTIFY = 3;
    private static final int SHOW_MESSAGE = 4;
    private Camp camp = null;

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        if (this.state == 4) {
            super.popState();
            return;
        }
        switch (this.state) {
            case 0: {
                this.handlePick(commandEvent, object);
                break;
            }
            case 1: {
                this.handleCraft(commandEvent, object);
                break;
            }
            case 3: {
                this.handleIdentify(commandEvent, object);
                break;
            }
            case 2: {
                this.handleRest(commandEvent, object);
                break;
            }
        }
    }

    private void handleCraft(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                if (this.buttons.size() <= 0) break;
                Recipe recipe = (Recipe)super.getSelectedButton().data;
                StaticWorkbench.craft(recipe, 1.0f);
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
            case SHOW_DOCUMENTATION: {
                Recipe recipe = (Recipe)((Button)this.buttons.get((int)this.buttonIndex)).data;
                Documentation.showItem(recipe.__id__);
                break;
            }
        }
    }

    private void handleIdentify(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                boolean bl;
                if (this.buttons.isEmpty()) break;
                Party party = RPG.getInstance().party;
                Item item = (Item)super.getSelectedButton().data;
                boolean bl2 = RPG.getInstance().shopSystem.isIdentified(item);
                if (!bl2 && !(bl = StaticIdentify.canIdentify(item, party))) {
                    this.showMessage("Failed to identify object.", new Object[0]);
                    break;
                }
                Item item2 = StaticIdentify.getIdentifiedItem(item);
                if (item2 == null) break;
                party.inventory.removeAll(item);
                if (!bl2) {
                    long l = StaticIdentify.calcDurationSeconds(item);
                    RPG.getInstance().passTime(l);
                    RPG.getInstance().shopSystem.addIdentified(item);
                }
                party.inventory.add(item2);
                String string = String.format("You identified:\n%s", item2.getName());
                this.showMessage(string, new Object[0]);
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    private void handlePick(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                Integer n = (Integer)((Button)this.buttons.get((int)this.buttonIndex)).data;
                this.pushState(n);
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    private void handleRest(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                int n;
                StaticRPG.Result result;
                if (this.buttons.isEmpty()) break;
                assert (StaticCamp.canRest());
                boolean bl = true;
                if (this.camp != null) {
                    bl = this.camp.triggerEncounters;
                }
                if ((result = StaticCamp.restHours(n = ((Integer)((Button)this.buttons.get((int)this.buttonIndex)).data).intValue(), bl)) == StaticRPG.Result.SUCCESS) {
                    this.showMessage("Party rested for %s.", ((Button)this.buttons.get((int)this.buttonIndex)).label.trim());
                    break;
                }
                this.showMessage("Party failed to rest.", new Object[0]);
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    @Override
    public void init() {
        this.state = 0;
        this.camp = new Camp();
        super.init();
    }

    public void init(Camp camp) {
        this.state = 0;
        this.camp = camp;
        super.init();
    }

    private void showMessage(String string, Object ... objectArray) {
        this.leftText = String.format(string, objectArray);
        this.pushState(4);
    }

    @Override
    public void updateButtons() {
        switch (this.state) {
            case 1: {
                RecipeSystem recipeSystem = RPG.getInstance().recipeSystem;
                if (recipeSystem.recipes == null) break;
                for (String string : recipeSystem.recipes) {
                    Craft.Data data = WorkbenchFactory.createCraftData(string);
                    Recipe recipe = data.assemble;
                    ItemData itemData = ItemFactory.createItemDesc(string);
                    int n = RPG.getInstance().party.inventory.count(string);
                    super.addButton(n + " " + itemData.name, recipe);
                }
                break;
            }
            case 0: {
                super.addButton("Rest", 2);
                super.addButton("Craft", 1);
                super.addButton("Identify", 3);
                break;
            }
            case 2: {
                if (!StaticCamp.canRest()) break;
                super.addButton(" 1 Hour", 1);
                super.addButton(" 2 Hours", 2);
                super.addButton(" 6 Hours", 6);
                super.addButton("12 Hours", 12);
                super.addButton("24 Hours", 24);
                break;
            }
            case 3: {
                Party party = RPG.getInstance().party;
                ShopSystem shopSystem = RPG.getInstance().shopSystem;
                for (Item item : party.inventory.list(ItemType.Unidentified)) {
                    boolean bl = shopSystem.isIdentified(item);
                    super.addButton((bl ? "" : "?") + item.getName(), item);
                }
                super.sortButtons();
                break;
            }
            case 4: {
                break;
            }
        }
    }

    @Override
    public void updateLeftText() {
        switch (this.state) {
            case 1: {
                if (this.buttons.isEmpty()) {
                    this.leftText = "No recipies";
                    break;
                }
                this.leftText = null;
                break;
            }
            case 3: {
                if (this.buttons.isEmpty()) {
                    this.leftText = "Nothing to identify.";
                    break;
                }
                this.leftText = null;
                break;
            }
            case 2: {
                if (this.buttons.isEmpty()) {
                    this.leftText = "Party cannot rest here.";
                    break;
                }
                this.leftText = null;
                break;
            }
            case 4: {
                break;
            }
            default: {
                this.leftText = null;
            }
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
        switch (this.state) {
            case 1: {
                if (this.buttons.isEmpty()) break;
                Recipe recipe = (Recipe)super.getSelectedButton().data;
                StringBuilder stringBuilder = new StringBuilder();
                StaticView.printRecipe(stringBuilder, recipe, 1.0f);
                this.rightText = stringBuilder.toString();
                break;
            }
            case 3: {
                if (this.buttons.isEmpty()) {
                    this.rightText = null;
                    break;
                }
                Item item = (Item)super.getSelectedButton().data;
                this.rightText = item.getDescription();
                break;
            }
        }
    }

    @Override
    public void updateScene() {
        this.scene.portrait = "camp";
        this.scene.portraitTitle = "Camp";
        super.setScene(this.scene);
    }
}

