/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.check.AbilityCheck;
import de.slashbinbash.hexen.chest.Chest;
import de.slashbinbash.hexen.chest.StaticChest;
import de.slashbinbash.hexen.factory.ItemFactory;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.ItemGroup;

public class ChestHandler
extends HandlerBase {
    private static final int SHOW_OPTIONS = 0;
    private static final int SHOW_CONTENTS = 1;
    private static final int SHOW_MESSAGE = 2;
    private static final int INPUT_PASSWORD = 3;
    private Chest chest = null;
    private StringBuilder sb = new StringBuilder();
    private boolean triedInspect = false;

    private void addButton(Action action) {
        String string = null;
        switch (action.ordinal()) {
            case 0: {
                string = "Open";
                break;
            }
            case 3: {
                string = "Lockpick";
                break;
            }
            case 2: {
                string = "Unlock with key";
                break;
            }
            case 1: {
                string = "Inspect";
                break;
            }
            case 5: {
                string = "Disarm trap";
                break;
            }
            case 6: {
                string = "Back";
                break;
            }
            case 7: {
                string = "Take";
                break;
            }
            case 4: {
                string = "Use password";
                break;
            }
            default: {
                string = action.name();
            }
        }
        super.addButton(string, (Object)action);
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 1: {
                this.handleShowContents(commandEvent, object);
                break;
            }
            case 0: {
                this.handleShowOptions(commandEvent, object);
                break;
            }
            case 2: {
                if (commandEvent != CommandEvent.CONFIRM && commandEvent != CommandEvent.CANCEL) break;
                this.resetState();
                break;
            }
            case 3: {
                this.handleInputPassword(commandEvent, object);
            }
        }
    }

    private void handleInputPassword(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                String string = this.getInput().toLowerCase();
                if (string.equals(this.chest._data.lock.password)) {
                    this.chest.state.lock_unlocked = true;
                    super.setMode(HandlerBase.Mode.Default);
                    this.showMessage("Unlocked chest.");
                    break;
                }
                this.showMessage("Nothing happens.");
                break;
            }
            case CANCEL: {
                this.resetState();
                super.setMode(HandlerBase.Mode.Default);
                break;
            }
        }
    }

    private void handleShowContents(CommandEvent commandEvent, Object object) {
        if (this.buttons.isEmpty()) {
            this.popState();
            return;
        }
        RPG rPG = RPG.getInstance();
        block0 : switch (commandEvent) {
            case CONFIRM: {
                Action action = (Action)((Object)this.getSelectedButton().data);
                switch (action.ordinal()) {
                    case 7: {
                        assert (!this.chest.state.empty);
                        for (ItemGroup itemGroup : this.chest._data.items) {
                            rPG.party.inventory.add(itemGroup.getId(), itemGroup.size);
                        }
                        this.chest.state.empty = true;
                        this.showMessage("Took all items.");
                        break block0;
                    }
                    case 6: {
                        this.resetState();
                        break block0;
                    }
                }
                break;
            }
            case CANCEL: {
                this.resetState();
                break;
            }
        }
    }

    private void handleShowOptions(CommandEvent commandEvent, Object object) {
        block35: {
            block34: {
                if (commandEvent != CommandEvent.CONFIRM) break block34;
                block0 : switch (((Action)((Object)this.getSelectedButton().data)).ordinal()) {
                    case 6: {
                        this.popState();
                        break;
                    }
                    case 5: {
                        StaticRPG.Result result = StaticChest.disarmTrap(this.chest);
                        switch (result) {
                            case SUCCESS: {
                                this.showMessage("Trap disarmed");
                                break block0;
                            }
                            case FAILURE: {
                                this.showMessage("Failed to disarm trap.");
                                break block0;
                            }
                            case ITEM_NOT_EXIST: {
                                this.showMessage("Need item: " + this.chest._data.trap.disarmItem);
                                break block0;
                            }
                        }
                        this.showMessage("UNKNOWN RESULT " + String.valueOf((Object)result));
                        break;
                    }
                    case 1: {
                        AbilityCheck abilityCheck;
                        this.triedInspect = true;
                        if (this.chest.hasLock()) {
                            abilityCheck = this.chest._data.lock.perceptionCheck;
                            boolean bl = this.chest.state.lock_detected = abilityCheck == null || abilityCheck.check(null);
                        }
                        if (this.chest.hasTrap()) {
                            abilityCheck = this.chest._data.trap.perceptionCheck;
                            this.chest.state.trap_detected = abilityCheck == null || abilityCheck.check(null);
                            break;
                        }
                        break block35;
                    }
                    case 3: {
                        StaticRPG.Result result = StaticChest.lockpickLock(this.chest);
                        switch (result) {
                            case SUCCESS: {
                                this.showMessage("Container unlocked.");
                                break block0;
                            }
                            case FAILURE: {
                                this.showMessage("Failed to lockpick lock.");
                                break block0;
                            }
                            case SKILL_CHECK_FAIL: {
                                String string = this.chest._data.lock.lockpickingCheck.ability.name;
                                int n = this.chest._data.lock.lockpickingCheck.dc;
                                this.showMessage(String.format("You fail to lockpick the lock. [%s=%d]", string, n));
                                break block0;
                            }
                            case SKILL_CHECK_FAIL_ITEM_BREAK: {
                                String string = this.chest._data.lock.lockpickingCheck.ability.name;
                                int n = this.chest._data.lock.lockpickingCheck.dc;
                                this.showMessage(String.format("Your lockpick breaks. [%s=%d]", string, n));
                                break block0;
                            }
                            case ITEM_NOT_EXIST: {
                                Item item = ItemFactory.createItem(this.chest._data.lock.lockpickItem);
                                this.showMessage("You require a " + item.getName() + ".");
                                break block0;
                            }
                        }
                        this.showMessage("UNKNOWN RESULT " + String.valueOf((Object)result));
                        break;
                    }
                    case 0: {
                        StaticRPG.Result result = StaticChest.openChest(this.chest);
                        switch (result) {
                            case SUCCESS: {
                                this.pushState(1);
                                break block0;
                            }
                            case LOCKED: {
                                this.showMessage("Container is locked.");
                                break block0;
                            }
                            case TRAPPED: {
                                this.showMessage("Container was trapped.");
                                break block0;
                            }
                        }
                        this.showMessage(result.name());
                        break;
                    }
                    case 4: {
                        this.pushState(3);
                        this.setMode(HandlerBase.Mode.Input);
                        break;
                    }
                    case 2: {
                        StaticRPG.Result result = StaticChest.unlockLock(this.chest);
                        switch (result) {
                            case SUCCESS: {
                                this.showMessage("Container unlocked.");
                                break block0;
                            }
                            case FAILURE: {
                                this.showMessage("Failed to unlock %chest%");
                                break block0;
                            }
                            case ITEM_NOT_EXIST: {
                                this.showMessage("A key is required.");
                                break block0;
                            }
                        }
                        this.showMessage("UNKNOWN RESULT " + String.valueOf((Object)result));
                        break;
                    }
                }
                break block35;
            }
            if (commandEvent == CommandEvent.CANCEL) {
                super.close();
            }
        }
    }

    public void init(Chest chest) {
        this.chest = chest;
        if (!chest.state.opened || chest.isLocked() || chest.hasTrap()) {
            this.state = 0;
        }
        super.init();
    }

    private void showMessage(String string) {
        this.leftText = string;
        this.pushState(2);
    }

    @Override
    public void updateButtons() {
        switch (this.state) {
            case 0: {
                this.addButton(Action.Open);
                if (this.triedInspect) {
                    if (this.chest.hasLock() && this.chest.isLocked() && this.chest.state.lock_detected) {
                        this.addButton(Action.Lockpick);
                        this.addButton(Action.Unlock);
                        if (this.chest.hasPassword()) {
                            this.addButton(Action.Password);
                        }
                    }
                    if (!this.chest.hasTrap() || !this.chest.state.trap_detected) break;
                    this.addButton(Action.Disarm);
                    break;
                }
                this.addButton(Action.Inspect);
                break;
            }
            case 1: {
                if (this.chest.state.empty) break;
                this.addButton(Action.Take);
                break;
            }
        }
    }

    @Override
    public void updateLeftText() {
        switch (this.state) {
            case 1: {
                this.sb.setLength(0);
                if (this.chest.state.empty) {
                    this.sb.append("The container is empty.");
                } else {
                    this.sb.append("You find:\n");
                    if (this.chest._data.currency > 0) {
                        this.sb.append(this.chest._data.currency).append(" ").append("currency").append("\n");
                    }
                    if (this.chest._data.items != null && !this.chest._data.items.isEmpty()) {
                        for (ItemGroup itemGroup : this.chest._data.items) {
                            this.sb.append(itemGroup.size).append(" ").append(itemGroup.getName()).append("\n");
                        }
                    }
                }
                this.leftText = this.sb.toString();
                break;
            }
            case 2: {
                break;
            }
            default: {
                this.leftText = null;
            }
        }
    }

    @Override
    public void updateScene() {
        if (this.chest._data.scene != null) {
            super.setScene(this.chest._data.scene);
        } else {
            this.scene.portrait = "chest";
            this.scene.portraitTitle = "Chest";
            super.setScene(this.scene);
        }
    }

    public static enum Action {
        Open,
        Inspect,
        Unlock,
        Lockpick,
        Password,
        Disarm,
        Cancel,
        Take;

    }
}

