/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.Documentation;
import de.slashbinbash.hexen.InputMapper;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.combat.CombatLog;
import de.slashbinbash.hexen.combat.CombatState;
import de.slashbinbash.hexen.combat.Combatant;
import de.slashbinbash.hexen.combat.CombatantGroup;
import de.slashbinbash.hexen.combat.StaticCombat;
import de.slashbinbash.hexen.handler.IHandler;
import de.slashbinbash.hexen.message.Message;
import de.slashbinbash.hexen.message.MessageBus;
import de.slashbinbash.hexen.model.CombatAction;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.ItemLoot;
import de.slashbinbash.hexen.model.ItemType;
import de.slashbinbash.hexen.ui.Button;
import de.slashbinbash.hexen.view.CombatView;
import de.slashbinbash.hexen.view.StaticView;
import de.slashbinbash.opengl.JoystickEvent;
import de.slashbinbash.opengl.KeyboardEvent;
import de.slashbinbash.opengl.MouseEvent;
import de.slashbinbash.opengl.renderer.Draw2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class CombatHandler
implements IHandler {
    public Combatant currCombatant = null;
    public LinkedList<CombatState.Action> actionQueue = new LinkedList();
    private int keyboardOption = -1;
    private CombatAction mCombatAction = null;
    private List<Combatant> mCombatants = new ArrayList<Combatant>(0);
    private List<CombatantGroup> mCombatantGroups = new ArrayList<CombatantGroup>(0);
    public List<Button> buttons = new ArrayList<Button>();
    public int buttonIndex = 0;
    public CombatState combatState = null;
    public State state = State.INIT_CONFIRMER;
    private int ignoreCommands = 20;
    private boolean inputLock = true;
    private boolean requestedClose = false;

    private void addButton(CombatAction combatAction) {
        StaticView.addButton(this.buttons, combatAction.getName(), combatAction);
    }

    private void addButton(Combatant combatant) {
        StaticView.addButton(this.buttons, combatant.getName(), combatant);
    }

    private void addButton(CombatantGroup combatantGroup) {
        StaticView.addButton(this.buttons, combatantGroup.getName(), combatantGroup);
    }

    private void addButton(Item item) {
        StaticView.addButton(this.buttons, item.getName(), item);
    }

    private void addButton(State state) {
        StaticView.addButton(this.buttons, state.name(), (Object)state);
    }

    private void addButton(String string, State state) {
        StaticView.addButton(this.buttons, string, (Object)state);
    }

    private void cancelPickOpt() {
        Combatant combatant;
        if (this.actionQueue.isEmpty()) {
            return;
        }
        Combatant combatant2 = null;
        for (int i = 0; i < this.actionQueue.size() && (combatant = this.actionQueue.get((int)i).subject) != this.currCombatant; ++i) {
            if (!combatant.isPlayable) continue;
            combatant2 = combatant;
        }
        if (combatant2 == null) {
            return;
        }
        do {
            this.currCombatant = this.actionQueue.removeLast().subject;
        } while (this.currCombatant != combatant2);
        this.resetUI();
    }

    private void close() {
        this.requestedClose = true;
    }

    @Override
    public void draw(Draw2D draw2D) {
        if (this.ignoreCommands > 0) {
            --this.ignoreCommands;
            if (this.ignoreCommands == 0) {
                this.inputLock = false;
            }
        }
        CombatView.draw(draw2D, this);
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state.ordinal()) {
            case 0: {
                this.handlePickInit(commandEvent, object);
                break;
            }
            case 5: {
                this.handlePickOpt(commandEvent, object);
                break;
            }
            case 6: {
                this.handlePickCreature(commandEvent, object);
                break;
            }
            case 7: {
                this.handlePickGroup(commandEvent, object);
                break;
            }
            case 8: {
                this.handlePickItem(commandEvent, object);
                break;
            }
            case 1: {
                this.handlePickTurn(commandEvent, object);
                break;
            }
            case 2: {
                this.handleConfirmLog(commandEvent, object);
                break;
            }
            case 3: {
                this.handlePickLoot(commandEvent, object);
                break;
            }
            case 4: {
                this.handleConfirmExit(commandEvent, object);
                break;
            }
            case 9: {
                this.combatState.exit();
                MessageBus.push(Message.STATE_POP, null);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.updateButtons();
    }

    private void handleConfirmExit(CommandEvent commandEvent, Object object) {
        switch (this.combatState.state) {
            case EXIT: {
                if (commandEvent != CommandEvent.CONFIRM) break;
                this.state = State.EXIT;
                this.combatState.exit();
                MessageBus.push(Message.STATE_POP, null);
                break;
            }
        }
    }

    private void handleConfirmLog(CommandEvent commandEvent, Object object) {
        if (commandEvent == CommandEvent.PREVIOUS) {
            CombatView.text.prevPage();
        } else if (commandEvent == CommandEvent.NEXT) {
            CombatView.text.nextPage();
        }
        switch (this.combatState.state) {
            case RUN: {
                if (commandEvent != CommandEvent.CONFIRM) break;
                this.resetUI();
                this.nextCombatant();
                break;
            }
            case LOOT: {
                List<ItemLoot> list;
                if (commandEvent != CommandEvent.CONFIRM) break;
                boolean bl = true;
                StringBuilder stringBuilder = new StringBuilder();
                if (this.combatState.model.endText != null) {
                    stringBuilder.append(this.combatState.model.endText + "\n\n");
                    bl = false;
                }
                if ((list = this.combatState.getLoot()) != null && !list.isEmpty()) {
                    CombatLog.Loot(stringBuilder, list);
                    bl = false;
                }
                if (bl) {
                    this.combatState.state = CombatState.Stat.EXIT;
                    this.combatState.exit();
                    MessageBus.push(Message.STATE_POP, null);
                    break;
                }
                CombatView.print(stringBuilder);
                this.state = State.LOOT_CONFIRMER;
                break;
            }
            case EXIT: {
                if (commandEvent != CommandEvent.CONFIRM) break;
                if (this.combatState.model.endActions != null) {
                    CombatView.print(this.combatState.model.endText);
                    this.state = State.EXIT_CONFIRMER;
                    break;
                }
                this.combatState.exit();
                MessageBus.push(Message.STATE_POP, null);
                break;
            }
        }
    }

    @Override
    public void handleJoystick(JoystickEvent joystickEvent) {
        if (this.inputLock) {
            return;
        }
        if (!joystickEvent.down) {
            return;
        }
        CommandEvent commandEvent = InputMapper.translate(joystickEvent, (IHandler)this);
        if (commandEvent == null) {
            return;
        }
        this.handleCommand(commandEvent, joystickEvent);
    }

    @Override
    public void handleKeyboard(KeyboardEvent keyboardEvent) {
        if (this.inputLock) {
            return;
        }
        if (!keyboardEvent.down) {
            return;
        }
        CommandEvent commandEvent = InputMapper.translate(keyboardEvent, (IHandler)this);
        if (commandEvent == null) {
            return;
        }
        this.keyboardOption = InputMapper.getOptionIndex(commandEvent);
        this.handleCommand(commandEvent, keyboardEvent);
    }

    @Override
    public void handleMouse(MouseEvent mouseEvent) {
    }

    private void handlePickCreature(CommandEvent commandEvent, Object object) {
        if (0 <= this.keyboardOption && this.keyboardOption < this.buttons.size()) {
            this.buttonIndex = this.keyboardOption;
            commandEvent = CommandEvent.CONFIRM;
        }
        switch (commandEvent) {
            case PREVIOUS: {
                --this.buttonIndex;
                if (this.buttonIndex >= 0) break;
                this.buttonIndex = this.buttons.size() - 1;
                break;
            }
            case NEXT: {
                this.buttonIndex = (this.buttonIndex + 1) % this.buttons.size();
                break;
            }
            case CONFIRM: {
                Combatant combatant = (Combatant)this.buttons.get((int)this.buttonIndex).data;
                this.actionQueue.add(CombatState.Action.Attack(this.mCombatAction, this.currCombatant, combatant));
                this.nextCombatant();
                break;
            }
            case CANCEL: {
                this.state = State.PICK_OPT;
                break;
            }
        }
    }

    private void handlePickGroup(CommandEvent commandEvent, Object object) {
        if (0 <= this.keyboardOption && this.keyboardOption < this.buttons.size()) {
            this.buttonIndex = this.keyboardOption;
            commandEvent = CommandEvent.CONFIRM;
        }
        switch (commandEvent) {
            case PREVIOUS: {
                --this.buttonIndex;
                if (this.buttonIndex >= 0) break;
                this.buttonIndex = this.buttons.size() - 1;
                break;
            }
            case NEXT: {
                this.buttonIndex = (this.buttonIndex + 1) % this.buttons.size();
                break;
            }
            case CONFIRM: {
                CombatantGroup combatantGroup = (CombatantGroup)this.buttons.get((int)this.buttonIndex).data;
                int n = this.mCombatAction.getRangeFrom().ordinal();
                int n2 = this.mCombatAction.getRangeTo().ordinal();
                int n3 = this.currCombatant.range + combatantGroup.range + 1;
                if (n > n3 || n3 > n2) break;
                this.actionQueue.add(CombatState.Action.Attack(this.mCombatAction, this.currCombatant, combatantGroup));
                this.nextCombatant();
                break;
            }
            case CANCEL: {
                this.state = State.PICK_OPT;
                break;
            }
        }
    }

    private void handlePickInit(CommandEvent commandEvent, Object object) {
        if (0 <= this.keyboardOption && this.keyboardOption < this.buttons.size()) {
            this.buttonIndex = this.keyboardOption;
            commandEvent = CommandEvent.CONFIRM;
        }
        block0 : switch (commandEvent) {
            case PREVIOUS: {
                --this.buttonIndex;
                if (this.buttonIndex >= 0) break;
                this.buttonIndex = this.buttons.size() - 1;
                break;
            }
            case NEXT: {
                this.buttonIndex = (this.buttonIndex + 1) % this.buttons.size();
                break;
            }
            case CONFIRM: {
                State state = (State)((Object)this.buttons.get((int)this.buttonIndex).data);
                switch (state.ordinal()) {
                    case 12: {
                        if (this.combatState.model.ambushed) {
                            this.runCombat();
                            break block0;
                        }
                        this.state = State.PICK_OPT;
                        break block0;
                    }
                    case 13: {
                        boolean bl = this.combatState.tryRunAway();
                        if (bl) {
                            assert (this.combatState.state == CombatState.Stat.EXIT);
                            this.combatState.exit();
                            MessageBus.push(Message.STATE_POP, null);
                            break block0;
                        }
                        this.runCombat();
                        this.currCombatant = null;
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void handlePickItem(CommandEvent commandEvent, Object object) {
        if (0 <= this.keyboardOption && this.keyboardOption < this.buttons.size()) {
            this.buttonIndex = this.keyboardOption;
            commandEvent = CommandEvent.CONFIRM;
        }
        switch (commandEvent) {
            case PREVIOUS: {
                --this.buttonIndex;
                if (this.buttonIndex >= 0) break;
                this.buttonIndex = this.buttons.size() - 1;
                break;
            }
            case NEXT: {
                this.buttonIndex = (this.buttonIndex + 1) % this.buttons.size();
                break;
            }
            case CONFIRM: {
                if (this.buttons.size() <= 0) break;
                Item item = (Item)this.buttons.get((int)this.buttonIndex).data;
                this.actionQueue.addLast(CombatState.Action.UseItem(item, this.currCombatant));
                this.nextCombatant();
                break;
            }
            case CANCEL: {
                this.state = State.PICK_OPT;
                break;
            }
            case SHOW_DOCUMENTATION: {
                if (this.buttons.size() <= 0) break;
                Item item = (Item)this.buttons.get((int)this.buttonIndex).data;
                Documentation.showItem(item);
                break;
            }
        }
    }

    private void handlePickLoot(CommandEvent commandEvent, Object object) {
        if (0 <= this.keyboardOption && this.keyboardOption < this.buttons.size()) {
            this.buttonIndex = this.keyboardOption;
            commandEvent = CommandEvent.CONFIRM;
        }
        switch (commandEvent) {
            case PREVIOUS: {
                --this.buttonIndex;
                if (this.buttonIndex >= 0) break;
                this.buttonIndex = this.buttons.size() - 1;
                break;
            }
            case NEXT: {
                this.buttonIndex = (this.buttonIndex + 1) % this.buttons.size();
                break;
            }
            case CONFIRM: {
                State state = (State)((Object)this.buttons.get((int)this.buttonIndex).data);
                switch (state.ordinal()) {
                    case 15: {
                        this.combatState.loot(true);
                        break;
                    }
                    case 16: {
                        this.combatState.loot(false);
                        break;
                    }
                }
                this.combatState.exit();
                this.state = State.EXIT;
                MessageBus.push(Message.STATE_POP, null);
                break;
            }
        }
    }

    private void handlePickOpt(CommandEvent commandEvent, Object object) {
        if (0 <= this.keyboardOption && this.keyboardOption < this.buttons.size()) {
            this.buttonIndex = this.keyboardOption;
            commandEvent = CommandEvent.CONFIRM;
        }
        block0 : switch (commandEvent) {
            case PREVIOUS: {
                --this.buttonIndex;
                if (this.buttonIndex >= 0) break;
                this.buttonIndex = this.buttons.size() - 1;
                break;
            }
            case NEXT: {
                this.buttonIndex = (this.buttonIndex + 1) % this.buttons.size();
                break;
            }
            case CONFIRM: {
                Object object2 = this.buttons.get((int)this.buttonIndex).data;
                if (object2 instanceof CombatAction) {
                    CombatAction combatAction = (CombatAction)object2;
                    this.mCombatAction = null;
                    this.mCombatants.clear();
                    this.mCombatantGroups.clear();
                    switch (combatAction.getTarget()) {
                        case ENEMY_ALL: {
                            List<Combatant> list = StaticCombat.filterRangeCombatants(combatAction, this.currCombatant, this.combatState.enemies);
                            CombatantGroup combatantGroup = new CombatantGroup(list);
                            this.actionQueue.add(CombatState.Action.Attack(combatAction, this.currCombatant, combatantGroup));
                            this.nextCombatant();
                            break block0;
                        }
                        case ENEMY_GROUP_ALL: {
                            List<CombatantGroup> list = StaticCombat.filterRangeGroups(combatAction, this.currCombatant, this.combatState.enemyGroups);
                            if (list.size() == 1) {
                                this.actionQueue.add(CombatState.Action.Attack(combatAction, this.currCombatant, list.get(0)));
                                this.nextCombatant();
                                break block0;
                            }
                            if (list.size() <= 1) break block0;
                            this.mCombatAction = combatAction;
                            this.mCombatantGroups.addAll(list);
                            this.state = State.PICK_GROUP;
                            break block0;
                        }
                        case ENEMY_GROUP_ONE: {
                            List<CombatantGroup> list = StaticCombat.filterRangeGroups(combatAction, this.currCombatant, this.combatState.enemyGroups);
                            if (list.size() == 1) {
                                this.actionQueue.add(CombatState.Action.Attack(combatAction, this.currCombatant, list.get(0)));
                                this.nextCombatant();
                                break block0;
                            }
                            if (list.size() <= 1) break block0;
                            this.mCombatAction = combatAction;
                            this.mCombatantGroups.addAll(list);
                            this.state = State.PICK_GROUP;
                            break block0;
                        }
                        case ENEMY_ONE: {
                            List<Combatant> list = StaticCombat.filterRangeCombatants(combatAction, this.currCombatant, this.combatState.enemies);
                            CombatantGroup combatantGroup = new CombatantGroup(list);
                            if (combatantGroup.size() == 1) {
                                this.actionQueue.add(CombatState.Action.Attack(combatAction, this.currCombatant, combatantGroup));
                                this.nextCombatant();
                                break block0;
                            }
                            if (combatantGroup.size() <= 1) break block0;
                            this.mCombatAction = combatAction;
                            this.mCombatants.addAll(combatantGroup.list());
                            this.state = State.PICK_CREATURE;
                            break block0;
                        }
                        case PARTY_ALL: {
                            CombatantGroup combatantGroup = new CombatantGroup(this.combatState.allies);
                            this.actionQueue.add(CombatState.Action.Attack(combatAction, this.currCombatant, combatantGroup));
                            this.nextCombatant();
                            break block0;
                        }
                        case PARTY_GROUP_ALL: {
                            CombatantGroup combatantGroup = this.combatState.allyGroups.get(0);
                            CombatantGroup combatantGroup2 = this.combatState.allyGroups.get(1);
                            if (combatantGroup.isActive() && !combatantGroup2.isActive()) {
                                this.actionQueue.add(CombatState.Action.Attack(combatAction, this.currCombatant, combatantGroup));
                                this.nextCombatant();
                                break block0;
                            }
                            if (!combatantGroup.isActive() && combatantGroup2.isActive()) {
                                this.actionQueue.add(CombatState.Action.Attack(combatAction, this.currCombatant, combatantGroup2));
                                this.nextCombatant();
                                break block0;
                            }
                            if (combatantGroup.isActive() && combatantGroup2.isActive()) {
                                this.mCombatAction = combatAction;
                                this.mCombatantGroups.addAll(this.combatState.allyGroups);
                                this.state = State.PICK_GROUP;
                                break block0;
                            }
                            assert (false);
                            break block0;
                        }
                        case PARTY_ONE: {
                            CombatantGroup combatantGroup = new CombatantGroup(this.combatState.allies);
                            combatantGroup.removeIf(combatant -> combatant.hasRunAway());
                            if (combatantGroup.size() == 1) {
                                this.actionQueue.add(CombatState.Action.Attack(combatAction, this.currCombatant, combatantGroup));
                                this.nextCombatant();
                                break block0;
                            }
                            if (combatantGroup.size() <= 1) break block0;
                            this.mCombatAction = combatAction;
                            this.mCombatants.addAll(combatantGroup.list());
                            this.state = State.PICK_CREATURE;
                            break block0;
                        }
                        case SELF: {
                            CombatantGroup combatantGroup = new CombatantGroup();
                            combatantGroup.add(this.currCombatant);
                            this.actionQueue.add(CombatState.Action.Attack(combatAction, this.currCombatant, combatantGroup));
                            this.nextCombatant();
                            break block0;
                        }
                    }
                    break;
                }
                if (object2 instanceof State) {
                    State state = (State)((Object)object2);
                    switch (state.ordinal()) {
                        case 11: {
                            this.state = State.PICK_ITEM;
                            break block0;
                        }
                        case 13: {
                            this.actionQueue.add(CombatState.Action.RunAway(this.currCombatant));
                            this.nextCombatant();
                            break block0;
                        }
                        case 14: {
                            this.actionQueue.add(CombatState.Action.Pass(this.currCombatant));
                            this.nextCombatant();
                            break block0;
                        }
                        case 20: {
                            this.actionQueue.add(CombatState.Action.MoveBackward(this.currCombatant));
                            this.nextCombatant();
                            break block0;
                        }
                        case 19: {
                            this.actionQueue.add(CombatState.Action.MoveForward(this.currCombatant));
                            this.nextCombatant();
                            break block0;
                        }
                    }
                    break;
                }
                assert (false);
                break;
            }
            case CANCEL: {
                this.cancelPickOpt();
                break;
            }
            case SHOW_DOCUMENTATION: {
                Object object3 = this.buttons.get((int)this.buttonIndex).data;
                if (!(object3 instanceof CombatAction)) break;
                CombatAction combatAction = (CombatAction)object3;
                Documentation.showCombatAction(combatAction);
                break;
            }
        }
    }

    private void handlePickTurn(CommandEvent commandEvent, Object object) {
        if (0 <= this.keyboardOption && this.keyboardOption < this.buttons.size()) {
            this.buttonIndex = this.keyboardOption;
            commandEvent = CommandEvent.CONFIRM;
        }
        block0 : switch (commandEvent) {
            case PREVIOUS: {
                --this.buttonIndex;
                if (this.buttonIndex >= 0) break;
                this.buttonIndex = this.buttons.size() - 1;
                break;
            }
            case NEXT: {
                this.buttonIndex = (this.buttonIndex + 1) % this.buttons.size();
                break;
            }
            case CONFIRM: {
                State state = (State)((Object)this.buttons.get((int)this.buttonIndex).data);
                switch (state.ordinal()) {
                    case 17: {
                        this.runCombat();
                        break block0;
                    }
                    case 18: {
                        this.resetUI();
                        this.actionQueue.clear();
                        this.currCombatant = null;
                        this.nextCombatant();
                        break block0;
                    }
                }
                break;
            }
            case CANCEL: {
                this.cancelPickOpt();
                assert (this.state == State.PICK_OPT);
                break;
            }
        }
    }

    public void init(CombatState combatState) {
        this.combatState = combatState;
        this.currCombatant = this.nextCombatant(this.currCombatant);
        CombatView.init(this);
        this.updateButtons();
        this.printCombatLog();
    }

    public boolean isPartyDead() {
        return RPG.getInstance().party.isDead();
    }

    private void nextCombatant() {
        this.resetUI();
        this.currCombatant = this.nextCombatant(this.currCombatant);
        while (this.currCombatant != null && !this.currCombatant.isPlayable) {
            this.actionQueue.add(this.combatState.combatAI.handle(this.currCombatant));
            this.currCombatant = this.nextCombatant(this.currCombatant);
        }
        if (this.currCombatant == null) {
            this.printActionQueue();
            this.state = State.TURN_CONFIRMER;
        } else {
            this.updateButtons();
        }
    }

    private Combatant nextCombatant(Combatant combatant) {
        List<Combatant> list = this.combatState.allies;
        int n = 0;
        if (combatant != null) {
            for (n = 0; n < list.size() && list.get(n) != combatant; ++n) {
            }
            ++n;
        }
        while (n < list.size()) {
            Combatant combatant2 = list.get(n);
            if (!(combatant2.ambushed || combatant2.isDead() || combatant2.hasRunAway())) {
                return combatant2;
            }
            ++n;
        }
        return null;
    }

    private void printActionQueue() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CombatState.Action action : this.actionQueue) {
            block0 : switch (action.action) {
                case ATTACK: {
                    String string = action.subject.getName();
                    String string2 = action.objects.get(0).getName();
                    String string3 = action.combatAction.getName();
                    int n = action.objects.get((int)0).range + 1;
                    switch (action.combatAction.getTarget()) {
                        case ENEMY_ALL: {
                            stringBuilder.append(String.format("%s uses %s on enemies.", string, string3));
                            break block0;
                        }
                        case PARTY_ALL: {
                            stringBuilder.append(String.format("%s uses %s on party.", string, string3));
                            break block0;
                        }
                        case PARTY_GROUP_ALL: {
                            String string4 = action.objects.range == 0 ? "front row" : "back row";
                            stringBuilder.append(String.format("%s uses %s on %s (%d).", string, string3, string4, n));
                            break block0;
                        }
                        case ENEMY_GROUP_ALL: 
                        case ENEMY_GROUP_ONE: {
                            stringBuilder.append(String.format("%s uses %s on group %s (%d).", string, string3, string2, n));
                            break block0;
                        }
                        case ENEMY_ONE: {
                            stringBuilder.append(String.format("%s uses %s on %s (%d).", string, string3, string2, n));
                            break block0;
                        }
                        case PARTY_ONE: {
                            if (string != string2) {
                                stringBuilder.append(String.format("%s uses %s on %s (%d).", string, string3, string2, n));
                                break block0;
                            }
                            stringBuilder.append(String.format("%s uses %s on self.", string, string3));
                            break block0;
                        }
                        case SELF: {
                            stringBuilder.append(String.format("%s uses %s on self.", string, string3));
                            break block0;
                        }
                    }
                    break;
                }
                case RUN_AWAY: {
                    String string = action.subject.getName();
                    stringBuilder.append(String.format("%s tries to run away.", string));
                    break;
                }
                case USE_ITEM: {
                    String string = action.subject.getName();
                    String string2 = action.item.getName();
                    stringBuilder.append(String.format("%s uses %s.", string, string2));
                    break;
                }
                case PASS: {
                    String string = action.subject.getName();
                    stringBuilder.append(String.format("%s passes.", string));
                    break;
                }
                default: {
                    stringBuilder.append(action.toString());
                }
            }
            stringBuilder.append("\n");
        }
        CombatView.print(stringBuilder);
    }

    private void printCombatLog() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.combatState.combatLog.list()) {
            stringBuilder.append(string);
            stringBuilder.append("\n\n");
        }
        CombatView.print(stringBuilder);
    }

    @Override
    public boolean requestedClose() {
        return this.requestedClose;
    }

    @Override
    public boolean requestedPop() {
        return false;
    }

    private void resetUI() {
        this.buttonIndex = 0;
        this.buttons.clear();
        this.mCombatAction = null;
        this.mCombatants.clear();
        this.mCombatantGroups.clear();
        this.state = State.PICK_OPT;
    }

    private void runCombat() {
        this.combatState.runCombat(this.actionQueue);
        this.printCombatLog();
        this.actionQueue.clear();
        this.state = State.LOG_CONFIRMER;
    }

    @Override
    public void update() {
    }

    private void updateButtons() {
        this.buttons.clear();
        switch (this.state.ordinal()) {
            case 4: {
                break;
            }
            case 9: {
                break;
            }
            case 0: {
                this.addButton("Fight!", State.Fight);
                if (!this.combatState.model.canRunAway || this.combatState.model.ambushed) break;
                this.addButton(State.Run);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                assert (this.combatState.loot != null && !this.combatState.loot.isEmpty());
                int n = this.combatState.calcValue(this.combatState.loot, 0.5f);
                this.addButton(State.Take);
                this.addButton("Leave ($" + n + ")", State.Leave);
                break;
            }
            case 6: {
                for (Combatant combatant : this.mCombatants) {
                    this.addButton(combatant);
                }
                break;
            }
            case 7: {
                for (CombatantGroup combatantGroup : this.mCombatantGroups) {
                    this.addButton(combatantGroup);
                }
                break;
            }
            case 8: {
                for (Item item : RPG.getInstance().party.inventory) {
                    if (item.getType() != ItemType.Consume || !item.isUseable()) continue;
                    this.addButton(item);
                }
                break;
            }
            case 5: {
                Combatant combatant = this.currCombatant;
                if (combatant.isSkippingTurn()) {
                    this.addButton(State.Pass);
                    break;
                }
                if (combatant.isPlayable) {
                    for (CombatAction combatAction : this.combatState.filterCombatActions(combatant, combatant.getCombatActions())) {
                        this.addButton(combatAction);
                    }
                    this.addButton(State.Item);
                }
                this.addButton(State.Run);
                break;
            }
            case 1: {
                this.addButton(State.Yes);
                this.addButton(State.No);
                break;
            }
        }
        if (this.buttons.size() > 0) {
            this.buttonIndex %= this.buttons.size();
        }
    }

    public static enum State {
        INIT_CONFIRMER,
        TURN_CONFIRMER,
        LOG_CONFIRMER,
        LOOT_CONFIRMER,
        EXIT_CONFIRMER,
        PICK_OPT,
        PICK_CREATURE,
        PICK_GROUP,
        PICK_ITEM,
        EXIT,
        END_TEXT,
        Item,
        Fight,
        Run,
        Pass,
        Take,
        Leave,
        Yes,
        No,
        MoveForward,
        MoveBackward;

    }
}

