/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.deadpool.DeadpoolSystem;
import de.slashbinbash.hexen.deadpool.StaticDeadpool;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.Inventory;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.Party;
import de.slashbinbash.hexen.view.StaticView;
import java.util.ArrayList;
import java.util.List;

public class DeadpoolHandler
extends HandlerBase {
    private static final int STATE_PICK = 0;
    private static final int STATE_OFFER_CREATURE = 1;
    private static final int STATE_TAKE_CREATURE = 2;
    private static final int STATE_TAKE_INVENTORY = 3;
    private static final int SHOW_MESSAGE = 4;
    private DeadpoolSystem deadpool = null;
    private List<ClassCreature> offering = new ArrayList<ClassCreature>();
    private List<ClassCreature> taking = new ArrayList<ClassCreature>();

    private void abandonParty() {
        StaticDeadpool.abandonParty();
    }

    private int calcBuy(ClassCreature classCreature) {
        int n = (int)((float)classCreature.calcVim() * (1.0f - classCreature.calcVimRatio()));
        n = Math.max(n, 1);
        if (classCreature.isDead()) {
            n *= 2;
        }
        return n;
    }

    private int calcSell(ClassCreature classCreature) {
        int n = (int)((float)classCreature.calcVim() * classCreature.calcVimRatio());
        if (classCreature.isDead()) {
            n /= 2;
        }
        return Math.max(n, 1);
    }

    private int calcTotal() {
        int n = 0;
        for (ClassCreature classCreature : this.offering) {
            n += this.calcSell(classCreature);
        }
        for (ClassCreature classCreature : this.taking) {
            n -= this.calcBuy(classCreature);
        }
        return n;
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 0: {
                this.handlePick(commandEvent, object);
                break;
            }
            case 1: {
                this.handleOfferCreature(commandEvent, object);
                break;
            }
            case 3: {
                this.handleTakeInventory(commandEvent, object);
                break;
            }
            case 4: {
                if (commandEvent != CommandEvent.CONFIRM && commandEvent != CommandEvent.CANCEL) break;
                super.popState();
                break;
            }
        }
    }

    private void handleLeaveParty() {
        StaticDeadpool.leaveParty();
        super.close();
    }

    private void handleOfferCreature(CommandEvent commandEvent, Object object) {
        block14: {
            switch (commandEvent) {
                case CONFIRM: {
                    Object object2 = super.getSelectedButton().data;
                    if (object2 == null) break;
                    if (object2 instanceof ClassCreature) {
                        ClassCreature classCreature = (ClassCreature)object2;
                        if (RPG.getInstance().party.getMembers().contains(classCreature)) {
                            if (this.offering.contains(classCreature)) {
                                this.offering.remove(classCreature);
                                break;
                            }
                            this.offering.add(classCreature);
                            break;
                        }
                        if (!this.deadpool.entry.party.getMembers().contains(classCreature)) break;
                        if (this.taking.contains(classCreature)) {
                            this.taking.remove(classCreature);
                            break;
                        }
                        this.taking.add(classCreature);
                        break;
                    }
                    if (!(object2 instanceof Action)) break;
                    Action action = (Action)((Object)object2);
                    switch (action.ordinal()) {
                        case 7: {
                            if (this.offering.size() > 0 && this.taking.size() > 0) {
                                Party party;
                                int n = this.calcTotal();
                                if (n < 0 || (party = RPG.getInstance().party).getMembers().size() - this.offering.size() + this.taking.size() > Party.MAX_SIZE) break;
                                if (this.taking.size() + this.offering.size() > 0) {
                                    this.deadpool.entry.party.getMembers().removeAll(this.taking);
                                    party.getMembers().removeAll(this.offering);
                                    this.deadpool.entry.party.getMembers().addAll(this.offering);
                                    party.getMembers().addAll(this.taking);
                                }
                                this.deadpool.set(null);
                                this.reset();
                                break;
                            }
                            break block14;
                        }
                        case 5: {
                            this.deadpool.set(null);
                            this.reset();
                            break;
                        }
                    }
                    break;
                }
                case CANCEL: {
                    this.offering.clear();
                    this.taking.clear();
                    break;
                }
            }
        }
    }

    private void handlePick(CommandEvent commandEvent, Object object) {
        block0 : switch (commandEvent) {
            case CONFIRM: {
                Action action = (Action)((Object)super.getSelectedButton().data);
                switch (action.ordinal()) {
                    case 0: {
                        this.abandonParty();
                        this.buttonIndex = 0;
                        break block0;
                    }
                    case 1: {
                        this.pushState(3);
                        break block0;
                    }
                    case 2: {
                        this.handleLeaveParty();
                        break block0;
                    }
                    case 3: {
                        this.handleSearchParty();
                        break block0;
                    }
                }
                break;
            }
            case CANCEL: {
                super.popState();
                break;
            }
        }
    }

    private void handleSearchParty() {
        StaticDeadpool.SearchResult searchResult = StaticDeadpool.searchParty();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SEARCH");
        if (searchResult != null) {
            stringBuilder.append(String.format("\n(%d,%d) %d Members %d Stacks", searchResult.x, searchResult.y, searchResult.partySize, searchResult.inventorySize));
        } else {
            stringBuilder.append("\nNo party found.");
        }
        this.showMessage(stringBuilder.toString(), new Object[0]);
    }

    private void handleTakeInventory(CommandEvent commandEvent, Object object) {
        block0 : switch (commandEvent) {
            case CONFIRM: {
                Action action = (Action)((Object)super.getSelectedButton().data);
                switch (action.ordinal()) {
                    case 4: {
                        if (this.deadpool.entry == null) {
                            return;
                        }
                        if (this.deadpool.entry.party.inventory.isEmpty()) {
                            return;
                        }
                        Inventory inventory = RPG.getInstance().party.inventory;
                        for (Item item : this.deadpool.entry.party.inventory.list()) {
                            inventory.add(item);
                        }
                        inventory.restack();
                        this.deadpool.entry.party.inventory = null;
                        this.pushState(1);
                        break block0;
                    }
                    case 5: {
                        this.deadpool.entry.party.inventory = null;
                        this.pushState(1);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void init() {
        this.deadpool = RPG.getInstance().deadpoolSystem;
        super.init();
    }

    private void reset() {
        this.offering.clear();
        this.taking.clear();
        while (this.states.size() > 0) {
            super.popState();
        }
    }

    private void showMessage(String string, Object ... objectArray) {
        this.leftText = String.format(string, objectArray);
        this.pushState(4);
    }

    @Override
    public void updateButtons() {
        switch (this.state) {
            case 0: {
                Location location = RPG.getInstance().party.getLocation();
                if (this.deadpool.contains(location)) {
                    super.addButton("Recover party", (Object)Action.RecoverParty);
                    super.addButton("Abandon party", (Object)Action.AbandonParty);
                    break;
                }
                super.addButton("Search party", (Object)Action.SearchParty);
                super.addButton("Leave party", (Object)Action.LeaveParty);
                break;
            }
            case 1: {
                String string;
                for (ClassCreature classCreature : RPG.getInstance().party.getMembers()) {
                    if (this.offering.contains(classCreature)) {
                        string = String.format("+ %3d %s", this.calcSell(classCreature), classCreature.name);
                        super.addButton(string, classCreature);
                        continue;
                    }
                    string = String.format("  %3d %s", this.calcSell(classCreature), classCreature.name);
                    super.addButton(string, classCreature);
                }
                super.addButton("", null);
                for (ClassCreature classCreature : this.deadpool.entry.party.getMembers()) {
                    if (this.taking.contains(classCreature)) {
                        string = String.format("- %3d %s", this.calcBuy(classCreature), classCreature.name);
                        super.addButton(string, classCreature);
                        continue;
                    }
                    string = String.format("  %3d %s", this.calcBuy(classCreature), classCreature.name);
                    super.addButton(string, classCreature);
                }
                super.addButton("", null);
                super.addButton("Trade", (Object)Action.Trade);
                super.addButton("Leave", (Object)Action.Leave);
                break;
            }
            case 3: {
                super.addButton("Take", (Object)Action.Take);
                super.addButton("Leave", (Object)Action.Leave);
                break;
            }
            case 4: {
                break;
            }
        }
    }

    @Override
    public void updateLeftText() {
        switch (this.state) {
            case 4: {
                break;
            }
            default: {
                this.leftText = null;
            }
        }
    }

    @Override
    public void updateRightText() {
        StringBuilder stringBuilder;
        this.rightText = null;
        if (this.state == 0) {
            Object object;
            stringBuilder = new StringBuilder();
            if (this.deadpool.entry != null && this.deadpool.contains((Location)(object = RPG.getInstance().party.getLocation()))) {
                stringBuilder.append("MEMBERS");
                for (ClassCreature classCreature : this.deadpool.entry.party.getMembers()) {
                    stringBuilder.append("\n").append(classCreature.name);
                }
                stringBuilder.append("\n\nINVENTORY\n");
                stringBuilder.append(this.deadpool.entry.party.inventory.size() + " stacks");
            }
            this.rightText = stringBuilder.toString();
        }
        if (this.state == 1) {
            stringBuilder = new StringBuilder();
            int n = this.calcTotal();
            stringBuilder.append("OFFER " + n);
            Object object = super.getSelectedButton().data;
            if (object != null && object instanceof ClassCreature) {
                ClassCreature classCreature;
                classCreature = (ClassCreature)object;
                stringBuilder.append("\n\n");
                StaticView.printStats(stringBuilder, classCreature);
            }
            this.rightText = stringBuilder.toString();
        }
        if (this.state == 2) {
            this.rightText = null;
        }
        switch (this.state) {
            case 3: {
                assert (!this.deadpool.entry.party.inventory.isEmpty());
                stringBuilder = new StringBuilder();
                stringBuilder.append("INVENTORY");
                for (Object object : this.deadpool.entry.party.inventory) {
                    stringBuilder.append("\n").append(((Item)object).count).append(" ").append(((Item)object).getName());
                }
                this.rightText = stringBuilder.toString();
                break;
            }
        }
    }

    @Override
    public void updateScene() {
        this.scene.portrait = "grimreaper";
        this.scene.portraitTitle = "Death Pool";
        super.setScene(this.scene);
    }

    public static enum Action {
        AbandonParty,
        RecoverParty,
        LeaveParty,
        SearchParty,
        Take,
        Leave,
        Skip,
        Trade;

    }
}

