/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.guild.Guild;
import de.slashbinbash.hexen.guild.StaticGuild;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.ui.Button;
import de.slashbinbash.hexen.view.StaticView;
import java.util.List;

public class GuildHandler
extends HandlerBase {
    private static final int PICK_ACTION = 0;
    private static final int PICK_CREATURE = 1;
    private static final int SHOW_MESSAGE = 2;
    private Action selectedAction = null;
    private Guild guild = null;

    public GuildHandler(HandlerBase handlerBase) {
        super.setScene(handlerBase.scene);
    }

    private ClassCreature getSelectedCreature() {
        if (0 <= this.buttonIndex && this.buttonIndex < this.buttons.size()) {
            return (ClassCreature)((Button)this.buttons.get((int)this.buttonIndex)).data;
        }
        return null;
    }

    public void handleJoinGuild(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                this.selectedAction = (Action)((Object)this.getSelectedButton().data);
                this.pushState(1);
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 0: {
                this.handlePickAction(commandEvent, object);
                break;
            }
            case 1: {
                this.handlePickCreature(commandEvent, object);
                break;
            }
            case 2: {
                super.popState();
            }
        }
    }

    private void handlePickAction(CommandEvent commandEvent, Object object) {
        block0 : switch (commandEvent) {
            case CONFIRM: {
                this.selectedAction = (Action)((Object)this.getSelectedButton().data);
                switch (this.selectedAction.ordinal()) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.pushState(1);
                        break block0;
                    }
                    case 3: {
                        if (!this.guild._data.canJoin) break block0;
                        RPG.getInstance().party.guild = this.guild._data.__id__;
                        this.showMessage("Joined guild.");
                        break block0;
                    }
                }
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    private void handlePickCreature(CommandEvent commandEvent, Object object) {
        if (this.buttons.isEmpty()) {
            if (commandEvent == CommandEvent.CANCEL || commandEvent == CommandEvent.CONFIRM) {
                this.resetState();
            }
            return;
        }
        block0 : switch (commandEvent) {
            case CONFIRM: {
                List<ClassCreature> list = null;
                switch (this.selectedAction.ordinal()) {
                    case 0: 
                    case 2: {
                        list = this.guild.state.entries;
                        break;
                    }
                    case 1: {
                        list = RPG.getInstance().party.getMembers();
                    }
                }
                switch (this.selectedAction.ordinal()) {
                    case 0: {
                        ClassCreature classCreature = this.getSelectedCreature();
                        if (!StaticGuild.moveToParty(this.guild, classCreature)) break block0;
                        list.remove(classCreature);
                        break block0;
                    }
                    case 1: {
                        if (list.size() <= 1) {
                            this.showMessage("You need at least one member in your party.");
                            break block0;
                        }
                        ClassCreature classCreature = this.getSelectedCreature();
                        if (classCreature.isAlive() && !this.guild._data.takesLiving) {
                            this.showMessage("Only dead members are accepted.");
                            break block0;
                        }
                        if (classCreature.isDead() && !this.guild._data.takesDead) {
                            this.showMessage("Only living members are accepted.");
                            break block0;
                        }
                        if (StaticGuild.moveToGuild(this.getSelectedCreature(), this.guild)) {
                            list.remove(classCreature);
                            break block0;
                        }
                        this.showMessage("Failed to move member.");
                        break block0;
                    }
                    case 2: {
                        ClassCreature classCreature = this.getSelectedCreature();
                        if (!StaticGuild.retire(this.guild, classCreature)) break block0;
                        list.remove(classCreature);
                        break block0;
                    }
                }
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    public void init(Guild guild) {
        assert (guild.state != null);
        this.guild = guild;
        this.reset();
    }

    private void reset() {
        this.resetState();
        super.init();
    }

    private void showMessage(String string) {
        this.leftText = string;
        this.pushState(2);
    }

    @Override
    public void updateButtons() {
        switch (this.state) {
            case 0: {
                super.addButton("Add to party", (Object)Action.AddToParty);
                super.addButton("Remove from party", (Object)Action.RemoveFromParty);
                super.addButton("Retire", (Object)Action.Retire);
                if (this.guild._data.location == null) break;
                super.addButton("Join guild", (Object)Action.JoinGuild);
                break;
            }
            case 1: {
                List<ClassCreature> list = null;
                switch (this.selectedAction.ordinal()) {
                    case 0: 
                    case 2: {
                        list = this.guild.state.entries;
                        break;
                    }
                    case 1: {
                        list = RPG.getInstance().party.getMembers();
                        break;
                    }
                }
                for (ClassCreature classCreature : list) {
                    String string = String.format("%-21s", classCreature.name);
                    super.addButton(string, classCreature);
                }
                break;
            }
        }
    }

    @Override
    public void updateLeftText() {
        if (this.state != 2) {
            this.leftText = null;
        }
        switch (this.state) {
            case 1: {
                switch (this.selectedAction.ordinal()) {
                    case 0: 
                    case 2: {
                        if (!this.guild.state.entries.isEmpty()) break;
                        this.leftText = String.format("No members in %s.", this.guild._data.label.toLowerCase());
                        break;
                    }
                    case 1: {
                        if (!RPG.getInstance().party.getMembers().isEmpty()) break;
                        this.leftText = "No members in party.";
                    }
                }
                break;
            }
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
        if (this.state == 2) {
            return;
        }
        switch (this.state) {
            case 1: {
                if (this.buttons.isEmpty()) break;
                ClassCreature classCreature = this.getSelectedCreature();
                StringBuilder stringBuilder = new StringBuilder();
                StaticView.printCharacterShort(stringBuilder, classCreature);
                this.rightText = stringBuilder.toString();
                break;
            }
            default: {
                if (this.guild.state.entries.isEmpty()) {
                    this.rightText = null;
                    break;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("MEMBERS");
                for (ClassCreature classCreature : this.guild.state.entries) {
                    stringBuilder.append("\n").append(classCreature.name);
                }
                this.rightText = stringBuilder.toString();
            }
        }
    }

    @Override
    public void updateScene() {
        if (this.guild._data.scene != null) {
            super.setScene(this.guild._data.scene);
        }
    }

    private static enum Action {
        AddToParty,
        RemoveFromParty,
        Retire,
        JoinGuild;

    }
}

