/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.bank.Bank;
import de.slashbinbash.hexen.bestiary.Bestiary;
import de.slashbinbash.hexen.camp.Camp;
import de.slashbinbash.hexen.chest.Chest;
import de.slashbinbash.hexen.combat.CombatState;
import de.slashbinbash.hexen.door.Door;
import de.slashbinbash.hexen.event.EventState;
import de.slashbinbash.hexen.general.General;
import de.slashbinbash.hexen.handler.BankHandler;
import de.slashbinbash.hexen.handler.BestiaryHandler;
import de.slashbinbash.hexen.handler.CampHandler;
import de.slashbinbash.hexen.handler.ChestHandler;
import de.slashbinbash.hexen.handler.CombatHandler;
import de.slashbinbash.hexen.handler.DeadpoolHandler;
import de.slashbinbash.hexen.handler.DocumentHandler;
import de.slashbinbash.hexen.handler.DoorHandler;
import de.slashbinbash.hexen.handler.EventHandler;
import de.slashbinbash.hexen.handler.GeneralHandler;
import de.slashbinbash.hexen.handler.IHandler;
import de.slashbinbash.hexen.handler.InventoryHandler;
import de.slashbinbash.hexen.handler.ModderHandler;
import de.slashbinbash.hexen.handler.PartyHandler;
import de.slashbinbash.hexen.handler.QuestHandler;
import de.slashbinbash.hexen.handler.SaveGameHandler;
import de.slashbinbash.hexen.handler.SpaceHandler;
import de.slashbinbash.hexen.handler.WorkbenchHandler;
import de.slashbinbash.hexen.message.ISubscriber;
import de.slashbinbash.hexen.message.Message;
import de.slashbinbash.hexen.message.MessageBus;
import de.slashbinbash.hexen.modder.Modder;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.Document;
import de.slashbinbash.hexen.workbench.Workbench;
import de.slashbinbash.opengl.JoystickEvent;
import de.slashbinbash.opengl.KeyboardEvent;
import de.slashbinbash.opengl.MouseEvent;
import de.slashbinbash.opengl.renderer.Draw2D;
import java.util.LinkedList;

public class HexenHandler
implements ISubscriber,
IHandler {
    public SpaceHandler spaceHandler = new SpaceHandler();
    private LinkedList<IHandler> handlerStack = new LinkedList();

    public HexenHandler() {
        this.pushHandler(this.spaceHandler);
        MessageBus.subscribe(this);
    }

    public void clear() {
        this.handlerStack.clear();
    }

    @Override
    public void draw(Draw2D draw2D) {
        if (!this.handlerStack.isEmpty()) {
            this.peekHandler().draw(draw2D);
        }
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        this.peekHandler().handleCommand(commandEvent, object);
    }

    @Override
    public void handleKeyboard(KeyboardEvent keyboardEvent) {
        if (!this.handlerStack.isEmpty()) {
            this.peekHandler().handleKeyboard(keyboardEvent);
            if (this.peekHandler().requestedPop()) {
                this.popHandler();
            }
            if (this.peekHandler().requestedClose()) {
                this.popHandlers();
            }
        }
    }

    @Override
    public void handleMouse(MouseEvent mouseEvent) {
        if (!this.handlerStack.isEmpty()) {
            this.peekHandler().handleMouse(mouseEvent);
        }
    }

    private boolean isPartyDead() {
        RPG rPG = RPG.getInstance();
        for (ClassCreature classCreature : rPG.party.getMembers()) {
            if (classCreature.isDead()) continue;
            return false;
        }
        return false;
    }

    @Override
    public void notify(Message message, Object object) {
        switch (message) {
            case STATE_POP: {
                this.popHandler();
                break;
            }
            case STATE_PUSH: {
                if (object instanceof Bank) {
                    Bank bank = (Bank)object;
                    this.pushBankHandler(bank);
                    break;
                }
                if (object instanceof Bestiary) {
                    Bestiary bestiary = (Bestiary)object;
                    this.pushBestiaryHandler(bestiary);
                    break;
                }
                if (object instanceof Camp) {
                    Camp camp = (Camp)object;
                    this.pushCampHandler(camp);
                    break;
                }
                if (object instanceof Chest) {
                    Chest chest = (Chest)object;
                    this.pushChestHandler(chest);
                    break;
                }
                if (object instanceof CombatState) {
                    CombatState combatState = (CombatState)object;
                    this.pushCombatHandler(combatState);
                    break;
                }
                if (object instanceof Document) {
                    Document document = (Document)object;
                    this.pushDocumentHandler(document);
                    break;
                }
                if (object instanceof Door) {
                    Door door = (Door)object;
                    this.pushDoorHandler(door);
                    break;
                }
                if (object instanceof EventState) {
                    EventState eventState = (EventState)object;
                    this.pushEventHandler(eventState);
                    break;
                }
                if (object instanceof General) {
                    General general = (General)object;
                    this.pushGeneralHandler(general);
                    break;
                }
                if (object instanceof Modder) {
                    Modder modder = (Modder)object;
                    this.pushModderHandler(modder);
                    break;
                }
                if (object instanceof Workbench) {
                    Workbench workbench = (Workbench)object;
                    this.pushWorkbenchHandler(workbench);
                    break;
                }
                assert (false) : "Unhandled state: " + String.valueOf(object);
                break;
            }
        }
    }

    private IHandler peekHandler() {
        return this.handlerStack.peek();
    }

    public IHandler popHandler() {
        IHandler iHandler = this.handlerStack.pop();
        this.handlerStack.peek().update();
        return iHandler;
    }

    private void popHandlers() {
        while (this.handlerStack.size() > 1) {
            this.handlerStack.pop();
        }
    }

    public void pushBankHandler(Bank bank) {
        BankHandler bankHandler = new BankHandler();
        bankHandler.init();
        this.pushHandler(bankHandler);
    }

    public void pushBestiaryHandler(Bestiary bestiary) {
        BestiaryHandler bestiaryHandler = new BestiaryHandler();
        bestiaryHandler.init(bestiary);
        this.pushHandler(bestiaryHandler);
    }

    private void pushCampHandler(Camp camp) {
        CampHandler campHandler = new CampHandler();
        campHandler.init(camp);
        this.pushHandler(campHandler);
    }

    private void pushChestHandler(Chest chest) {
        ChestHandler chestHandler = new ChestHandler();
        chestHandler.init(chest);
        this.pushHandler(chestHandler);
    }

    private void pushCombatHandler(CombatState combatState) {
        CombatHandler combatHandler = new CombatHandler();
        combatHandler.init(combatState);
        this.pushHandler(combatHandler);
    }

    public void pushDeadpoolHandler() {
        DeadpoolHandler deadpoolHandler = new DeadpoolHandler();
        deadpoolHandler.init();
        this.pushHandler(deadpoolHandler);
    }

    private void pushDocumentHandler(Document document) {
        DocumentHandler documentHandler = new DocumentHandler();
        documentHandler.init(document);
        this.pushHandler(documentHandler);
    }

    private void pushDoorHandler(Door door) {
        DoorHandler doorHandler = new DoorHandler();
        doorHandler.init(door);
        this.pushHandler(doorHandler);
    }

    private void pushEventHandler(EventState eventState) {
        EventHandler eventHandler = new EventHandler();
        eventHandler.init(eventState);
        this.pushHandler(eventHandler);
    }

    private void pushGeneralHandler(General general) {
        GeneralHandler generalHandler = new GeneralHandler();
        generalHandler.init(general);
        this.pushHandler(generalHandler);
    }

    public void pushHandler(IHandler iHandler) {
        assert (!this.handlerStack.contains(iHandler));
        this.handlerStack.push(iHandler);
    }

    public void pushInventoryHandler() {
        InventoryHandler inventoryHandler = new InventoryHandler();
        inventoryHandler.init();
        this.pushHandler(inventoryHandler);
    }

    private void pushModderHandler(Modder modder) {
        ModderHandler modderHandler = new ModderHandler();
        modderHandler.init(modder);
        this.pushHandler(modderHandler);
    }

    public void pushPartyHandler() {
        PartyHandler partyHandler = new PartyHandler();
        partyHandler.init();
        this.pushHandler(partyHandler);
    }

    public void pushQuestHandler() {
        QuestHandler questHandler = new QuestHandler();
        questHandler.init();
        this.pushHandler(questHandler);
    }

    public void pushRestHandler() {
        CampHandler campHandler = new CampHandler();
        campHandler.init();
        this.pushHandler(campHandler);
    }

    public void pushSaveGameHandler() {
        SaveGameHandler saveGameHandler = new SaveGameHandler();
        saveGameHandler.init();
        this.pushHandler(saveGameHandler);
    }

    private void pushSpaceHandler() {
        assert (!this.handlerStack.contains(this.spaceHandler));
        this.pushHandler(this.spaceHandler);
    }

    private void pushWorkbenchHandler(Workbench workbench) {
        WorkbenchHandler workbenchHandler = new WorkbenchHandler();
        workbenchHandler.init(workbench);
        this.pushHandler(workbenchHandler);
    }

    @Override
    public boolean requestedClose() {
        return this.peekHandler().requestedClose();
    }

    @Override
    public boolean requestedPop() {
        return this.peekHandler().requestedPop();
    }

    @Override
    public void update() {
        this.peekHandler().update();
    }

    @Override
    public void handleJoystick(JoystickEvent joystickEvent) {
        if (!this.handlerStack.isEmpty()) {
            this.peekHandler().handleJoystick(joystickEvent);
            if (this.peekHandler().requestedPop()) {
                this.popHandler();
            }
            if (this.peekHandler().requestedClose()) {
                this.popHandlers();
            }
        }
    }
}

