/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.guild.Hire;
import de.slashbinbash.hexen.guild.StaticHire;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.ui.Button;
import de.slashbinbash.hexen.view.StaticView;
import java.util.List;

public class HireHandler
extends HandlerBase {
    private static final int PICK_CREATURE = 0;
    private static final int SHOW_MESSAGE = 1;
    private Hire hire = null;

    public HireHandler(HandlerBase handlerBase) {
        super.setScene(handlerBase.scene);
    }

    private void addButton(Hire.Data.Entry entry) {
        ClassCreature classCreature = entry.creature;
        String string = String.format("%-23s %4d", classCreature.name, entry.cost);
        StaticView.addButton((List<Button>)this.buttons, string, entry);
    }

    private ClassCreature getSelectedCreature() {
        return ((Hire.Data.Entry)((Button)this.buttons.get((int)this.buttonIndex)).data).creature;
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 0: {
                this.handlePickCreature(commandEvent, object);
                break;
            }
            case 1: {
                if (commandEvent != CommandEvent.CONFIRM && commandEvent != CommandEvent.CANCEL) break;
                this.reset();
                break;
            }
        }
    }

    private void handlePickCreature(CommandEvent commandEvent, Object object) {
        block0 : switch (commandEvent) {
            case CONFIRM: {
                Hire.Data.Entry entry = (Hire.Data.Entry)((Button)this.buttons.get((int)this.buttonIndex)).data;
                StaticHire.Result result = StaticHire.canHireAndPay(entry);
                switch (result) {
                    case OK: {
                        result = StaticHire.hire(entry, this.hire._data.vimRatio);
                        switch (result) {
                            case OK: {
                                break block0;
                            }
                        }
                        this.showMessage(result.name(), new Object[0]);
                        break block0;
                    }
                    case ALREADY_IN_PARTY: {
                        this.showMessage("%s is already in your party.", entry.creature.name);
                        break block0;
                    }
                    case NOT_ENOUGH_MONEY: {
                        this.showMessage("You don't have enough currency.", entry.creature.name);
                        break block0;
                    }
                }
                this.showMessage(result.name(), new Object[0]);
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    public void init(Hire hire) {
        this.hire = hire;
        this.reset();
    }

    private void reset() {
        this.resetState();
        super.init();
    }

    private void showMessage(String string, Object ... objectArray) {
        this.leftText = String.format(string, objectArray);
        this.pushState(1);
    }

    @Override
    public void updateButtons() {
        if (this.state == 0) {
            List<Hire.Data.Entry> list = this.hire._data.entries;
            for (int i = 0; i < list.size(); ++i) {
                Hire.Data.Entry entry = list.get(i);
                if (StaticHire.canHire(entry) != StaticHire.Result.OK) continue;
                this.addButton(entry);
            }
        }
    }

    @Override
    public void updateLeftText() {
        switch (this.state) {
            case 1: {
                break;
            }
            default: {
                this.leftText = null;
            }
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
        switch (this.state) {
            case 0: {
                ClassCreature classCreature = this.getSelectedCreature();
                if (classCreature != null) {
                    this.scene.portrait = classCreature.portrait;
                    this.scene.portraitTitle = classCreature.name;
                } else {
                    this.scene.portrait = null;
                    this.scene.portraitTitle = "";
                }
                StringBuilder stringBuilder = new StringBuilder();
                StaticView.printCharacterShort(stringBuilder, classCreature);
                this.rightText = stringBuilder.toString();
                break;
            }
        }
    }

    @Override
    public void updateScene() {
        if (this.hire._data.scene != null) {
            super.setScene(this.hire._data.scene);
        }
    }
}

