/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.model.Inventory;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.ItemType;
import de.slashbinbash.hexen.model.Party;
import de.slashbinbash.hexen.shop.Identify;
import de.slashbinbash.hexen.shop.StaticIdentify;
import de.slashbinbash.hexen.ui.Button;

public class IdentifyHandler
extends HandlerBase {
    private static final int PICK_ITEM = 0;
    private static final int SHOW_MESSAGE = 1;
    private Identify identify = null;

    public IdentifyHandler(HandlerBase handlerBase) {
        super.setScene(handlerBase.scene);
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 0: {
                this.handleIdentifyItem(commandEvent, object);
                break;
            }
            case 1: {
                if (commandEvent != CommandEvent.CONFIRM) break;
                this.popState();
                break;
            }
        }
    }

    private void handleIdentifyItem(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                Item item;
                boolean bl;
                if (this.buttons.isEmpty()) break;
                Party party = RPG.getInstance().party;
                Item item2 = (Item)super.getSelectedButton().data;
                int n = StaticIdentify.calcCost(item2);
                if (n > party.inventory.getCurrency() || !(bl = StaticIdentify.canIdentify(item2, this.identify._data.abilities)) || (item = StaticIdentify.getIdentifiedItem(item2)) == null) break;
                party.inventory.removeCurrency(n);
                party.inventory.removeAll(item2);
                RPG.getInstance().shopSystem.addIdentified(item2);
                party.inventory.add(item);
                String string = String.format("You identified:\n%s", item.getName());
                this.showMessage(string);
                break;
            }
            case CANCEL: {
                super.popState();
                break;
            }
        }
    }

    public void init(Identify identify) {
        this.identify = identify;
        super.init();
    }

    private void showMessage(String string) {
        this.leftText = string;
        this.pushState(1);
    }

    @Override
    public void updateButtons() {
        Party party = RPG.getInstance().party;
        Inventory inventory = party.inventory;
        if (this.state == 0) {
            for (Item item : inventory.list(ItemType.Unidentified)) {
                boolean bl = StaticIdentify.canIdentify(item, this.identify._data.abilities);
                Object object = item.getName();
                if (!bl) {
                    object = "?" + (String)object;
                }
                int n = StaticIdentify.calcCost(item);
                Object object2 = null;
                object2 = bl ? String.format("%-22s %3d", object, n) : object;
                Button button = super.addButton((String)object2, item);
                button.enabled = bl;
                button.sorting = bl ? 0 : 1;
            }
            super.sortButtons();
        }
    }

    @Override
    public void updateLeftText() {
        switch (this.state) {
            case 0: {
                if (this.buttons.isEmpty()) {
                    this.leftText = "No items to identify.";
                    break;
                }
                this.leftText = null;
                break;
            }
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
        if (this.state == 0) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.buttons.isEmpty()) {
                Item item = (Item)super.getSelectedButton().data;
                stringBuilder.append(item.getName());
                stringBuilder.append("\n\n");
                stringBuilder.append(item.getDescription());
            }
            this.rightText = stringBuilder.toString();
        }
    }

    @Override
    public void updateScene() {
        if (this.identify._data.scene != null) {
            super.setScene(this.identify._data.scene);
        }
    }
}

