/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.Documentation;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.message.Message;
import de.slashbinbash.hexen.message.MessageBus;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.Document;
import de.slashbinbash.hexen.model.Inventory;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.ItemType;
import de.slashbinbash.hexen.view.StaticView;
import java.util.List;

public class InventoryHandler
extends HandlerBase {
    private static final int PICK_ITEM = 0;
    private static final int PICK_ACTION = 1;
    private static final int PICK_CREATURE = 2;
    private static final int PICK_MAIN = 3;
    private static final int SHOW_MESSAGE = 4;
    private Item selectedItem = null;
    private Action selectedAction = null;
    private ClassCreature selectedCreature = null;
    private Filter[] filters = new Filter[]{Filter.All, Filter.Use, Filter.Equip, Filter.Document, Filter.Quest, Filter.Trade, Filter.Unidentified};
    private ItemType[] filterTypes = new ItemType[]{null, ItemType.Consume, ItemType.Equip, ItemType.Document, ItemType.Quest, ItemType.Trade, ItemType.Unidentified};
    private int filterIndex = 0;

    private int getIndex(Filter filter) {
        for (int i = 0; i < this.filters.length; ++i) {
            if (this.filters[i] != filter) continue;
            return i;
        }
        return 0;
    }

    private void addButton(Action action) {
        String string = null;
        switch (action.ordinal()) {
            case 2: {
                string = "Drop item";
                break;
            }
            case 3: {
                string = "Drop all";
                break;
            }
            case 1: {
                string = "Equip item";
                break;
            }
            case 4: {
                string = "Read";
                break;
            }
            case 0: {
                string = "Use item";
                break;
            }
        }
        super.addButton(string, (Object)action);
    }

    private void confirmDropAllItem() {
        StaticRPG.Result result = StaticRPG.dropItemAll(this.selectedItem);
        switch (result) {
            case OK: {
                super.resetState();
                if (this.selectedCreature != null) {
                    this.showMessage("%s dropped all %s.", this.selectedCreature.name, this.selectedItem.getName());
                    break;
                }
                this.showMessage("Dropped all %s.", this.selectedItem.getName());
                break;
            }
            default: {
                this.showMessage(result);
            }
        }
    }

    private void confirmDropItem() {
        StaticRPG.Result result = StaticRPG.dropItem(this.selectedItem);
        switch (result) {
            case OK: {
                super.resetState();
                this.showMessage("Dropped %s.", this.selectedItem.getName());
                break;
            }
            default: {
                this.showMessage(result);
            }
        }
    }

    private void confirmEquipItem() {
        StaticRPG.Result result = StaticRPG.equipItem(this.selectedCreature, this.selectedItem);
        switch (result) {
            case OK: {
                super.resetState();
                this.showMessage("%s equipped %s.", this.selectedCreature.name, this.selectedItem.getName());
                break;
            }
            case ITEM_ALREADY_EQUIPPED: {
                this.showMessage("Item is already equipped.", new Object[0]);
                break;
            }
            case FAILURE: {
                this.showMessage("%s could not be equipped.", this.selectedItem.getName());
                break;
            }
            default: {
                this.showMessage(result);
            }
        }
    }

    private void confirmUseItem() {
        StaticRPG.Result result = StaticRPG.useItem(this.selectedCreature, this.selectedItem, this.selectedCreature);
        switch (result) {
            case OK: {
                if (this.selectedItem.count == 0) {
                    super.resetState();
                }
                this.showMessage("%s used %s.", this.selectedCreature.name, this.selectedItem.getName());
                break;
            }
            default: {
                this.showMessage(result);
            }
        }
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 3: {
                this.handlePickMain(commandEvent, object);
                break;
            }
            case 1: {
                this.handlePickAction(commandEvent, object);
                break;
            }
            case 2: {
                this.handlePickCreature(commandEvent, object);
                break;
            }
            case 0: {
                this.handlePickItem(commandEvent, object);
                break;
            }
            case 4: {
                this.popState();
            }
        }
    }

    private void handlePickAction(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                if (this.buttons.isEmpty()) break;
                this.selectedAction = (Action)((Object)this.getSelectedButton().data);
                switch (this.selectedAction.ordinal()) {
                    case 0: {
                        this.pushState(2);
                        break;
                    }
                    case 1: {
                        this.pushState(2);
                        break;
                    }
                    case 2: {
                        this.confirmDropItem();
                        break;
                    }
                    case 3: {
                        assert (this.selectedItem.isDropable());
                        this.confirmDropAllItem();
                        break;
                    }
                    case 4: {
                        if (this.selectedItem._data.requirements != null && !this.selectedItem._data.requirements.checkAll(null)) break;
                        Document document = new Document(this.selectedItem);
                        MessageBus.push(Message.STATE_PUSH, document);
                        break;
                    }
                }
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    private void handlePickCreature(CommandEvent commandEvent, Object object) {
        if (this.buttons.isEmpty()) {
            commandEvent = CommandEvent.CANCEL;
        }
        block0 : switch (commandEvent) {
            case CONFIRM: {
                this.selectedCreature = (ClassCreature)this.getSelectedButton().data;
                switch (this.selectedAction.ordinal()) {
                    case 0: {
                        this.confirmUseItem();
                        break block0;
                    }
                    case 1: {
                        this.confirmEquipItem();
                        break block0;
                    }
                }
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    private void handlePickItem(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                if (this.buttons.size() <= 0) break;
                this.selectedItem = (Item)this.getSelectedButton().data;
                this.pushState(1);
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
            case TAB_RIGHT: {
                this.pushState(3);
                this.buttonIndex = this.filterIndex;
                break;
            }
            case SHOW_DOCUMENTATION: {
                Item item = (Item)this.getSelectedButton().data;
                Documentation.showItem(item);
                break;
            }
        }
    }

    private void handlePickMain(CommandEvent commandEvent, Object object) {
        block0 : switch (commandEvent) {
            case CONFIRM: {
                if (this.buttons.size() <= 0) break;
                Object object2 = this.getSelectedButton().data;
                if (object2 instanceof Filter) {
                    Filter filter = (Filter)((Object)object2);
                    switch (filter.ordinal()) {
                        case 0: {
                            this.filterIndex = this.getIndex(Filter.All);
                            this.popState();
                            break block0;
                        }
                        case 5: {
                            this.filterIndex = this.getIndex(Filter.Use);
                            this.popState();
                            break block0;
                        }
                        case 2: {
                            this.filterIndex = this.getIndex(Filter.Equip);
                            this.popState();
                            break block0;
                        }
                        case 3: {
                            this.filterIndex = this.getIndex(Filter.Quest);
                            this.popState();
                            break block0;
                        }
                        case 4: {
                            this.filterIndex = this.getIndex(Filter.Trade);
                            this.popState();
                            break block0;
                        }
                    }
                    break;
                }
                if (!(object2 instanceof Action)) break;
                Action action = (Action)((Object)object2);
                Action action2 = (Action)((Object)this.getSelectedButton().data);
                switch (action2.ordinal()) {
                    case 5: {
                        RPG.getInstance().party.inventory.restack();
                        break block0;
                    }
                    case 6: {
                        RPG.getInstance().party.inventory.sortByType();
                        break block0;
                    }
                }
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    @Override
    public void init() {
        super.init();
    }

    private void showMessage(StaticRPG.Result result) {
        switch (result) {
            case ITEM_NOT_USABLE: {
                this.showMessage("%s cannot be used.", this.selectedItem.getName());
                break;
            }
            case ITEM_NOT_EQUIPABLE: {
                this.showMessage("%s cannot be equipped.", this.selectedItem.getName());
                break;
            }
            case ITEM_NOT_DROPABLE: {
                this.showMessage("%s cannot be dropped.", this.selectedItem.getName());
                break;
            }
            case SKILL_CHECK_FAIL: {
                this.showMessage("%s doesn't have the required skill.", this.selectedCreature.name);
                break;
            }
            default: {
                this.showMessage(result.name(), new Object[0]);
            }
        }
    }

    private void showMessage(String string, Object ... objectArray) {
        this.leftText = String.format(string, objectArray);
        this.pushState(4);
    }

    @Override
    public void updateButtons() {
        switch (this.state) {
            case 3: {
                for (int i = 0; i < this.filters.length; ++i) {
                    int n = RPG.getInstance().party.inventory.size(this.filterTypes[i]);
                    String string = String.format("%-22s %3d", this.filters[i].name(), n);
                    super.addButton(string, (Object)this.filters[i]);
                }
                super.addButton("Restack", (Object)Action.Restack);
                super.addButton("Sort by type", (Object)Action.SortByType);
                break;
            }
            case 1: {
                if (this.selectedItem == null) {
                    this.addButton(Action.Use);
                    this.addButton(Action.Equip);
                    this.addButton(Action.Drop);
                    this.addButton(Action.DropAll);
                    break;
                }
                if (this.selectedItem.isUseable()) {
                    this.addButton(Action.Use);
                }
                if (this.selectedItem.isEquipable()) {
                    this.addButton(Action.Equip);
                }
                if (this.selectedItem.isReadable()) {
                    this.addButton(Action.Read);
                }
                if (!this.selectedItem.isDropable() || !StaticRPG.canDropItem(this.selectedItem)) break;
                this.addButton(Action.Drop);
                this.addButton(Action.DropAll);
                break;
            }
            case 2: {
                for (ClassCreature classCreature : RPG.getInstance().party.getMembers()) {
                    super.addButton(classCreature.name, classCreature);
                }
                break;
            }
            case 0: {
                Inventory inventory = RPG.getInstance().party.inventory;
                ItemType itemType = this.filterTypes[this.filterIndex];
                List<Item> list = null;
                list = itemType == null ? inventory.list() : inventory.list(itemType);
                for (Item item : list) {
                    Object object = item.getName();
                    if (item.getType() == ItemType.Unidentified) {
                        object = "?" + (String)object;
                    }
                    String string = String.format("%-24s %3d", object, item.count);
                    super.addButton(string, item);
                }
                break;
            }
        }
    }

    @Override
    public void updateLeftText() {
        switch (this.state) {
            case 4: {
                break;
            }
            default: {
                this.leftText = null;
            }
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
        switch (this.state) {
            case 3: {
                Enum enum_;
                StringBuilder stringBuilder = new StringBuilder();
                Inventory inventory = RPG.getInstance().party.inventory;
                Filter filter = Filter.All;
                Object object = super.getSelectedButton().data;
                if (object instanceof Filter) {
                    enum_ = (Filter)((Object)object);
                    filter = enum_;
                }
                List<Item> list = (enum_ = this.filterTypes[this.getIndex(filter)]) != null ? inventory.list((ItemType)enum_) : inventory.list();
                for (Item item : list) {
                    Object object2 = item.getName();
                    if (item.getType() == ItemType.Unidentified) {
                        object2 = "?" + (String)object2;
                    }
                    if (item.isEquipable() && StaticRPG.isEquipped(item)) {
                        object2 = (String)object2 + " (E)";
                    }
                    String string = String.format("%-20s %3d", object2, item.count);
                    stringBuilder.append(string).append("\n");
                }
                this.rightText = stringBuilder.toString();
                break;
            }
            case 1: {
                if (this.buttons.isEmpty()) break;
                this.rightText = this.selectedItem.getName();
                break;
            }
            case 2: {
                Item item = this.selectedItem;
                ClassCreature classCreature = (ClassCreature)this.getSelectedButton().data;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.selectedItem.getName());
                if (item.getType() == ItemType.Equip) {
                    Item item2 = item;
                    Item item3 = classCreature.equipment;
                    stringBuilder.append("\n\n");
                    StaticView.printDiff(stringBuilder, classCreature, item3, item2);
                }
                this.rightText = stringBuilder.toString();
                break;
            }
            case 0: {
                Item item;
                StringBuilder stringBuilder = new StringBuilder();
                if (this.filters[this.filterIndex] != Filter.All) {
                    stringBuilder.append("Filter: ").append(this.filters[this.filterIndex].name());
                    stringBuilder.append("\n\n");
                }
                if (this.buttons.size() > 0 && (item = (Item)this.getSelectedButton().data) != null) {
                    StaticView.printItem(stringBuilder, item);
                }
                this.rightText = stringBuilder.toString();
                break;
            }
        }
    }

    @Override
    public void updateScene() {
        this.scene.portrait = "inventory";
        this.scene.portraitTitle = "Inventory";
        super.setScene(this.scene);
    }

    private static enum Action {
        Use,
        Equip,
        Drop,
        DropAll,
        Read,
        Restack,
        SortByType;

    }

    private static enum Filter {
        All,
        Document,
        Equip,
        Quest,
        Trade,
        Use,
        Unidentified;

    }
}

