/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.Hexen;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.ui.Button;
import de.slashbinbash.hexen.view.StaticView;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SaveGameHandler
extends HandlerBase {
    private static final int Select = 0;
    private static final int Save = 1;
    private static final int Load = 2;
    private static final int ShowMessage = 3;
    private static final int NUM_SLOTS = 10;

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        block21: {
            block22: {
                block20: {
                    if (this.state != 0) break block20;
                    block1 : switch (commandEvent) {
                        case CONFIRM: {
                            switch (this.buttonIndex) {
                                case 0: {
                                    this.pushState(1);
                                    break block1;
                                }
                                case 1: {
                                    this.pushState(2);
                                }
                            }
                            break;
                        }
                        case CANCEL: {
                            this.popState();
                            break;
                        }
                    }
                    break block21;
                }
                if (this.state != 1 && this.state != 2) break block22;
                switch (commandEvent) {
                    case CONFIRM: {
                        File file = new File(Factory.SAVES_PATH + "save" + this.buttonIndex + ".xml");
                        System.out.println(this.state + " " + file.getPath());
                        switch (this.state) {
                            case 1: {
                                Hexen.game.saveGame(file);
                                break;
                            }
                            case 2: {
                                if (file.exists()) {
                                    try {
                                        Hexen.game.loadGame(file);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        System.exit(-1);
                                    }
                                    break;
                                }
                                break block21;
                            }
                        }
                        break block21;
                    }
                    case CANCEL: {
                        this.popState();
                        break;
                    }
                }
                break block21;
            }
            if (this.state == 3) {
                super.popState();
            }
        }
    }

    @Override
    public void init() {
        this.state = 0;
        this.updateButtons();
    }

    public void initSave() {
        this.state = 1;
        this.updateButtons();
    }

    @Override
    public void updateButtons() {
        if (this.state == 0) {
            StaticView.addButton((List<Button>)this.buttons, "Save game");
            StaticView.addButton((List<Button>)this.buttons, "Load game");
        } else if (this.state == 1 || this.state == 2) {
            for (int i = 0; i < 10; ++i) {
                File file = new File(Factory.SAVES_PATH + "/save" + i + ".xml");
                Object object = "-";
                if (file.exists()) {
                    try {
                        Document document = StaticXML.loadXML(file);
                        Element element = document.getDocumentElement();
                        long l = Long.parseLong(element.getAttribute("timestamp"));
                        Date date = new Date(l * 1000L);
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                        String string = simpleDateFormat.format(date);
                        object = file.getName();
                        object = (String)object + " " + string;
                    }
                    catch (SAXException sAXException) {
                        sAXException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                super.addButton((String)object);
            }
        }
    }
}

