/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.Hexen;
import de.slashbinbash.hexen.InputMapper;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticLog;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.action.Action;
import de.slashbinbash.hexen.bestiary.Bestiary;
import de.slashbinbash.hexen.deadpool.DeadpoolSystem;
import de.slashbinbash.hexen.enums.Direction;
import de.slashbinbash.hexen.handler.IHandler;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.map.MapObject;
import de.slashbinbash.hexen.map.Tile;
import de.slashbinbash.hexen.map.TileEdge;
import de.slashbinbash.hexen.map.TileObject;
import de.slashbinbash.hexen.message.EventBus;
import de.slashbinbash.hexen.message.ISubscriber;
import de.slashbinbash.hexen.message.Message;
import de.slashbinbash.hexen.message.MessageBus;
import de.slashbinbash.hexen.model.Party;
import de.slashbinbash.hexen.model.Scene;
import de.slashbinbash.hexen.renderer.Assets;
import de.slashbinbash.hexen.renderer.Map2DGridRenderer;
import de.slashbinbash.hexen.renderer.Map3DRenderer;
import de.slashbinbash.hexen.renderer.MapIsoRenderer;
import de.slashbinbash.hexen.renderer.MapRenderer;
import de.slashbinbash.hexen.ui.Button;
import de.slashbinbash.hexen.view.SpaceView;
import de.slashbinbash.opengl.Color;
import de.slashbinbash.opengl.JoystickEvent;
import de.slashbinbash.opengl.KeyboardEvent;
import de.slashbinbash.opengl.MouseEvent;
import de.slashbinbash.opengl.math.Rect2f;
import de.slashbinbash.opengl.renderer.Draw2D;
import de.slashbinbash.util.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SpaceHandler
implements IHandler,
ISubscriber {
    private static final char CHAR_EAST = '\u0010';
    private static final char CHAR_WEST = '\u0011';
    private static final char CHAR_NORTH = '\u001e';
    private static final char CHAR_SOUTH = '\u001f';
    private static final int NO_SELECTION = -1;
    public Scene scene = new Scene();
    public List<Button> options = new ArrayList<Button>(0);
    public List<Button> buttons = new ArrayList<Button>(0);
    public int selectedButtonIndex = -1;
    public String text = null;
    private String textSpace = null;
    private String textHoverOption = null;
    public boolean hideMap = false;
    public boolean restrictView = false;
    public boolean draw2dMap = false;
    private LinkedList<String> showDescriptionList = new LinkedList();
    public InputMode inputMode = InputMode.Default;

    public SpaceHandler() {
        MessageBus.subscribe(this);
        this.createButtons();
    }

    private void addEdge(TileEdge tileEdge, Direction direction) {
        if (tileEdge == null || tileEdge.object == null) {
            return;
        }
        if (!tileEdge.object.visible) {
            return;
        }
        TileObject tileObject = tileEdge.object;
        Button button = new Button();
        this.setTex(button, tileObject.type);
        button.label = this.getChar(direction) + " " + tileObject.label;
        button.command = CommandEvent.OBJECT_ACTION;
        button.data = tileObject;
        button.colorBackground = Color.GREY;
        this.options.add(button);
    }

    private void alignButtonsToRect(List<Button> list, Rect2f rect2f) {
        float f = 192.0f;
        float f2 = 16.0f;
        float f3 = rect2f.x;
        float f4 = rect2f.bottom() - (float)list.size() * f2;
        for (int i = 0; i < list.size(); ++i) {
            list.get((int)i).rect = new Rect2f(f3, f4 + f2 * (float)i, f, f2);
        }
    }

    private Direction ccwDir(Direction direction) {
        switch (direction) {
            case EAST: {
                return Direction.NORTH;
            }
            case NORTH: {
                return Direction.WEST;
            }
            case SOUTH: {
                return Direction.EAST;
            }
            case WEST: {
                return Direction.SOUTH;
            }
        }
        return direction;
    }

    public void clear() {
        this.selectedButtonIndex = -1;
        this.options.clear();
        this.buttons.clear();
        this.text = null;
    }

    private void createButtons() {
        Button button = new Button();
        button.command = CommandEvent.INVENTORY;
        button.label = "Inventory";
        button.setTexture(Assets.button32, 64, 32, 32, 32);
        this.buttons.add(button);
        Button button2 = new Button();
        button2.command = CommandEvent.PARTY;
        button2.label = "Party";
        button2.setTexture(Assets.button32, 0, 32, 32, 32);
        this.buttons.add(button2);
        Button button3 = new Button();
        button3.command = CommandEvent.QUESTS;
        button3.label = "Quest";
        button3.setTexture(Assets.button32, 32, 32, 32, 32);
        this.buttons.add(button3);
        Button button4 = new Button();
        button4.command = CommandEvent.REST;
        button4.label = "Rest";
        button4.setTexture(Assets.button32, 96, 32, 32, 32);
        this.buttons.add(button4);
        Button button5 = new Button();
        button5.command = CommandEvent.SAVE_LOAD_GAME;
        button5.label = "Save";
        button5.setTexture(Assets.button32, 128, 32, 32, 32);
        this.buttons.add(button5);
        float f = SpaceView.menuRect.x;
        float f2 = SpaceView.menuRect.y;
        int n = 0;
        for (int i = 0; i < 1; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (n < this.buttons.size()) {
                    Button button6 = this.buttons.get(n);
                    button6.rect = new Rect2f(f + (float)(j * 32), f2 + (float)(i * 32), 32.0f, 32.0f);
                }
                ++n;
            }
        }
        for (Button button7 : this.buttons) {
            button7.colorBackground = Color.GREY;
            button7.colorSelected = Color.WHITE;
        }
    }

    private Direction cwDir(Direction direction) {
        switch (direction) {
            case EAST: {
                return Direction.SOUTH;
            }
            case NORTH: {
                return Direction.EAST;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.NORTH;
            }
        }
        return direction;
    }

    @Override
    public void draw(Draw2D draw2D) {
        SpaceView.draw(draw2D, this);
    }

    private char getChar(Direction direction) {
        switch (direction) {
            case EAST: {
                return '\u0010';
            }
            case NORTH: {
                return '\u001e';
            }
            case SOUTH: {
                return '\u001f';
            }
            case WEST: {
                return '\u0011';
            }
        }
        return '?';
    }

    public Button getSelected(List<Button> list) {
        for (Button button : list) {
            if (!button.selected) continue;
            return button;
        }
        return null;
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        Object object2;
        RPG rPG = RPG.getInstance();
        Party party = rPG.party;
        Direction direction = null;
        switch (commandEvent) {
            case BESTIARY: {
                Hexen.game.handler.pushBestiaryHandler(new Bestiary());
                break;
            }
            case DEADPOOL: {
                Hexen.game.handler.pushDeadpoolHandler();
                break;
            }
            case INVENTORY: {
                Hexen.game.handler.pushInventoryHandler();
                break;
            }
            case PARTY: {
                Hexen.game.handler.pushPartyHandler();
                break;
            }
            case QUESTS: {
                Hexen.game.handler.pushQuestHandler();
                break;
            }
            case REST: {
                Hexen.game.handler.pushRestHandler();
                break;
            }
            case SAVE_LOAD_GAME: {
                Hexen.game.handler.pushSaveGameHandler();
                break;
            }
            case QUICKSAVE: {
                Hexen.game.quickSave();
                EventBus.QuickSaved();
                break;
            }
            case QUICKLOAD: {
                Hexen.game.quickLoad();
                EventBus.QuickLoad();
                break;
            }
            case OBJECT_ACTION: {
                if (!(object instanceof MapObject)) break;
                object2 = (MapObject)object;
                if (object2.actions == null) break;
                for (Object object3 : object2.actions) {
                    ((Action)object3).perform(object);
                }
                break;
            }
            case MOVE_EAST: {
                direction = Direction.EAST;
                party.direction = Direction.EAST;
                break;
            }
            case MOVE_NORTH: {
                direction = Direction.NORTH;
                party.direction = Direction.NORTH;
                break;
            }
            case MOVE_SOUTH: {
                direction = Direction.SOUTH;
                party.direction = Direction.SOUTH;
                break;
            }
            case MOVE_WEST: {
                direction = Direction.WEST;
                party.direction = Direction.WEST;
                break;
            }
            default: {
                assert (false) : "Unknown command: " + String.valueOf((Object)commandEvent);
                break;
            }
        }
        if (direction != null && (object2 = StaticRPG.move(party, direction)) == StaticRPG.Result.PATH_BLOCKED) {
            Object object3;
            Tile tile = party.getLocation().getTile();
            object3 = tile.getEdge(direction);
            switch (((TileEdge)object3).type) {
                case 1: {
                    EventBus.RunAgainstWall();
                    break;
                }
                case 3: {
                    EventBus.DoorLocked();
                    break;
                }
            }
        }
    }

    @Override
    public void handleJoystick(JoystickEvent joystickEvent) {
        Object object;
        Object object2;
        if (!joystickEvent.down) {
            return;
        }
        if (this.inputMode == InputMode.Default && this.draw2dMap) {
            object2 = MapRenderer.getInstance();
            Map2DGridRenderer map2DGridRenderer = Map2DGridRenderer.getInstance();
            object = Map3DRenderer.getInstance();
            MapIsoRenderer mapIsoRenderer = MapIsoRenderer.getInstance();
            RPG rPG = RPG.getInstance();
            Party party = rPG.party;
            Direction direction = party.direction;
            switch (joystickEvent.button) {
                case 11: {
                    StaticRPG.move(party, direction);
                    return;
                }
                case 4: {
                    StaticRPG.move(party, this.ccwDir(direction));
                    return;
                }
                case 5: {
                    StaticRPG.move(party, this.cwDir(direction));
                    return;
                }
                case 13: {
                    StaticRPG.move(party, this.cwDir(this.cwDir(direction)));
                    return;
                }
                case 14: {
                    party.direction = this.ccwDir(direction);
                    ((MapRenderer)object2).update(party.getLocation());
                    mapIsoRenderer.update(party.getLocation());
                    map2DGridRenderer.update(party.getLocation(), party.direction);
                    ((Map3DRenderer)object).rotator += 90.0f;
                    return;
                }
                case 12: {
                    party.direction = this.cwDir(direction);
                    ((MapRenderer)object2).update(party.getLocation());
                    mapIsoRenderer.update(party.getLocation());
                    map2DGridRenderer.update(party.getLocation(), party.direction);
                    ((Map3DRenderer)object).rotator -= 90.0f;
                    return;
                }
            }
        }
        if ((object2 = InputMapper.translate(joystickEvent, this)) == null) {
            return;
        }
        int n = InputMapper.getOptionIndex((CommandEvent)((Object)object2));
        if (this.inputMode == InputMode.Default) {
            if (n == -1) {
                switch (1.$SwitchMap$de$slashbinbash$hexen$CommandEvent[((Enum)object2).ordinal()]) {
                    case 15: {
                        this.inputMode = InputMode.ButtonSelection;
                        this.selectFirst(this.buttons);
                        break;
                    }
                    default: {
                        this.handleCommand((CommandEvent)((Object)object2), null);
                        break;
                    }
                }
            } else {
                if (n >= this.options.size()) {
                    return;
                }
                if (this.options.size() == 1) {
                    object = this.options.get(n);
                    this.handleCommand(((Button)object).command, ((Button)object).data);
                } else {
                    this.inputMode = InputMode.OptionSelection;
                    this.selectFirst(this.options);
                    this.updateText(this.options);
                }
            }
        } else if (this.inputMode == InputMode.ButtonSelection) {
            switch (1.$SwitchMap$de$slashbinbash$hexen$CommandEvent[((Enum)object2).ordinal()]) {
                case 16: {
                    this.selectNext(this.buttons);
                    break;
                }
                case 17: {
                    this.selectPrev(this.buttons);
                    break;
                }
                case 18: {
                    object = this.getSelected(this.buttons);
                    this.handleCommand(((Button)object).command, ((Button)object).data);
                    break;
                }
                case 19: {
                    this.inputMode = InputMode.Default;
                    this.unselect(this.buttons);
                    break;
                }
            }
        } else if (this.inputMode == InputMode.OptionSelection) {
            switch (1.$SwitchMap$de$slashbinbash$hexen$CommandEvent[((Enum)object2).ordinal()]) {
                case 16: {
                    this.selectNext(this.options);
                    this.updateText(this.options);
                    break;
                }
                case 17: {
                    this.selectPrev(this.options);
                    this.updateText(this.options);
                    break;
                }
                case 18: {
                    object = this.getSelected(this.options);
                    this.inputMode = InputMode.Default;
                    this.unselect(this.options);
                    this.updateText(this.options);
                    this.handleCommand(((Button)object).command, ((Button)object).data);
                    break;
                }
                case 19: {
                    this.inputMode = InputMode.Default;
                    this.unselect(this.options);
                    this.updateText(this.options);
                    break;
                }
            }
        }
    }

    @Override
    public void handleKeyboard(KeyboardEvent keyboardEvent) {
        Object object;
        Object object2;
        if (this.inputMode != InputMode.Default) {
            return;
        }
        if (!keyboardEvent.down) {
            return;
        }
        if (keyboardEvent.down) {
            object2 = Map2DGridRenderer.getInstance();
            Map3DRenderer map3DRenderer = Map3DRenderer.getInstance();
            object = MapRenderer.getInstance();
            MapIsoRenderer mapIsoRenderer = MapIsoRenderer.getInstance();
            RPG rPG = RPG.getInstance();
            Party party = rPG.party;
            Direction direction = party.direction;
            switch (keyboardEvent.key) {
                case 258: {
                    boolean bl = this.draw2dMap = !this.draw2dMap;
                    if (this.draw2dMap) {
                        ((Map2DGridRenderer)object2).update(party.getLocation(), direction);
                    }
                    return;
                }
                case 328: {
                    StaticRPG.move(party, direction);
                    return;
                }
                case 324: {
                    StaticRPG.move(party, this.ccwDir(direction));
                    return;
                }
                case 326: {
                    StaticRPG.move(party, this.cwDir(direction));
                    return;
                }
                case 322: {
                    StaticRPG.move(party, this.cwDir(this.cwDir(direction)));
                    return;
                }
                case 327: {
                    party.direction = this.ccwDir(direction);
                    ((MapRenderer)object).update(party.getLocation());
                    mapIsoRenderer.update(party.getLocation());
                    ((Map2DGridRenderer)object2).update(party.getLocation(), party.direction);
                    map3DRenderer.rotator += 90.0f;
                    return;
                }
                case 329: {
                    party.direction = this.cwDir(direction);
                    ((MapRenderer)object).update(party.getLocation());
                    mapIsoRenderer.update(party.getLocation());
                    ((Map2DGridRenderer)object2).update(party.getLocation(), party.direction);
                    map3DRenderer.rotator -= 90.0f;
                    return;
                }
            }
        }
        if ((object2 = InputMapper.translate(keyboardEvent, this)) == null) {
            return;
        }
        int n = InputMapper.getOptionIndex((CommandEvent)((Object)object2));
        if (n == -1) {
            this.handleCommand((CommandEvent)((Object)object2), null);
        } else {
            if (n >= this.options.size()) {
                return;
            }
            object = this.options.get(n);
            this.handleCommand(((Button)object).command, ((Button)object).data);
        }
    }

    @Override
    public void handleMouse(MouseEvent mouseEvent) {
        if (this.inputMode != InputMode.Default) {
            return;
        }
        if (!mouseEvent.down) {
            for (int i = 0; i < this.options.size(); ++i) {
                Object object;
                Button button = this.options.get(i);
                if (!button.rect.contains(mouseEvent.x, mouseEvent.y)) continue;
                if (i != this.selectedButtonIndex && (object = button.data) instanceof TileObject) {
                    TileObject tileObject = (TileObject)object;
                    if (tileObject.description != null && !tileObject.description.isEmpty()) {
                        this.text = this.textHoverOption = this.wrap(tileObject.description);
                    }
                }
                this.selectedButtonIndex = i;
                return;
            }
            this.text = this.textSpace;
            this.selectedButtonIndex = -1;
            return;
        }
        if (SpaceView.mapRect.contains(mouseEvent.x, mouseEvent.y)) {
            Iterator<Button> iterator = SpaceView.mapRect;
            int n = (int)((mouseEvent.x - ((Rect2f)((Object)iterator)).x) / 32.0f);
            int n2 = (int)((mouseEvent.y - ((Rect2f)((Object)iterator)).y) / 32.0f);
            if (n == 3 && n2 == 2) {
                this.handleCommand(CommandEvent.MOVE_NORTH, null);
            }
            if (n == 4 && n2 == 3) {
                this.handleCommand(CommandEvent.MOVE_EAST, null);
            }
            if (n == 2 && n2 == 3) {
                this.handleCommand(CommandEvent.MOVE_WEST, null);
            }
            if (n == 3 && n2 == 4) {
                this.handleCommand(CommandEvent.MOVE_SOUTH, null);
            }
        }
        for (Button button : this.options) {
            if (!button.rect.contains(mouseEvent.x, mouseEvent.y)) continue;
            CommandEvent commandEvent = null;
            if (mouseEvent.button == 0) {
                commandEvent = button.command;
            }
            if (commandEvent != null) {
                this.handleCommand(commandEvent, button.data);
            }
            return;
        }
        for (Button button : this.buttons) {
            if (!button.rect.contains(mouseEvent.x, mouseEvent.y)) continue;
            this.handleCommand(button.command, null);
        }
    }

    @Override
    public void notify(Message message, Object object) {
        MapRenderer mapRenderer = MapRenderer.getInstance();
        switch (message) {
            case SHOW_DESCRIPTION: {
                this.showDescriptionList.add((String)object);
                break;
            }
            case SPACE_ON_LOAD: 
            case SPACE_ON_ENTER: {
                this.update((Location)object);
                break;
            }
            case UPDATE_MAP: {
                RPG rPG = RPG.getInstance();
                mapRenderer.update(rPG.party.getLocation());
                MapIsoRenderer.getInstance().update(rPG.party.getLocation());
                break;
            }
        }
    }

    @Override
    public boolean requestedClose() {
        return false;
    }

    @Override
    public boolean requestedPop() {
        return false;
    }

    private void updateText(List<Button> list) {
        Object object;
        Button button = this.getSelected(this.options);
        if (button != null && button.data != null && (object = button.data) instanceof TileObject) {
            TileObject tileObject = (TileObject)object;
            if (tileObject.description != null && !tileObject.description.isEmpty()) {
                this.text = this.textHoverOption = this.wrap(tileObject.description);
                return;
            }
        }
        this.text = this.textSpace;
    }

    private void selectFirst(List<Button> list) {
        this.selectedButtonIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            list.get((int)i).selected = i == this.selectedButtonIndex;
        }
    }

    private void selectNext(List<Button> list) {
        ++this.selectedButtonIndex;
        if (this.selectedButtonIndex >= list.size()) {
            this.selectedButtonIndex = 0;
        }
        for (int i = 0; i < list.size(); ++i) {
            list.get((int)i).selected = i == this.selectedButtonIndex;
        }
    }

    private void selectPrev(List<Button> list) {
        --this.selectedButtonIndex;
        if (this.selectedButtonIndex < 0) {
            this.selectedButtonIndex = list.size() - 1;
        }
        for (int i = 0; i < list.size(); ++i) {
            list.get((int)i).selected = i == this.selectedButtonIndex;
        }
    }

    private void setTex(Button button, TileObject.Type type) {
        int n = 0;
        int n2 = 0;
        switch (type) {
            case Path: {
                n = 1;
                n2 = 0;
                break;
            }
            case Item: {
                n = 2;
                n2 = 0;
                break;
            }
            case Creature: {
                n = 3;
                n2 = 0;
            }
        }
        button.setTexture(Assets.button32, n * 32, n2 * 32, 32, 32);
    }

    private void unselect(List<Button> list) {
        this.selectedButtonIndex = -1;
        for (Button button : list) {
            button.selected = false;
        }
    }

    @Override
    public void update() {
        this.updateScene();
    }

    private void update(Location location) {
        MapRenderer mapRenderer = MapRenderer.getInstance();
        this.updateScene();
        SpaceView.update(this);
        mapRenderer.update(location);
        MapIsoRenderer.getInstance().update(location);
        Map3DRenderer.getInstance().location = location;
        this.updateTextbox(location.getTile());
        this.updateOptions(location.getTile());
        this.hideMap = location.getTile().type == 2;
        this.alignButtonsToRect(this.options, SpaceView.textRect);
        DeadpoolSystem deadpoolSystem = RPG.getInstance().deadpoolSystem;
        int n = deadpoolSystem.count(location.mapId, location.level, location.x, location.y);
        if (n == 1) {
            StaticLog.log("You find %d party member.", n);
        } else if (n > 1) {
            StaticLog.log("You find %d party members.", n);
        }
    }

    public void updateMap() {
        RPG rPG = RPG.getInstance();
        MapRenderer.getInstance().update(rPG.party.getLocation());
        MapIsoRenderer.getInstance().update(rPG.party.getLocation());
    }

    public void updateOptions(Tile tile) {
        this.selectedButtonIndex = -1;
        this.options.clear();
        this.addEdge(tile.edgeNorth, Direction.NORTH);
        this.addEdge(tile.edgeEast, Direction.EAST);
        this.addEdge(tile.edgeSouth, Direction.SOUTH);
        this.addEdge(tile.edgeWest, Direction.WEST);
        for (TileObject tileObject : tile.objects) {
            if (!tileObject.visible) continue;
            Button button = new Button();
            this.setTex(button, tileObject.type);
            button.label = tileObject.label;
            if (tileObject.direction != null) {
                button.label = this.getChar(tileObject.direction) + " " + button.label;
            }
            if (tileObject.description != null) {
                button.label = button.label + " \u00f0";
            }
            button.data = tileObject;
            button.command = CommandEvent.OBJECT_ACTION;
            button.colorBackground = Color.GREY;
            this.options.add(button);
        }
        this.alignButtonsToRect(this.options, SpaceView.textRect);
    }

    private void updateScene() {
        this.scene.set(RPG.getInstance().party.getLocation().getScene());
        DeadpoolSystem deadpoolSystem = RPG.getInstance().deadpoolSystem;
        Location location = RPG.getInstance().party.getLocation();
        int n = deadpoolSystem.count(location.mapId, location.level, location.x, location.y);
        if (n > 0) {
            this.scene.portrait = "grimreaper";
            this.scene.portraitTitle = "Grim Reaper";
        }
        MessageBus.push(Message.SCENE_CHANGED, this.scene);
    }

    public void updateTextbox(Tile tile) {
        StringBuffer stringBuffer = new StringBuffer();
        if (tile.description == null || tile.description.isEmpty()) {
            this.textSpace = "";
            this.text = "";
        } else {
            stringBuffer.append(tile.description);
        }
        for (TileObject object : tile.objects) {
            if (!object.visible || object.description == null || object.description.isEmpty()) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n\n");
            }
            stringBuffer.append(object.description);
        }
        for (String string : this.showDescriptionList) {
            stringBuffer.append(string).append("\n");
        }
        this.showDescriptionList.clear();
        this.text = this.textSpace = this.wrap(stringBuffer.toString());
    }

    private String wrap(String string) {
        int n = (int)SpaceView.textRect.width / 8;
        return Strings.wwrap(string, n);
    }

    public static enum InputMode {
        Default,
        OptionSelection,
        ButtonSelection;

    }

    public static enum ItemAction {
        EXAMINE,
        LOOK_AT,
        unknown;

    }
}

