/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.Documentation;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.factory.CreatureFactory;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.guild.StaticTrain;
import de.slashbinbash.hexen.guild.Train;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.message.EventBus;
import de.slashbinbash.hexen.message.Message;
import de.slashbinbash.hexen.message.MessageBus;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.CombatAction;
import de.slashbinbash.hexen.model.CombatActions;
import de.slashbinbash.hexen.model.Inventory;
import de.slashbinbash.hexen.model.Party;
import de.slashbinbash.hexen.model.Trait;
import de.slashbinbash.hexen.model.Traits;
import de.slashbinbash.hexen.ui.Button;
import de.slashbinbash.hexen.view.StaticView;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TrainHandler
extends HandlerBase {
    private static final int PICK_OPT = 0;
    private static final int PICK_ABILITIES = 1;
    private static final int PICK_COMBAT_ACTION = 2;
    private static final int PICK_NAME = 3;
    private static final int CONFIRM = 4;
    private static final int PICK_TRAINING = 5;
    private static final int PICK_BUY_ABILITIES = 6;
    private static final int PICK_BUY_COMBATACTIONS = 7;
    private static final int PICK_PORTRAIT = 8;
    private static final int PICK_TRAIT = 9;
    private static final int SHOW_MESSAGE = 10;
    private Train train = null;
    private ClassCreature creature = null;
    private int abilityPointsMax = 0;
    private int abilityPoints = 0;
    private int traitPointsMax = 0;
    private int traitPoints = 0;
    private List<Trait> defaultTraits = new ArrayList<Trait>();
    private List<CombatAction> creatureActions = new ArrayList<CombatAction>();

    public TrainHandler(HandlerBase handlerBase) {
        super.setScene(handlerBase.scene);
        this.defaultTraits.add(Trait.valueOf("humanoid"));
    }

    private Train.Data.AbilityEntry getSelectedAbility() {
        return (Train.Data.AbilityEntry)super.getSelectedButton().data;
    }

    private CombatAction getSelectedCombatAction() {
        return (CombatAction)super.getSelectedButton().data;
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 4: {
                this.handleConfirmSelection(commandEvent, object);
                break;
            }
            case 6: {
                this.handlePickBuyAbilities(commandEvent, object);
                break;
            }
            case 7: {
                this.handlePickBuyCombatAction(commandEvent, object);
                break;
            }
            case 2: {
                this.handlePickCombatAction(commandEvent, object);
                break;
            }
            case 1: {
                this.handlePickAbilities(commandEvent, object);
                break;
            }
            case 3: {
                this.handlePickName(commandEvent, object);
                break;
            }
            case 0: {
                this.handlePickOpt(commandEvent, object);
                break;
            }
            case 5: {
                this.handlePickTraining(commandEvent, object);
                break;
            }
            case 9: {
                this.handlePickTrait(commandEvent, object);
                break;
            }
            case 8: {
                this.handlePickPortrait(commandEvent, object);
                break;
            }
            case 10: {
                if (commandEvent != CommandEvent.CONFIRM && commandEvent != CommandEvent.CANCEL) break;
                super.popState();
                break;
            }
        }
    }

    private void handleConfirmSelection(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                Party party = RPG.getInstance().party;
                this.creature.hitPoints = this.creature.calcMaxHitPoints();
                this.creature.actionPoints = this.creature.calcMaxActionPoints();
                this.creature.timeStarted = RPG.getInstance().timeSeconds;
                party.addMember(this.creature);
                this.resetState();
                EventBus.JoinedParty(this.creature);
                break;
            }
            case CANCEL: {
                this.popState();
                super.setMode(HandlerBase.Mode.Input);
                break;
            }
        }
    }

    private int calcTotalAbilityPoints() {
        int n = 0;
        for (Train.Data.AbilityEntry abilityEntry : this.train._data.abilities) {
            int n2 = this.creature.getAbilityScore(abilityEntry.ability);
            for (int i = 0; i <= n2; ++i) {
                n += StaticTrain.calcCost(abilityEntry.ability.skillLevel, i);
            }
        }
        return n;
    }

    private void resetAbilityPoints() {
        this.abilityPoints = this.abilityPointsMax;
        for (Train.Data.AbilityEntry abilityEntry : this.train._data.abilities) {
            this.creature.setAbilityScore(abilityEntry.ability, 0);
        }
    }

    private void handlePickAbilities(CommandEvent commandEvent, Object object) {
        block0 : switch (commandEvent) {
            case CONFIRM: {
                Object object2 = super.getSelectedButton().data;
                if (object2 instanceof Train.Data.AbilityEntry) {
                    Train.Data.AbilityEntry abilityEntry = (Train.Data.AbilityEntry)object2;
                    Ability ability = abilityEntry.ability;
                    int n = this.creature.getAbilityScore(abilityEntry.ability);
                    int n2 = StaticTrain.calcCost(abilityEntry.ability.skillLevel, n + 1);
                    if (n >= abilityEntry.max || n2 > this.abilityPoints) break;
                    this.creature.setAbilityScore(ability, n + 1);
                    this.abilityPoints = this.abilityPointsMax - this.calcTotalAbilityPoints();
                    break;
                }
                if (!(object2 instanceof ActionEnum)) break;
                ActionEnum actionEnum = (ActionEnum)((Object)object2);
                switch (actionEnum.ordinal()) {
                    case 2: {
                        this.pushState(2);
                        break block0;
                    }
                    case 3: {
                        this.resetAbilityPoints();
                        break block0;
                    }
                    case 4: {
                        this.buttonIndex = 0;
                        this.popState();
                        break block0;
                    }
                }
                break;
            }
            case CANCEL: {
                Object object3 = super.getSelectedButton().data;
                if (!(object3 instanceof Train.Data.AbilityEntry)) break;
                Train.Data.AbilityEntry abilityEntry = (Train.Data.AbilityEntry)object3;
                if (this.abilityPoints >= this.abilityPointsMax) break;
                int n = this.creature.getAbilityScore(abilityEntry.ability);
                if (n > 0) {
                    this.creature.setAbilityScore(abilityEntry.ability, n - 1);
                }
                this.abilityPoints = this.abilityPointsMax - this.calcTotalAbilityPoints();
                break;
            }
        }
    }

    private void handlePickBuyAbilities(CommandEvent commandEvent, Object object) {
        Inventory inventory = RPG.getInstance().party.inventory;
        switch (commandEvent) {
            case CONFIRM: {
                Train.Data.AbilityEntry abilityEntry = this.getSelectedAbility();
                if (inventory.getCurrency() <= 0) break;
                Ability ability = abilityEntry.ability;
                int n = this.creature.getAbilityScore(abilityEntry.ability);
                int n2 = StaticTrain.calcCost(abilityEntry.ability.skillLevel, n + 1);
                if (n >= abilityEntry.max || inventory.getCurrency() < n2) break;
                inventory.removeCurrency(n2);
                this.creature.setAbilityScore(ability, n + 1);
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    private void handlePickBuyCombatAction(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                Button button = super.getSelectedButton();
                if (!button.enabled || button.data == null) break;
                CombatAction combatAction = (CombatAction)button.data;
                if (this.creature.combatActions.contains(combatAction)) {
                    this.creature.combatActions.remove(combatAction);
                    break;
                }
                if (!this.creature.canAdd(combatAction)) break;
                this.creature.combatActions.add(combatAction);
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
            case SHOW_DOCUMENTATION: {
                CombatAction combatAction = (CombatAction)this.getSelectedButton().data;
                Documentation.showCombatAction(combatAction);
                break;
            }
        }
    }

    private void handlePickTrait(CommandEvent commandEvent, Object object) {
        block0 : switch (commandEvent) {
            case CONFIRM: {
                Object object2 = super.getSelectedButton().data;
                if (object2 instanceof Trait) {
                    Trait trait = (Trait)object2;
                    if (this.traitPoints <= 0 || this.creature.hasTrait(trait)) break;
                    this.creature.traits.add(trait);
                    --this.traitPoints;
                    break;
                }
                if (!(object2 instanceof ActionEnum)) break;
                ActionEnum actionEnum = (ActionEnum)((Object)object2);
                switch (actionEnum.ordinal()) {
                    case 2: {
                        this.pushState(8);
                        break block0;
                    }
                    case 3: {
                        this.creature.traits.clear();
                        this.creature.traits.addAll(this.defaultTraits);
                        this.traitPoints = this.traitPointsMax;
                        break block0;
                    }
                    case 4: {
                        this.buttonIndex = 0;
                        this.popState();
                        break block0;
                    }
                }
                break;
            }
            case CANCEL: {
                Trait trait;
                Object object3 = super.getSelectedButton().data;
                if (!(object3 instanceof Trait) || !this.creature.hasTrait(trait = (Trait)object3)) break;
                this.creature.traits.remove(trait);
                ++this.traitPoints;
                break;
            }
            case SHOW_DOCUMENTATION: {
                break;
            }
        }
    }

    private void handlePickCombatAction(CommandEvent commandEvent, Object object) {
        block0 : switch (commandEvent) {
            case CONFIRM: {
                Button button = super.getSelectedButton();
                Object object2 = button.data;
                if (object2 instanceof CombatAction) {
                    CombatAction combatAction = (CombatAction)object2;
                    if (!button.enabled || !this.creature.canAdd(combatAction)) break;
                    this.creature.combatActions.add(combatAction);
                    break;
                }
                object2 = button.data;
                if (!(object2 instanceof ActionEnum)) break;
                ActionEnum actionEnum = (ActionEnum)((Object)object2);
                switch (actionEnum.ordinal()) {
                    case 2: {
                        object2 = this.train._data.combatActions;
                        Iterator<CombatAction> iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            boolean bl;
                            CombatAction combatAction = iterator.next();
                            boolean bl2 = bl = combatAction.getRequirements() != null ? combatAction.getRequirements().checkAll(this.creature) : true;
                            boolean bl3 = this.creature.combatActions.contains(combatAction);
                            if (!bl3 || bl) continue;
                            this.creature.combatActions.remove(combatAction);
                        }
                        this.pushState(9);
                        break block0;
                    }
                    case 3: {
                        this.creature.combatActions.clear();
                        break block0;
                    }
                    case 4: {
                        this.buttonIndex = 0;
                        this.popState();
                        break block0;
                    }
                }
                break;
            }
            case CANCEL: {
                CombatAction combatAction;
                Object object3 = super.getSelectedButton().data;
                if (!(object3 instanceof CombatAction) || !this.creature.combatActions.contains(combatAction = (CombatAction)object3)) break;
                this.creature.combatActions.remove(combatAction);
                break;
            }
            case SHOW_DOCUMENTATION: {
                CombatAction combatAction = (CombatAction)this.getSelectedButton().data;
                Documentation.showCombatAction(combatAction);
                break;
            }
        }
    }

    private void handlePickName(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                if (super.getInputLength() <= 0) break;
                this.creature.name = super.getInput();
                super.setMode(HandlerBase.Mode.Default);
                this.pushState(4);
                break;
            }
            case CANCEL: {
                if (super.getInputLength() > 0) {
                    super.resetInput();
                    break;
                }
                this.popState();
                super.setMode(HandlerBase.Mode.Default);
                break;
            }
        }
    }

    private void handlePickOpt(CommandEvent commandEvent, Object object) {
        block0 : switch (commandEvent) {
            case CONFIRM: {
                Button button = (Button)this.buttons.get(this.buttonIndex);
                Action action = (Action)button.data;
                switch (action.action.ordinal()) {
                    case 0: {
                        this.creature = action.creature;
                        this.creatureActions.clear();
                        for (CombatAction combatAction : this.creature.combatActions) {
                            if (this.train._data.combatActions.contains(combatAction)) continue;
                            this.creatureActions.add(combatAction);
                        }
                        this.pushState(5);
                        break block0;
                    }
                    case 1: {
                        if (RPG.getInstance().party.isFull()) {
                            this.showMessage("Party is full.");
                            break block0;
                        }
                        this.abilityPoints = 250;
                        this.abilityPointsMax = 250;
                        this.traitPoints = 1;
                        this.traitPointsMax = 1;
                        this.initNewCreature();
                        this.pushState(1);
                        break block0;
                    }
                }
                break;
            }
            case CANCEL: {
                MessageBus.push(Message.STATE_POP, null);
                break;
            }
        }
    }

    private void handlePickPortrait(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                String string;
                this.creature.portrait = string = (String)super.getSelectedButton().data;
                super.pushState(3);
                super.setMode(HandlerBase.Mode.Input);
                break;
            }
            case CANCEL: {
                this.creature.portrait = null;
                this.scene.portrait = null;
                this.scene.portraitTitle = null;
                super.popState();
                break;
            }
        }
    }

    private void handlePickTraining(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                switch (this.buttonIndex) {
                    case 0: {
                        this.pushState(6);
                        break;
                    }
                    case 1: {
                        this.pushState(7);
                    }
                }
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    public void init(Train train) {
        this.train = train;
        super.init();
    }

    private void initNewCreature() {
        this.creature = new ClassCreature();
        this.creature.job = this.train._data.job;
        this.creature.maxHitPoints = 10;
        this.creature.maxActionPoints = 10;
        this.creature.vim = 100;
        this.creature.combatActions = new CombatActions();
        this.creature.traits = new Traits();
        this.creature.traits.addAll(this.defaultTraits);
        for (Train.Data.AbilityEntry abilityEntry : this.train._data.abilities) {
            this.creature.setAbilityScore(abilityEntry.ability, 0);
        }
        this.creature.mods = CreatureFactory.createSlots("mods");
    }

    private void showMessage(String string) {
        this.leftText = string;
        this.pushState(10);
    }

    @Override
    public void updateButtons() {
        switch (this.state) {
            case 4: {
                break;
            }
            case 0: {
                Party party = RPG.getInstance().party;
                if (!party.isFull()) {
                    Action action = new Action(this);
                    action.label = "Train new recruit";
                    action.action = ActionEnum.TrainNewCreature;
                    super.addButton(action.label, action);
                }
                for (ClassCreature classCreature : party.getMembers()) {
                    Action n = new Action(this);
                    n.label = classCreature.name;
                    n.action = ActionEnum.TrainExistingCreature;
                    n.creature = classCreature;
                    super.addButton(n.label, n);
                }
                break;
            }
            case 5: {
                super.addButton("Train abilities");
                super.addButton("Train combat actions");
                break;
            }
            case 1: {
                for (Train.Data.AbilityEntry abilityEntry : this.train._data.abilities) {
                    Ability ability = abilityEntry.ability;
                    if (ability.skillLevel == null) continue;
                    int bl = this.creature.getAbilityScore(ability);
                    int bl2 = StaticTrain.calcCost(ability.skillLevel, bl + 1);
                    String string = String.format("%d/%d %-18s%6d", bl, abilityEntry.max, ability.name, bl2);
                    super.addButton(string, abilityEntry);
                }
                super.addButton("", null);
                super.addButton("Confirm", (Object)ActionEnum.Confirm);
                super.addButton("Reset", (Object)ActionEnum.Reset);
                super.addButton("Back", (Object)ActionEnum.Back);
                break;
            }
            case 2: {
                List<CombatAction> list = this.train._data.combatActions;
                for (CombatAction combatAction : list) {
                    boolean string = combatAction.getRequirements() != null ? combatAction.getRequirements().checkAll(this.creature) : true;
                    boolean string3 = this.creature.combatActions.contains(combatAction);
                    String string5 = " ";
                    string5 = !string ? (string3 ? "-" : "x") : (string3 ? "+" : " ");
                    String string6 = String.format("%s%s", string5, combatAction.getName());
                    Button button = super.addButton(string6, combatAction);
                    button.enabled = string || string3;
                }
                Button button = super.addButton("", null);
                button.enabled = false;
                super.addButton("Confirm", (Object)ActionEnum.Confirm);
                super.addButton("Reset", (Object)ActionEnum.Reset);
                super.addButton("Back", (Object)ActionEnum.Back);
                break;
            }
            case 9: {
                for (Trait trait : this.train._data.traits) {
                    boolean bl = this.creature.hasTrait(trait);
                    String i = " ";
                    i = bl ? "+" : " ";
                    String file2 = i + trait.name;
                    super.addButton(file2, trait);
                }
                super.addButton("", null);
                super.addButton("Confirm", (Object)ActionEnum.Confirm);
                super.addButton("Reset", (Object)ActionEnum.Reset);
                super.addButton("Back", (Object)ActionEnum.Back);
                break;
            }
            case 3: {
                break;
            }
            case 8: {
                File file = new File(Factory.AVATAR_PATH);
                File[] fileArray = file.listFiles();
                int n = Math.min(fileArray.length, 28);
                for (n = 0; n < n; ++n) {
                    File n3 = fileArray[n];
                    String string7 = "cc/" + n3.getName().replace(".png", "");
                    super.addButton(n3.getName(), string7);
                }
                break;
            }
            case 6: {
                for (Train.Data.AbilityEntry abilityEntry : this.train._data.abilities) {
                    Ability ability = abilityEntry.ability;
                    if (ability.skillLevel == null) continue;
                    int bl3 = this.creature.getAbilityScore(ability);
                    int bl = StaticTrain.calcCost(ability.skillLevel, bl3 + 1);
                    String string4 = String.format("%d/%d %-18s%6d", bl3, abilityEntry.max, ability.name, bl);
                    this.addButton(string4, abilityEntry);
                }
                break;
            }
            case 7: {
                String string;
                String string2;
                boolean bl;
                List<CombatAction> list = this.train._data.combatActions;
                for (CombatAction object : list) {
                    boolean combatAction = object.getRequirements() != null ? object.getRequirements().checkAll(this.creature) : true;
                    bl = this.creature.combatActions.contains(object);
                    string2 = " ";
                    string2 = bl ? "+" : (!combatAction ? "x" : " ");
                    string = String.format("%s%s", string2, object.getName());
                    Button button = super.addButton(string, object);
                    button.enabled = combatAction || bl;
                }
                if (this.creatureActions.isEmpty()) break;
                Button button = super.addButton("", null);
                button.enabled = false;
                for (CombatAction combatAction : this.creatureActions) {
                    if (this.train._data.combatActions.contains(combatAction)) continue;
                    bl = this.creature.combatActions.contains(combatAction);
                    string2 = " ";
                    string2 = bl ? "+" : " ";
                    string = String.format("%s%s", string2, combatAction.getName());
                    super.addButton(string, combatAction);
                }
                break;
            }
        }
    }

    @Override
    public void updateLeftText() {
        switch (this.state) {
            case 10: {
                break;
            }
            case 3: {
                this.leftText = "NAME";
                break;
            }
            case 4: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("NAME\n").append(this.creature.name);
                stringBuilder.append("\n\nHP ").append(this.creature.calcMaxHitPoints());
                stringBuilder.append("\nAP ").append(this.creature.calcMaxActionPoints());
                stringBuilder.append("\nVIM ").append(this.creature.calcVim());
                stringBuilder.append("\n\nABILITIES");
                for (Train.Data.AbilityEntry object : this.train._data.abilities) {
                    int n = this.creature.calcAbilityScore(object.ability);
                    if (n <= 0) continue;
                    stringBuilder.append("\n").append(n).append(" ").append(object.ability.name);
                }
                stringBuilder.append("\n\nCOMBAT ACTIONS");
                for (CombatAction combatAction : this.creature.combatActions) {
                    stringBuilder.append("\n").append(combatAction.getName());
                }
                this.leftText = stringBuilder.toString();
                break;
            }
            default: {
                this.leftText = null;
            }
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
        switch (this.state) {
            case 6: {
                Train.Data.AbilityEntry abilityEntry = this.getSelectedAbility();
                if (abilityEntry == null) break;
                Ability ability = abilityEntry.ability;
                StringBuilder stringBuilder = new StringBuilder();
                if (ability != null) {
                    stringBuilder.append("Level ").append(ability.skillLevel.toLowerCase());
                    if (ability.description != null) {
                        stringBuilder.append("\n\n").append(ability.description);
                    } else {
                        stringBuilder.append("\n\n").append("<description>");
                    }
                }
                this.rightText = stringBuilder.toString();
                break;
            }
            case 1: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Points ").append(this.abilityPoints);
                Object object = super.getSelectedButton().data;
                if (object instanceof Train.Data.AbilityEntry) {
                    Train.Data.AbilityEntry abilityEntry = (Train.Data.AbilityEntry)object;
                    if (abilityEntry.ability != null) {
                        stringBuilder.append("\n\nLevel ").append(abilityEntry.ability.skillLevel.toLowerCase());
                        if (abilityEntry.ability.description != null) {
                            stringBuilder.append("\n\n").append(abilityEntry.ability.description);
                        } else {
                            stringBuilder.append("\n\n").append("<description>");
                        }
                    }
                }
                this.rightText = stringBuilder.toString();
                break;
            }
            case 2: 
            case 7: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Slots ");
                stringBuilder.append(this.creature.combatActions.size());
                stringBuilder.append("/");
                stringBuilder.append(this.creature.maxCombatActions);
                Button button = this.getSelectedButton();
                Object object = button.data;
                if (object instanceof CombatAction) {
                    CombatAction combatAction = (CombatAction)object;
                    stringBuilder.append("\n\n");
                    if (combatAction != null) {
                        StaticView.printCombatActionFor(stringBuilder, combatAction, this.creature, true);
                    }
                }
                this.rightText = stringBuilder.toString();
                break;
            }
            case 9: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Points ").append(this.traitPoints);
                Object object = super.getSelectedButton().data;
                if (object instanceof Trait) {
                    Trait trait = (Trait)object;
                    stringBuilder.append("\n\n");
                    StaticView.printModifiers(stringBuilder, trait.modifiers);
                }
                this.rightText = stringBuilder.toString();
                break;
            }
        }
    }

    @Override
    public void updateScene() {
        switch (this.state) {
            case 8: {
                String string;
                this.scene.portrait = string = (String)super.getSelectedButton().data;
                this.scene.portraitTitle = "";
                break;
            }
            case 3: {
                this.scene.portrait = this.creature.portrait;
                this.scene.portraitTitle = "";
                break;
            }
            case 4: {
                this.scene.portrait = this.creature.portrait;
                this.scene.portraitTitle = this.creature.name;
                break;
            }
            default: {
                if (this.train._data.scene == null) break;
                super.setScene(this.train._data.scene);
            }
        }
        super.setScene(this.scene);
    }

    private static enum ActionEnum {
        TrainExistingCreature,
        TrainNewCreature,
        Confirm,
        Reset,
        Back;

    }

    private class Action {
        public String label;
        public ActionEnum action;
        public ClassCreature creature;

        private Action(TrainHandler trainHandler) {
        }
    }
}

