/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.model.Duration;
import de.slashbinbash.hexen.model.Party;
import de.slashbinbash.hexen.travel.StaticTravel;
import de.slashbinbash.hexen.travel.Travel;
import de.slashbinbash.util.Strings;

public class TravelHandler
extends HandlerBase {
    private static final int PICK_OPT = 0;
    private static final int SHOW_MESSAGE = 1;
    private Travel travel = null;
    private boolean arrived = false;

    public TravelHandler(HandlerBase handlerBase) {
        super.setScene(handlerBase.scene);
    }

    private Travel.Data.Entry getSelectedDestination() {
        return (Travel.Data.Entry)super.getSelectedButton().data;
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 0: {
                this.handlePickOpt(commandEvent, object);
                break;
            }
            case 1: {
                if (commandEvent != CommandEvent.CONFIRM && commandEvent != CommandEvent.CANCEL) break;
                if (this.arrived) {
                    super.close();
                    break;
                }
                super.popState();
                break;
            }
        }
    }

    private void handlePickOpt(CommandEvent commandEvent, Object object) {
        block0 : switch (commandEvent) {
            case CONFIRM: {
                Travel.Data.Entry entry = this.getSelectedDestination();
                StaticRPG.Result result = StaticTravel.travel(entry);
                switch (result) {
                    case OK: {
                        this.arrived = true;
                        this.showMessage("You have arrived at the new location.");
                        break block0;
                    }
                    case NOT_ENOUGH_CURRENCY: {
                        this.showMessage("Not enough currency.");
                        break block0;
                    }
                }
                this.showMessage(result.name());
                break;
            }
            case CANCEL: {
                super.popState();
                break;
            }
        }
    }

    public void init(Travel travel) {
        this.travel = travel;
        super.init();
    }

    private void showMessage(String string) {
        this.leftText = string;
        this.pushState(1);
    }

    @Override
    public void updateButtons() {
        if (this.state == 0) {
            Party party = RPG.getInstance().party;
            for (Travel.Data.Entry entry : this.travel._data.destinations) {
                if (entry.visibleChecks != null && !entry.visibleChecks.checkAll(party)) continue;
                super.addButton(entry.label, entry);
            }
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
        if (this.state == 0) {
            Travel.Data.Entry entry = this.getSelectedDestination();
            int n = StaticTravel.calcCost(entry);
            String string = String.format("Cost: %d (%d/member)\nTime: %s\n\n%s", n, entry.cost, Duration.toString(entry.timeSeconds), entry.description);
            this.rightText = Strings.wwrap(string, 24);
        }
    }

    @Override
    public void updateScene() {
        if (this.travel._data.scene != null) {
            super.setScene(this.travel._data.scene);
        }
    }
}

