/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.lua;

import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.factory.ConditionFactory;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.Condition;
import de.slashbinbash.hexen.model.Trait;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;

public class CreatureBinding {
    public static void setup(LuaTable luaTable) {
        luaTable.set("CreatureAddCondition", (LuaValue)new AddCondition());
        luaTable.set("CreatureGetAbilityScore", (LuaValue)new GetAbilityScore());
        luaTable.set("CreatureGetHP", (LuaValue)new GetHP());
        luaTable.set("CreatureGetAP", (LuaValue)new GetAP());
        luaTable.set("CreatureGetName", (LuaValue)new GetName());
        luaTable.set("CreatureHasCondition", (LuaValue)new HasCondition());
        luaTable.set("CreatureHasTrait", (LuaValue)new HasTrait());
        luaTable.set("CreatureIsImmune", (LuaValue)new IsImmune());
        luaTable.set("CreatureSetHP", (LuaValue)new SetHP());
        luaTable.set("CreatureSetAP", (LuaValue)new SetAP());
    }

    public static class AddCondition
    extends ThreeArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2, LuaValue luaValue3) {
            ClassCreature classCreature = (ClassCreature)luaValue.touserdata();
            String string = luaValue2.tojstring();
            int n = luaValue3.toint();
            Condition condition = ConditionFactory.createCondition(string, n);
            classCreature.addCondition(condition);
            return null;
        }
    }

    public static class GetAbilityScore
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            ClassCreature classCreature = (ClassCreature)luaValue.touserdata();
            String string = luaValue2.tojstring();
            int n = classCreature.calcAbilityScore(Ability.valueOf(string));
            return LuaValue.valueOf(n);
        }
    }

    public static class GetHP
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue) {
            ClassCreature classCreature = (ClassCreature)luaValue.touserdata();
            int n = classCreature.hitPoints;
            return LuaValue.valueOf(n);
        }
    }

    public static class GetAP
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue) {
            ClassCreature classCreature = (ClassCreature)luaValue.touserdata();
            int n = classCreature.actionPoints;
            return LuaValue.valueOf(n);
        }
    }

    public static class GetName
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue) {
            ClassCreature classCreature = (ClassCreature)luaValue.touserdata();
            String string = classCreature.name;
            return LuaValue.valueOf(string);
        }
    }

    public static class HasCondition
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            ClassCreature classCreature = (ClassCreature)luaValue.touserdata();
            String string = luaValue2.tojstring();
            boolean bl = classCreature.hasCondition(string);
            return LuaValue.valueOf(bl);
        }
    }

    public static class HasTrait
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            ClassCreature classCreature = (ClassCreature)luaValue.touserdata();
            String string = luaValue2.tojstring();
            Trait trait = Trait.valueOf(string);
            boolean bl = classCreature.hasTrait(trait);
            return LuaValue.valueOf(bl);
        }
    }

    public static class IsImmune
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            ClassCreature classCreature = (ClassCreature)luaValue.touserdata();
            String string = luaValue2.tojstring();
            boolean bl = classCreature.hasCondition(string);
            return LuaValue.valueOf(bl);
        }
    }

    public static class SetHP
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            int n;
            ClassCreature classCreature = (ClassCreature)luaValue.touserdata();
            classCreature.hitPoints = n = luaValue2.toint();
            return null;
        }
    }

    public static class SetAP
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            int n;
            ClassCreature classCreature = (ClassCreature)luaValue.touserdata();
            classCreature.actionPoints = n = luaValue2.toint();
            return null;
        }
    }
}

