/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.lua;

import de.slashbinbash.hexen.event.EventState;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;

public class EventBinding {
    public static void setup(LuaTable luaTable) {
        luaTable.set("EventGetInt", (LuaValue)new GetInt());
        luaTable.set("EventGetObj", (LuaValue)new GetObj());
        luaTable.set("EventGetStr", (LuaValue)new GetStr());
        luaTable.set("EventHasVar", (LuaValue)new HasVar());
        luaTable.set("EventSetInt", (LuaValue)new SetInt());
        luaTable.set("EventSetNode", (LuaValue)new SetNode());
        luaTable.set("EventSetObj", (LuaValue)new SetObj());
        luaTable.set("EventSetOptEnabled", (LuaValue)new SetOptEnabled());
        luaTable.set("EventSetOptVisible", (LuaValue)new SetOptVisible());
        luaTable.set("EventSetStr", (LuaValue)new SetStr());
        luaTable.set("EventSetText", (LuaValue)new SetText());
        luaTable.set("EventGetId", (LuaValue)new GetId());
    }

    public static class GetInt
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            EventState eventState = (EventState)luaValue.touserdata();
            int n = eventState.vars.getInt(luaValue2.tojstring());
            return LuaValue.valueOf(n);
        }
    }

    public static class GetObj
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            EventState eventState = (EventState)luaValue.touserdata();
            Object object = eventState.vars.get(luaValue2.tojstring());
            return LuaValue.userdataOf(object);
        }
    }

    public static class GetStr
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            EventState eventState = (EventState)luaValue.touserdata();
            String string = eventState.vars.getString(luaValue2.tojstring());
            return LuaValue.valueOf(string);
        }
    }

    public static class HasVar
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            EventState eventState = (EventState)luaValue.touserdata();
            String string = luaValue2.tojstring();
            boolean bl = eventState.vars.has(string);
            return LuaValue.valueOf(bl);
        }
    }

    public static class SetInt
    extends ThreeArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2, LuaValue luaValue3) {
            EventState eventState = (EventState)luaValue.touserdata();
            String string = luaValue2.tojstring();
            int n = luaValue3.toint();
            eventState.vars.set(string, n);
            return LuaValue.NIL;
        }
    }

    public static class SetNode
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            EventState eventState = (EventState)luaValue.touserdata();
            eventState.setNode(luaValue2.tojstring());
            return null;
        }
    }

    public static class SetObj
    extends ThreeArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2, LuaValue luaValue3) {
            EventState eventState = (EventState)luaValue.touserdata();
            String string = luaValue2.tojstring();
            Object object = luaValue3.touserdata();
            eventState.vars.set(string, object);
            return null;
        }
    }

    public static class SetOptEnabled
    extends ThreeArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2, LuaValue luaValue3) {
            boolean bl;
            EventState eventState = (EventState)luaValue.touserdata();
            String string = luaValue2.tojstring();
            eventState.getOption((String)string).enabled = bl = luaValue3.toboolean();
            return null;
        }
    }

    public static class SetOptVisible
    extends ThreeArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2, LuaValue luaValue3) {
            boolean bl;
            EventState eventState = (EventState)luaValue.touserdata();
            String string = luaValue2.tojstring();
            eventState.getOption((String)string).visible = bl = luaValue3.toboolean();
            return null;
        }
    }

    public static class SetStr
    extends ThreeArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2, LuaValue luaValue3) {
            EventState eventState = (EventState)luaValue.touserdata();
            String string = luaValue2.tojstring();
            String string2 = luaValue3.tojstring();
            eventState.vars.set(string, string2);
            return LuaValue.NIL;
        }
    }

    public static class SetText
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            EventState eventState = (EventState)luaValue.touserdata();
            eventState.text = luaValue2.tojstring();
            return null;
        }
    }

    public static class GetId
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue) {
            EventState eventState = (EventState)luaValue.touserdata();
            return LuaString.valueOf(eventState.nodeId);
        }
    }
}

