/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.lua;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.factory.ItemFactory;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.Party;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class InventoryBinding {
    public static void setup(LuaTable luaTable) {
        luaTable.set("InventoryAddItem", (LuaValue)new AddItem());
        luaTable.set("InventoryCountItem", (LuaValue)new CountItem());
        luaTable.set("InventoryGetGold", (LuaValue)new GetGold());
        luaTable.set("InventoryGetItemById", (LuaValue)new GetItemById());
        luaTable.set("InventoryRemoveItem", (LuaValue)new RemoveItem());
    }

    public static class AddItem
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue) {
            Item item = null;
            if (luaValue.isuserdata()) {
                item = (Item)luaValue.touserdata();
            } else if (luaValue.isstring()) {
                item = ItemFactory.createItem(luaValue.tojstring());
            }
            assert (item != null);
            RPG.getInstance().party.inventory.add(item);
            return null;
        }
    }

    public static class CountItem
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue) {
            String string = luaValue.tojstring();
            Party party = RPG.getInstance().party;
            int n = party.inventory.count(string);
            return LuaValue.valueOf(n);
        }
    }

    public static class GetGold
    extends ZeroArgFunction {
        @Override
        public LuaValue call() {
            int n = RPG.getInstance().party.inventory.getCurrency();
            return LuaValue.valueOf(n);
        }
    }

    public static class GetItemById
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue) {
            Party party = RPG.getInstance().party;
            String string = luaValue.tojstring();
            Item item = party.inventory.get(string);
            return item != null ? LuaValue.userdataOf(item) : LuaValue.NIL;
        }
    }

    public static class RemoveItem
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue) {
            RPG rPG = RPG.getInstance();
            if (luaValue.isuserdata()) {
                Item item = (Item)luaValue.touserdata();
                rPG.party.inventory.remove(item, 1);
            } else if (luaValue.isstring()) {
                String string = luaValue.tojstring();
                rPG.party.inventory.remove(string, 1);
            }
            return null;
        }
    }
}

