/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.lua;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.model.ClassCreature;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class PartyBinding {
    public static void setup(LuaTable luaTable) {
        luaTable.set("PartyGetAbilityScore", (LuaValue)new GetAbilityScore());
        luaTable.set("PartyGetMember", (LuaValue)new GetMember());
        luaTable.set("PartyMove", (LuaValue)new Move());
        luaTable.set("PartyNumMembers", (LuaValue)new NumMembers());
        luaTable.set("PartyPickRandom", (LuaValue)new PickRandom());
        luaTable.set("PartyRemoveMember", (LuaValue)new RemoveMember());
    }

    public static class GetAbilityScore
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue) {
            String string = luaValue.tojstring();
            Ability ability = Ability.valueOf(string);
            int n = RPG.getInstance().party.getAbilityScoreMax(ability);
            return LuaValue.valueOf(n);
        }
    }

    public static class GetMember
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue) {
            int n = luaValue.toint();
            ClassCreature classCreature = RPG.getInstance().party.getMember(n);
            return LuaValue.userdataOf(classCreature);
        }
    }

    public static class Move
    extends VarArgFunction {
        @Override
        public Varargs invoke(Varargs varargs) {
            String string = varargs.tojstring(1);
            int n = varargs.toint(2);
            int n2 = varargs.toint(3);
            int n3 = varargs.toint(4);
            StaticRPG.move(RPG.getInstance().party, string, n, n2, n3);
            return LuaValue.varargsOf(new LuaValue[0]);
        }
    }

    public static class NumMembers
    extends ZeroArgFunction {
        @Override
        public LuaValue call() {
            int n = RPG.getInstance().party.getMembers().size();
            return LuaValue.valueOf(n);
        }
    }

    public static class PickRandom
    extends ZeroArgFunction {
        @Override
        public LuaValue call() {
            RPG rPG = RPG.getInstance();
            ClassCreature classCreature = rPG.party.pickRandom();
            return LuaValue.userdataOf(classCreature);
        }
    }

    public static class RemoveMember
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue) {
            ClassCreature classCreature = (ClassCreature)luaValue.touserdata();
            RPG.getInstance().party.removeMember(classCreature);
            return null;
        }
    }
}

