/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.lua;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.quest.Quest;
import de.slashbinbash.hexen.quest.QuestState;
import de.slashbinbash.hexen.quest.QuestSystem;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;

public class QuestBinding {
    public static void setup(LuaTable luaTable) {
        luaTable.set("QuestAdd", (LuaValue)new AddQuest());
        luaTable.set("QuestGetState", (LuaValue)new GetState());
        luaTable.set("QuestSetState", (LuaValue)new SetState());
        LuaTable luaTable2 = new LuaTable();
        luaTable2.set("OPEN", QuestState.OPEN.name());
        luaTable2.set("CLOSED", QuestState.CLOSED.name());
        luaTable.set("quest", (LuaValue)luaTable2);
    }

    public static class AddQuest
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue) {
            QuestSystem questSystem = RPG.getInstance().questSystem;
            String string = luaValue.tojstring();
            if (questSystem.contains(string)) {
                Quest.State state = questSystem.get(string);
                state.state = QuestState.OPEN;
            } else {
                Quest.State state = new Quest.State();
                state.state = QuestState.OPEN;
                questSystem.setState(string, state);
            }
            return null;
        }
    }

    public static class GetState
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue) {
            QuestSystem questSystem = RPG.getInstance().questSystem;
            String string = luaValue.tojstring();
            Quest.State state = questSystem.get(string);
            if (state == null) {
                return LuaValue.NIL;
            }
            QuestState questState = state.state;
            return questState != QuestState.unknown ? LuaValue.valueOf(questState.name()) : LuaValue.NIL;
        }
    }

    public static class SetState
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            String string = luaValue.tojstring();
            QuestState questState = QuestState.valueOf(luaValue2.tojstring());
            QuestSystem questSystem = RPG.getInstance().questSystem;
            questSystem.get((String)string).state = questState;
            return null;
        }
    }
}

