/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.lua;

import de.slashbinbash.hexen.RPG;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;

public class StateBinding {
    public static void setup(LuaTable luaTable) {
        luaTable.set("StateGetBool", (LuaValue)new GetBool());
        luaTable.set("StateGetInt", (LuaValue)new GetInt());
        luaTable.set("StateSetBool", (LuaValue)new SetBool());
        luaTable.set("StateSetInt", (LuaValue)new SetInt());
        luaTable.set("StateHasKey", (LuaValue)new HasKey());
    }

    public static class GetBool
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue) {
            String string = luaValue.tojstring();
            RPG rPG = RPG.getInstance();
            boolean bl = (Boolean)rPG.stateMap.get(string);
            return LuaValue.valueOf(bl);
        }
    }

    public static class GetInt
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue) {
            String string = luaValue.tojstring();
            RPG rPG = RPG.getInstance();
            int n = (Integer)rPG.stateMap.get(string);
            return LuaValue.valueOf(n);
        }
    }

    public static class SetBool
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            String string = luaValue.tojstring();
            boolean bl = luaValue2.toboolean();
            RPG.getInstance().stateMap.put(string, bl);
            return null;
        }
    }

    public static class SetInt
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            String string = luaValue.tojstring();
            int n = luaValue2.toint();
            RPG.getInstance().stateMap.put(string, n);
            return null;
        }
    }

    public static class HasKey
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue) {
            String string = luaValue.tojstring();
            RPG rPG = RPG.getInstance();
            boolean bl = rPG.stateMap.containsKey(string);
            return LuaValue.valueOf(bl);
        }
    }
}

