/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.map;

import de.slashbinbash.hexen.action.ActionFactory;
import de.slashbinbash.hexen.check.CheckFactory;
import de.slashbinbash.hexen.encounter.Encounter;
import de.slashbinbash.hexen.encounter.EncounterFactory;
import de.slashbinbash.hexen.encounter.Encounters;
import de.slashbinbash.hexen.enums.Direction;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.factory.SceneFactory;
import de.slashbinbash.hexen.map.Level;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.map.Map;
import de.slashbinbash.hexen.map.Scenes;
import de.slashbinbash.hexen.map.Tile;
import de.slashbinbash.hexen.map.TileEdge;
import de.slashbinbash.hexen.map.TileObject;
import de.slashbinbash.hexen.map.TileProperties;
import de.slashbinbash.hexen.map.TileProperty;
import de.slashbinbash.hexen.model.Scene;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MapFactory {
    private static void createEdge(Element element, TileEdge tileEdge) {
        block16: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "actions": {
                    tileEdge.actions = ActionFactory.createActions(element2);
                    break;
                }
                case "passable": {
                    tileEdge.passableChecks = CheckFactory.createChecks(element2);
                    break;
                }
                case "objects": {
                    block17: for (Element element3 : StaticXML.getChildElements(element2)) {
                        switch (element3.getTagName()) {
                            case "item": {
                                TileObject tileObject = new TileObject(tileEdge);
                                MapFactory.createTileObject(element3, tileObject);
                                tileObject.type = TileObject.Type.Item;
                                tileEdge.object = tileObject;
                                continue block17;
                            }
                        }
                        StaticXML.errUnknownTag(element3);
                    }
                    continue block16;
                }
                default: {
                    StaticXML.errUnknownTag(element2);
                }
            }
        }
    }

    private static void createEncounters(Element element, Level level) {
        Encounters encounters = new Encounters();
        block8: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "encounter": {
                    if (StaticXML.hasAttribute(element2, "id")) {
                        String string = StaticXML.getAttribute(element2, "id");
                        Encounter encounter = EncounterFactory.createEncounter(element2);
                        assert (string.length() == 1);
                        encounters.map.put(Character.valueOf(string.charAt(0)), encounter);
                        continue block8;
                    }
                    encounters.global = EncounterFactory.createEncounter(element2);
                    continue block8;
                }
                case "layout": {
                    continue block8;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        Element element3 = StaticXML.getElement(element, "layout");
        int n = level.width;
        int n2 = level.height;
        assert (n == level.width);
        assert (n2 == level.height);
        encounters.array = new char[n][n2];
        String string = StaticXML.getText(element3);
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\n' || c == '\t') continue;
            int n4 = n3 % n;
            int n5 = n3 / n;
            encounters.array[n4][n5] = c;
            ++n3;
        }
        level.encounters = encounters;
    }

    private static void createProperties(Element element, Level level) {
        TileProperties tileProperties = new TileProperties();
        for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "property": {
                    String string = StaticXML.getAttribute(element2, "id");
                    TileProperty tileProperty = new TileProperty();
                    for (Element element3 : StaticXML.getChildElements(element2)) {
                        switch (element3.getTagName()) {
                            case "actions": {
                                tileProperty.actions = ActionFactory.createActions(element3);
                            }
                        }
                    }
                    assert (string.length() == 1);
                    tileProperties.map.put(Character.valueOf(string.charAt(0)), tileProperty);
                }
            }
        }
        Element element4 = StaticXML.getElement(element, "layout");
        int n = level.width;
        int n2 = level.height;
        assert (n == level.width);
        assert (n2 == level.height);
        tileProperties.array = new char[n][n2];
        String string = StaticXML.getText(element4);
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\n' || c == '\t') continue;
            int n4 = n3 % n;
            int n5 = n3 / n;
            tileProperties.array[n4][n5] = c;
            ++n3;
        }
        level.properties = tileProperties;
    }

    private static Level createLevel(Element element) {
        assert (StaticXML.hasAttribute(element, "id"));
        Level level = new Level();
        level.__id__ = StaticXML.getAttribute(element, "id");
        level.width = StaticXML.getInt(element, "width");
        level.height = StaticXML.getInt(element, "height");
        level.visited = new boolean[level.width][level.height];
        level.resting = new boolean[level.width][level.height];
        Element element2 = null;
        block26: for (Element element3 : StaticXML.getChildElements(element)) {
            switch (element3.getTagName()) {
                case "scale": {
                    level.timeScale = Factory.parseDuration(element3);
                    break;
                }
                case "scene": {
                    level.scene = SceneFactory.createScene(StaticXML.getAttribute(element3, "ref"));
                    break;
                }
                case "edges": {
                    Object object;
                    int n;
                    int n2;
                    assert (element2 != null);
                    for (Element element4 : StaticXML.getElements(element3, "edge")) {
                        n2 = StaticXML.getInt(element4, "x");
                        n = StaticXML.getInt(element4, "y");
                        object = Direction.valueOf(StaticXML.getAttribute(element4, "d"));
                        TileEdge tileEdge = level.tiles[n2][n].getEdge((Direction)((Object)object));
                        MapFactory.createEdge(element4, tileEdge);
                    }
                    continue block26;
                }
                case "tiles": {
                    Object object;
                    int n;
                    int n2;
                    assert (element2 != null);
                    for (Element element5 : StaticXML.getElements(element3, "tile")) {
                        n2 = StaticXML.getInt(element5, "x");
                        n = StaticXML.getInt(element5, "y");
                        object = level.tiles[n2][n];
                        MapFactory.createTile(element5, (Tile)object);
                    }
                    continue block26;
                }
                case "map": {
                    element2 = element3;
                    MapFactory.createTileGrid(element2, level);
                    level.showMapTiles = true;
                    break;
                }
                case "tex": {
                    assert (level.tiles != null);
                    level.texId = element3.getAttribute("id");
                    if (!MapFactory.createTexGrid(element3, level)) continue block26;
                    level.showMapTextures = true;
                    level.showMapTiles = false;
                    break;
                }
                case "encounters": {
                    MapFactory.createEncounters(element3, level);
                    break;
                }
                case "scenes": {
                    MapFactory.createScenes(element3, level);
                    break;
                }
                case "properties": {
                    MapFactory.createProperties(element3, level);
                    break;
                }
                case "resting": {
                    Iterator<Element> iterator = StaticXML.getText(element3);
                    level.resting = MapFactory.readBinaryArray((String)((Object)iterator), level.width, level.height);
                    break;
                }
                case "visibility": {
                    int n2;
                    Iterator<Element> iterator = StaticXML.getText(element3);
                    level.visibility = MapFactory.readBinaryArray((String)((Object)iterator), level.width, level.height);
                    for (int i = 0; i < level.width; ++i) {
                        for (n2 = 0; n2 < level.height; ++n2) {
                            level.visited[i][n2] = level.visibility[i][n2];
                        }
                    }
                    continue block26;
                }
                default: {
                    StaticXML.errUnknownTag(element3);
                }
            }
        }
        return level;
    }

    private static List<Level> createLevels(Element element) {
        ArrayList<Level> arrayList = new ArrayList<Level>();
        block6: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "level": {
                    Level level = MapFactory.createLevel(element2);
                    arrayList.add(level);
                    continue block6;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return arrayList;
    }

    public static Location createLocation(Element element) {
        Location location = new Location();
        location.mapId = StaticXML.getAttribute(element, "map");
        location.level = StaticXML.getInt(element, "level");
        location.x = StaticXML.getInt(element, "x");
        location.y = StaticXML.getInt(element, "y");
        return location;
    }

    private static Map createMap(Element element) {
        Map map = new Map();
        map.__id__ = StaticXML.getAttribute(element, "id", null);
        switch (element.getTagName()) {
            case "map": {
                block12: for (Element element2 : StaticXML.getChildElements(element)) {
                    switch (element2.getTagName()) {
                        case "levels": {
                            map.levels.addAll(MapFactory.createLevels(element2));
                            continue block12;
                        }
                    }
                    StaticXML.errUnknownTag(element2);
                }
                break;
            }
            default: {
                StaticXML.errUnknownTag(element);
            }
        }
        return map;
    }

    public static Map createMap(File file) throws SAXException, IOException {
        Document document = StaticXML.loadXML(file);
        Map map = MapFactory.createMap(document.getDocumentElement());
        if (map.__id__ == null) {
            map.__id__ = file.getName().substring(0, file.getName().length() - 4);
        }
        return map;
    }

    public static Map createMap(String string) throws Exception {
        File file = new File(Factory.MAP_PATH + string + ".xml");
        Document document = StaticXML.loadXML(file);
        Map map = MapFactory.createMap(document.getDocumentElement());
        if (map.__id__ == null) {
            map.__id__ = string;
        }
        return map;
    }

    private static void createScenes(Element element, Level level) {
        Scenes scenes = new Scenes();
        for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "scene": {
                    String string = StaticXML.getAttribute(element2, "id");
                    Scene scene = SceneFactory.createScene(element2);
                    assert (string.length() == 1);
                    scenes.map.put(Character.valueOf(string.charAt(0)), scene);
                }
            }
        }
        Element element3 = StaticXML.getElement(element, "layout");
        int n = level.width;
        int n2 = level.height;
        scenes.array = new char[n][n2];
        String string = StaticXML.getText(element3);
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\n' || c == '\t') continue;
            int n4 = n3 % n;
            int n5 = n3 / n;
            scenes.array[n4][n5] = c;
            ++n3;
        }
        level.scenes = scenes;
    }

    private static void createTile(Element element, Tile tile) {
        block20: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "description": {
                    tile.description = StaticXML.hasText(element2) ? Factory.unformatMD(StaticXML.getText(element2)) : "";
                    break;
                }
                case "actions": {
                    tile.actions = ActionFactory.createActions(element2);
                    break;
                }
                case "objects": {
                    for (Element element3 : StaticXML.getChildElements(element2)) {
                        TileObject.Type type = null;
                        switch (element3.getTagName()) {
                            case "creature": {
                                type = TileObject.Type.Creature;
                                break;
                            }
                            case "item": {
                                type = TileObject.Type.Item;
                                break;
                            }
                            case "path": {
                                type = TileObject.Type.Path;
                                break;
                            }
                            default: {
                                StaticXML.errUnknownTag(element3);
                            }
                        }
                        Object object = new TileObject(tile);
                        MapFactory.createTileObject(element3, (TileObject)object);
                        ((TileObject)object).type = type;
                        tile.objects.add((TileObject)object);
                    }
                    continue block20;
                }
                default: {
                    StaticXML.errUnknownTag(element2);
                }
            }
        }
    }

    private static boolean createTexGrid(Element element, Level level) {
        int n = level.width;
        int n2 = level.height;
        String string = StaticXML.getText(element);
        if (string == null) {
            return false;
        }
        string = string.strip();
        byte[] byArray = HexFormat.of().parseHex(string);
        assert (byArray.length == n * n2 * 6);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n4 = byArray[n3++];
                int n5 = byArray[n3++];
                int n6 = byArray[n3++];
                int n7 = byArray[n3++];
                int n8 = byArray[n3++];
                int n9 = byArray[n3++];
                Tile tile = level.tiles[j][i];
                tile.texFloor = n4;
                tile.texRoom = n5;
                tile.edgeNorth.texEdge = n6;
                tile.edgeEast.texEdge = n7;
                tile.edgeSouth.texEdge = n8;
                tile.edgeWest.texEdge = n9;
            }
        }
        assert (n3 == byArray.length);
        return true;
    }

    private static void createTileGrid(Element element, Level level) {
        int n = level.width;
        int n2 = level.height;
        String string = StaticXML.getText(element).strip();
        level.tiles = new Tile[n][n2];
        level.image = StaticXML.getAttribute(element, "img", null);
        level.loop = StaticXML.hasAttribute(element, "loop");
        level.visibility = new boolean[n][n2];
        byte[] byArray = HexFormat.of().parseHex(string);
        assert (byArray.length == n * n2 * 5);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n4 = byArray[n3++];
                byte by = byArray[n3++];
                byte by2 = byArray[n3++];
                byte by3 = byArray[n3++];
                byte by4 = byArray[n3++];
                Tile tile = null;
                tile = new Tile();
                tile.type = n4;
                Tile tile2 = MapFactory.getTile(level.tiles, j, i - 1);
                if (tile2 != null && tile2.edgeSouth != null) {
                    assert (tile2.edgeSouth.type == by);
                    tile.edgeNorth = tile2.edgeSouth;
                } else {
                    tile.edgeNorth = new TileEdge(by);
                }
                Tile tile3 = MapFactory.getTile(level.tiles, j + 1, i);
                if (tile3 != null && tile3.edgeWest != null) {
                    assert (tile3.edgeWest.type == by2);
                    tile.edgeEast = tile3.edgeWest;
                } else {
                    tile.edgeEast = new TileEdge(by2);
                }
                Tile tile4 = MapFactory.getTile(level.tiles, j, i + 1);
                if (tile4 != null && tile4.edgeNorth != null) {
                    assert (tile4.edgeNorth.type == by3);
                    tile.edgeSouth = tile4.edgeNorth;
                } else {
                    tile.edgeSouth = new TileEdge(by3);
                }
                Tile tile5 = MapFactory.getTile(level.tiles, j - 1, i);
                if (tile5 != null && tile5.edgeEast != null) {
                    assert (tile5.edgeEast.type == by4);
                    tile.edgeWest = tile5.edgeEast;
                } else {
                    tile.edgeWest = new TileEdge(by4);
                }
                level.tiles[j][i] = tile;
            }
        }
    }

    private static void createTileObject(Element element, TileObject tileObject) {
        if (element.hasAttribute("id")) {
            tileObject.id = element.getAttribute("id");
        }
        block14: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "label": {
                    tileObject.label = StaticXML.getText(element2);
                    continue block14;
                }
                case "description": {
                    tileObject.description = StaticXML.getText(element2);
                    continue block14;
                }
                case "visible": {
                    tileObject.visible = false;
                    tileObject.visibleChecks = CheckFactory.createChecks(element2);
                    continue block14;
                }
                case "direction": {
                    tileObject.direction = Direction.valueOf(StaticXML.getText(element2));
                    continue block14;
                }
                case "actions": {
                    tileObject.actions = ActionFactory.createActions(element2);
                    continue block14;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
    }

    private static Tile getTile(Tile[][] tileArray, int n, int n2) {
        int n3 = tileArray.length;
        int n4 = tileArray[0].length;
        if (0 <= n && n < n3 && 0 <= n2 && n2 < n4) {
            return tileArray[n][n2];
        }
        return null;
    }

    public static boolean[][] readBinaryArray(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        if ((string = string.strip()).isEmpty()) {
            return null;
        }
        boolean[][] blArray = new boolean[n][n2];
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '0' && c != '1') continue;
            int n4 = n3 % n;
            int n5 = n3 / n;
            blArray[n4][n5] = c == '1';
            ++n3;
        }
        return blArray;
    }
}

