/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.message;

import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.enums.Attribute;
import de.slashbinbash.hexen.factory.ItemFactory;
import de.slashbinbash.hexen.message.Message;
import de.slashbinbash.hexen.message.MessageBase;
import de.slashbinbash.hexen.message.MessageBus;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.DamageInteger;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.quest.Quest;
import de.slashbinbash.hexen.quest.QuestFactory;

public enum EventBus {
    DOOR_LOCKED,
    DOOR_UNLOCKED,
    FAILED_ABILITY_CHECK,
    FAILED_ATTRIBUTE_CHECK,
    ITEM_ADDED,
    PARTY_ADDED,
    QUEST_ADDED,
    RECIPE_LEARNED,
    RUN_AGAINST_WALL,
    TOOK_DAMAGE,
    PRAYED,
    QUICKLOAD,
    QUICKSAVE,
    SCREENSHOT;


    public static void DoorLocked() {
        EventBus.push(DOOR_LOCKED, "The door is locked.", new Object[0]);
    }

    public static void DoorUnlocked() {
        EventBus.push(DOOR_UNLOCKED, "Door unlocked.", new Object[0]);
    }

    public static void FailedCheck(Ability ability, int n) {
        EventBus.push(FAILED_ABILITY_CHECK, null, ability, n);
    }

    public static void FailedCheck(Attribute attribute, int n) {
        EventBus.push(FAILED_ATTRIBUTE_CHECK, null, attribute, n);
    }

    public static void ItemAdded(Item item, int n) {
        String string = String.format("Added %d %s.", n, item.getName());
        EventBus.push(ITEM_ADDED, string, item, n);
    }

    public static void JoinedParty(ClassCreature classCreature) {
        String string = String.format("%s joined your party.", classCreature.name);
        EventBus.push(PARTY_ADDED, string, classCreature);
    }

    public static void QuestAdded(String string) {
        Quest quest = QuestFactory.createQuest(string);
        String string2 = String.format("Quest added \"%s\".", quest._data.name);
        EventBus.push(QUEST_ADDED, string2, quest);
    }

    public static void RecipeLearned(String string) {
        Item item = ItemFactory.createItem(string);
        String string2 = String.format("Learned recipe for %s.", item.getName());
        EventBus.push(RECIPE_LEARNED, string2, string);
    }

    public static void RunAgainstWall() {
        String string = "Ouch! You ran against a wall.";
        EventBus.push(RUN_AGAINST_WALL, string, new Object[0]);
    }

    private static void push(EventBus eventBus, String string, Object ... objectArray) {
        MessageBus.push(Message.POST_EVENT_BUS, new MessageBase(eventBus, string, objectArray));
    }

    public static void TookDamage(ClassCreature classCreature, DamageInteger damageInteger) {
        String string = String.format("%s took %d %s damage.", classCreature.name, damageInteger.value, damageInteger.damage.type.name);
        EventBus.push(TOOK_DAMAGE, string, classCreature, damageInteger);
    }

    public static void Prayed(int n) {
        String string = String.format("Prayed for %d minutes.", n);
        EventBus.push(PRAYED, string, n);
    }

    public static void Screenshot() {
        String string = "Created screenshot";
        EventBus.push(SCREENSHOT, string, new Object[0]);
    }

    public static void QuickSaved() {
        String string = "Quicksaved!";
        EventBus.push(QUICKSAVE, string, new Object[0]);
    }

    public static void QuickLoad() {
        String string = "Quickload!";
        EventBus.push(QUICKLOAD, string, new Object[0]);
    }
}

