/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.model;

import de.slashbinbash.hexen.action.Actions;
import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.enums.Attribute;
import de.slashbinbash.hexen.factory.ConditionFactory;
import de.slashbinbash.hexen.model.ConditionImmunities;
import de.slashbinbash.hexen.model.Damage;
import de.slashbinbash.hexen.model.Modifiers;

public class Condition {
    private final Data _data;
    public long timeLeftSeconds = 0L;

    public Condition(Condition condition) {
        this._data = condition._data;
        this.timeLeftSeconds = condition.timeLeftSeconds;
    }

    public Condition(Data data, long l) {
        this._data = data;
        this.timeLeftSeconds = l;
    }

    public Condition(String string) {
        this._data = ConditionFactory.createCondition(string);
    }

    public Condition(String string, long l) {
        this._data = ConditionFactory.createCondition(string);
        this.timeLeftSeconds = l;
    }

    public boolean cannotDefend() {
        return this._data.cannotDefend;
    }

    public boolean cannotMove() {
        return this._data.cannotMove;
    }

    public boolean cannotRest() {
        return this._data.modifiers != null && this._data.modifiers.cannotRest;
    }

    public boolean cannotRestoreAP() {
        return this._data.cannotRestoreAP;
    }

    public boolean cannotRestoreHP() {
        return this._data.cannotRestoreHP;
    }

    public boolean cannotRunAway() {
        return this._data.cannotRunAway;
    }

    public boolean cannotUseAbilities() {
        return this._data.cannotUseAbilities;
    }

    public boolean durationStacks() {
        return this._data.stackDuration;
    }

    public boolean equals(Object object) {
        if (object instanceof Condition) {
            Condition condition = (Condition)object;
            return this._data.equals(condition._data);
        }
        return false;
    }

    public int getAbilityScore(Ability ability) {
        return this._data.modifiers != null ? this._data.modifiers.getAbilityScore(ability) : 0;
    }

    public Actions getActions() {
        return this._data.actions;
    }

    public int getAttributeScore(Attribute attribute) {
        return this._data.modifiers != null ? this._data.modifiers.getAttributeScore(attribute) : 0;
    }

    public float getCritChance() {
        return this._data.modifiers != null ? this._data.modifiers.modCritChance : 0.0f;
    }

    public float getCritMultiplier() {
        return this._data.modifiers != null ? this._data.modifiers.modCritMultiplier : 0.0f;
    }

    public int getDamageAttack(Damage damage) {
        return this._data.modifiers != null ? this._data.modifiers.getDamageAttack(damage) : 0;
    }

    public float getDamageMultiplier(Damage damage) {
        return this._data.modifiers != null ? this._data.modifiers.getDamageMultiplier(damage) : 0.0f;
    }

    public int getDamageReduction(Damage damage) {
        return this._data.modifiers != null ? this._data.modifiers.getDamageReduction(damage) : 0;
    }

    public float getDamageResistance(Damage damage) {
        return this._data.modifiers != null ? this._data.modifiers.getDamageResistance(damage) : 0.0f;
    }

    public long getDuration() {
        return this.timeLeftSeconds;
    }

    public float getHitChanceAttacker() {
        return this._data.modifiers != null ? this._data.modifiers.modHitChanceAttacker : 0.0f;
    }

    public float getHitChanceDefender() {
        return this._data.modifiers != null ? this._data.modifiers.modHitChanceDefender : 0.0f;
    }

    public String getId() {
        return this._data.__id__;
    }

    public boolean getImmuneToCondition(Condition condition) {
        return this._data.modifiers != null && this._data.modifiers.getImmuneToCondition(condition);
    }

    public boolean getImmuneToCrits() {
        return this._data.modifiers != null ? this._data.modifiers.modImmuneToCrits : false;
    }

    public ConditionImmunities getImmunities() {
        return this._data.modifiers != null ? this._data.modifiers.modImmunities : null;
    }

    public int getMaxActionPoints() {
        return this._data.modifiers != null ? this._data.modifiers.modMaxActionPoints : 0;
    }

    public int getMaxHitPoints() {
        return this._data.modifiers != null ? this._data.modifiers.modMaxHitPoints : 0;
    }

    public String getName() {
        return this._data.name;
    }

    public float getRunAwayChance() {
        return this._data.modifiers != null ? this._data.modifiers.modRunAwayChance : 0.0f;
    }

    public int getVim() {
        return this._data.modifiers != null ? this._data.modifiers.modVim : 0;
    }

    public boolean hasDamageReductions() {
        return this._data.modifiers != null && this._data.modifiers.hasDamageReductions();
    }

    public boolean hasDamageResistances() {
        return this._data.modifiers != null && this._data.modifiers.hasDamageResistances();
    }

    public boolean removeOnAttack() {
        return this._data.removeOnAttack;
    }

    public boolean removeOnDamage() {
        return this._data.removeOnDamage;
    }

    public boolean removeOnRest() {
        return this._data.removeOnRest;
    }

    public boolean skipCombatTurn() {
        return this._data.skipCombatTurn;
    }

    public static class Data {
        public String __id__ = null;
        public String name = null;
        public String description = null;
        public boolean stackDuration = false;
        public Modifiers modifiers = null;
        public Actions actions = null;
        public boolean skipCombatTurn = false;
        public boolean removeOnAttack = false;
        public boolean removeOnDamage = false;
        public boolean removeOnRest = false;
        public boolean cannotDefend = false;
        public boolean cannotMove = false;
        public boolean cannotRunAway = false;
        public boolean cannotRestoreHP = false;
        public boolean cannotRestoreAP = false;
        public boolean cannotUseAbilities = false;

        public boolean equals(Object object) {
            if (object instanceof Data) {
                Data data = (Data)object;
                return this.__id__.equals(data.__id__);
            }
            return false;
        }
    }
}

