/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.model;

import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.ItemStacks;
import de.slashbinbash.hexen.model.ItemType;
import java.util.List;
import java.util.function.Predicate;

public class Inventory
extends ItemStacks {
    public static final String CURRENCY = "currency";
    public static final int CAPACITY = 12;

    public void addCurrency(int n) {
        this.add(CURRENCY, n);
    }

    public int countCurrency() {
        return this.count(CURRENCY);
    }

    public int countEquipable() {
        return (int)this.stacks.stream().filter((? super T item) -> item.getType() == ItemType.Equip && !StaticRPG.isEquipped(item)).count();
    }

    public List<Item> list(ItemType itemType) {
        return this.stacks.stream().filter((? super T item) -> item.getType() == itemType).toList();
    }

    public List<Item> filter(Predicate<Item> predicate) {
        return this.stacks.stream().filter(predicate).toList();
    }

    public int getCurrency() {
        return this.count(CURRENCY);
    }

    private boolean hasCapacity(Item item, int n) {
        return this.hasCapacity(item.getId(), n);
    }

    private boolean hasCapacity(String string, int n) {
        for (Item item : this.stacks) {
            if (!item.getId().equals(string) || item.getStackSizeLeft() < n) continue;
            return true;
        }
        int n2 = this.stacks.size();
        return n2 < 12;
    }

    public List<Item> listEquipable() {
        return this.stacks.stream().filter((? super T item) -> item.getType() == ItemType.Equip && !StaticRPG.isEquipped(item)).toList();
    }

    public void removeCurrency(int n) {
        this.remove(CURRENCY, n);
    }

    public void restack() {
        for (int i = 0; i < this.stacks.size(); ++i) {
            Item item2 = (Item)this.stacks.get(i);
            int n = item2.getStackSizeLeft();
            if (n == 0) continue;
            for (int j = i + 1; j < this.stacks.size(); ++j) {
                Item item3 = (Item)this.stacks.get(j);
                if (!item2.getId().equals(item3.getId())) continue;
                int n2 = Math.min(n, item3.count);
                item3.count -= n2;
                item2.count += n2;
            }
        }
        this.stacks.removeIf(item -> item.count == 0);
    }

    public int size(ItemType itemType) {
        int n = 0;
        for (Item item : this.stacks) {
            if (item.getType() != itemType) continue;
            ++n;
        }
        return n;
    }

    public void sortByType() {
        this.stacks.sort((item, item2) -> item.getName().compareTo(item2.getName()));
        this.stacks.sort((item, item2) -> item.getType().compareTo(item2.getType()));
    }
}

