/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.model;

import de.slashbinbash.hexen.action.Actions;
import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.enums.Attribute;
import de.slashbinbash.hexen.model.Abilities;
import de.slashbinbash.hexen.model.Condition;
import de.slashbinbash.hexen.model.ConditionImmunities;
import de.slashbinbash.hexen.model.Damage;
import de.slashbinbash.hexen.model.DamageReductions;
import de.slashbinbash.hexen.model.ItemData;
import de.slashbinbash.hexen.model.ItemType;

public class Item {
    public static final int MAX_STACK = 999;
    public final ItemData _data;
    public int count = 1;

    public Item(Item item) {
        this._data = item._data;
        this.count = item.count;
    }

    public Item(ItemData itemData) {
        this._data = itemData;
    }

    public int getStackSizeMax() {
        return this._data.stackSize;
    }

    public int getStackSizeLeft() {
        return this._data.stackSize - this.count;
    }

    public int add(int n) {
        if (n <= 0) {
            return 0;
        }
        if (!this._data.stackable) {
            return 0;
        }
        int n2 = Math.min(this._data.stackSize - this.count, n);
        this.count += n2;
        return n2;
    }

    public boolean equals(Object object) {
        if (object instanceof Item) {
            Item item = (Item)object;
            return this._data.equals(item._data);
        }
        return false;
    }

    public Abilities getAbilities() {
        return this._data.modifiers != null ? this._data.modifiers.modAbilities : null;
    }

    public int getAbilityScore(Ability ability) {
        return this._data.modifiers != null ? this._data.modifiers.getAbilityScore(ability) : 0;
    }

    public Actions getActions() {
        return this._data.actions;
    }

    public int getAttributeScore(Attribute attribute) {
        return this._data.modifiers != null ? this._data.modifiers.getAttributeScore(attribute) : 0;
    }

    public float getCritChance() {
        return this._data.modifiers != null ? this._data.modifiers.modCritChance : 0.0f;
    }

    public float getCritMultiplier() {
        return this._data.modifiers != null ? this._data.modifiers.modCritMultiplier : 0.0f;
    }

    public int getDamageAttack(Damage damage) {
        return this._data.modifiers != null ? this._data.modifiers.getDamageAttack(damage) : 0;
    }

    public float getDamageMultiplier(Damage damage) {
        return this._data.modifiers != null ? this._data.modifiers.getDamageMultiplier(damage) : 0.0f;
    }

    public int getDamageReduction(Damage damage) {
        return this._data.modifiers != null ? this._data.modifiers.getDamageReduction(damage) : 0;
    }

    public DamageReductions getDamageReductions() {
        return this._data.modifiers != null ? this._data.modifiers.modDamageReductions : null;
    }

    public float getDamageResistance(Damage damage) {
        return this._data.modifiers != null ? this._data.modifiers.getDamageResistance(damage) : 0.0f;
    }

    public String getDescription() {
        return this._data.description;
    }

    public float getHitChanceAttacker() {
        return this._data.modifiers != null ? this._data.modifiers.modHitChanceAttacker : 0.0f;
    }

    public float getHitChanceDefender() {
        return this._data.modifiers != null ? this._data.modifiers.modHitChanceDefender : 0.0f;
    }

    public String getId() {
        return this._data.__id__;
    }

    public boolean getImmuneToCondition(Condition condition) {
        return this._data.modifiers != null && this._data.modifiers.getImmuneToCondition(condition);
    }

    public boolean getImmuneToCrits() {
        return this._data.modifiers != null ? this._data.modifiers.modImmuneToCrits : false;
    }

    public ConditionImmunities getImmunities() {
        return this._data.modifiers != null ? this._data.modifiers.modImmunities : null;
    }

    public int getMaxActionPoints() {
        return this._data.modifiers != null ? this._data.modifiers.modMaxActionPoints : 0;
    }

    public int getMaxHitPoints() {
        return this._data.modifiers != null ? this._data.modifiers.modMaxHitPoints : 0;
    }

    public String getName() {
        return this._data.name;
    }

    public float getRunAwayChance() {
        return this._data.modifiers != null ? this._data.modifiers.modRunAwayChance : 0.0f;
    }

    public ItemType getType() {
        return this._data.type;
    }

    public int getValue() {
        return this._data.value;
    }

    public int getVim() {
        return this._data.modifiers != null ? this._data.modifiers.modVim : 0;
    }

    public boolean hasAbilities() {
        return this._data.modifiers != null && this._data.modifiers.hasAbilities();
    }

    public boolean hasActions() {
        return this._data.actions != null && this._data.actions.size() > 0;
    }

    public boolean hasDamageReductions() {
        return this._data.modifiers != null && this._data.modifiers.hasDamageReductions();
    }

    public boolean hasDamageResistances() {
        return this._data.modifiers != null && this._data.modifiers.hasDamageResistances();
    }

    public boolean hasImmunities() {
        return this._data.modifiers != null && this._data.modifiers.hasImmunities();
    }

    public boolean isDropable() {
        return this._data.dropable;
    }

    public boolean isEquipable() {
        return this._data.equipable;
    }

    public boolean isReadable() {
        return this._data.text != null;
    }

    public boolean isSellable() {
        return this._data.sellable;
    }

    public boolean isStackable() {
        return this._data.stackable;
    }

    public boolean isUnequipable() {
        return this._data.unequipable;
    }

    public boolean isUseable() {
        return this._data.useable;
    }

    public int remove(int n) {
        if (n <= 0) {
            return 0;
        }
        int n2 = Math.min(this.count, n);
        this.count -= n;
        return n2;
    }
}

