/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.model;

import de.slashbinbash.hexen.factory.ItemFactory;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.ItemData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ItemStacks
implements Iterable<Item> {
    protected List<Item> stacks = new ArrayList<Item>(0);

    public int add(Item item) {
        this.stacks.add(item);
        return item.count;
    }

    public int add(String string, int n) {
        if (n <= 0) {
            return 0;
        }
        ItemData itemData = ItemFactory.createItemDesc(string);
        int n2 = n;
        if (itemData.stackable && itemData.stackSize > 1) {
            for (Item item : this.stacks) {
                if (item.getId().equals(string) && (n2 -= item.add(n2)) == 0) break;
            }
        }
        while (n2 > 0) {
            Item item;
            int n3 = Math.min(n2, itemData.stackSize);
            item = new Item(itemData);
            item.count = n3;
            this.stacks.add(item);
            n2 -= n3;
        }
        return n - n2;
    }

    public void clear() {
        this.stacks.clear();
    }

    public boolean contains(Item item) {
        for (Item item2 : this.stacks) {
            if (item2 != item) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String string) {
        for (Item item : this.stacks) {
            if (!item.getId().equals(string)) continue;
            return true;
        }
        return false;
    }

    private int count(Item item) {
        return item.count;
    }

    public int count(String string) {
        int n = 0;
        for (Item item : this.stacks) {
            if (!item.getId().equals(string)) continue;
            n += item.count;
        }
        return n;
    }

    public Item get(String string) {
        for (Item item : this.stacks) {
            if (!item.getId().equals(string)) continue;
            return item;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @Override
    public Iterator<Item> iterator() {
        return this.stacks.iterator();
    }

    public List<Item> list() {
        return this.stacks;
    }

    public int remove(Item item2, int n) {
        assert (this.stacks.contains(item2));
        int n2 = item2.remove(n);
        this.stacks.removeIf(item -> item.count == 0);
        return n2;
    }

    public int remove(Item item) {
        if (this.stacks.remove(item)) {
            return item.count;
        }
        return 0;
    }

    public int remove(String string, int n) {
        int n2 = n;
        for (Item item2 : this.stacks) {
            if (!item2.getId().equals(string)) continue;
            int n3 = Math.min(item2.count, n2);
            item2.count -= n3;
            if ((n2 -= n3) != 0) continue;
            break;
        }
        this.stacks.removeIf(item -> item.count == 0);
        return n - n2;
    }

    private int removeAll(String string) {
        int n = 0;
        for (Item item2 : this.stacks) {
            if (!item2.getId().equals(string)) continue;
            n += item2.count;
            item2.count = 0;
        }
        this.stacks.removeIf(item -> item.count == 0);
        return n;
    }

    public int removeAll(Item item2) {
        int n = 0;
        for (Item item3 : this.stacks) {
            if (item3 != item2) continue;
            n += item3.count;
            item3.count = 0;
        }
        this.stacks.removeIf(item -> item.count == 0);
        return n;
    }

    public int size() {
        return this.stacks.size();
    }
}

