/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.model;

import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.enums.Attribute;
import de.slashbinbash.hexen.model.Damage;
import de.slashbinbash.hexen.model.DamageReductions;
import de.slashbinbash.hexen.model.Slot;
import de.slashbinbash.hexen.model.SlotItem;

public class Slots {
    private String id = null;
    private Slot[] slots = null;

    public Slots(String string, Slot[] slotArray) {
        this.id = string;
        this.slots = slotArray;
    }

    public boolean canSet(int n, SlotItem.Data data) {
        if (!(0 <= n && n < this.slots.length)) {
            return false;
        }
        if (data == null) {
            return true;
        }
        if (!this.slots[n].id.equals(data.slotId)) {
            return false;
        }
        return this.slots[n].mod == null || !data.equals(this.slots[n].mod._data);
    }

    public boolean containsMod(SlotItem slotItem) {
        for (Slot slot : this.slots) {
            if (!slot.mod.equals(slotItem)) continue;
            return true;
        }
        return false;
    }

    public boolean containsMod(String string) {
        for (Slot slot : this.slots) {
            if (slot.mod == null || !slot.mod.getId().equals(string)) continue;
            return true;
        }
        return false;
    }

    public int getAbilityScore(Ability ability) {
        int n = 0;
        for (Slot slot : this.slots) {
            if (slot.mod == null) continue;
            n += slot.mod.getAbilityScore(ability);
        }
        return n;
    }

    public int getAttributeScore(Attribute attribute) {
        int n = 0;
        for (Slot slot : this.slots) {
            if (slot.mod == null) continue;
            n += slot.mod.getAttributeScore(attribute);
        }
        return n;
    }

    public float getCritChance() {
        float f = 0.0f;
        for (Slot slot : this.slots) {
            if (slot.mod == null) continue;
            f += slot.mod.getCritChance();
        }
        return f;
    }

    public float getCritMultiplier() {
        float f = 0.0f;
        for (Slot slot : this.slots) {
            if (slot.mod == null) continue;
            f += slot.mod.getCritMultiplier();
        }
        return f;
    }

    public int getDamageAttack(Damage damage) {
        int n = 0;
        for (Slot slot : this.slots) {
            if (slot.mod == null) continue;
            n += slot.mod.getDamageAttack(damage);
        }
        return n;
    }

    public float getDamageMultiplier(Damage damage) {
        float f = 0.0f;
        for (Slot slot : this.slots) {
            if (slot.mod == null) continue;
            f += slot.mod.getDamageMultiplier(damage);
        }
        return f;
    }

    public int getDamageReduction(Damage damage) {
        int n = 0;
        for (Slot slot : this.slots) {
            if (slot.mod == null) continue;
            n += slot.mod.getDamageReduction(damage);
        }
        return n;
    }

    public DamageReductions getDamageReductions() {
        return null;
    }

    public float getDamageResistance(Damage damage) {
        float f = 0.0f;
        for (Slot slot : this.slots) {
            if (slot.mod == null) continue;
            f += slot.mod.getDamageResistance(damage);
        }
        return f;
    }

    public int getEmptyIndex(String string) {
        for (int i = 0; i < this.slots.length; ++i) {
            if (!this.slots[i].id.equals(string) || this.slots[i].mod != null) continue;
            return i;
        }
        return -1;
    }

    public float getHitChanceAttacker() {
        float f = 0.0f;
        for (Slot slot : this.slots) {
            if (slot.mod == null) continue;
            f += slot.mod.getHitChanceAttacker();
        }
        return f;
    }

    public float getHitChanceDefender() {
        float f = 0.0f;
        for (Slot slot : this.slots) {
            if (slot.mod == null) continue;
            f += slot.mod.getHitChanceDefender();
        }
        return f;
    }

    public String getId() {
        return this.id;
    }

    public boolean getImmuneToCrits() {
        boolean bl = false;
        for (Slot slot : this.slots) {
            if (slot.mod == null) continue;
            bl |= slot.mod.getImmuneToCrits();
        }
        return bl;
    }

    public int getMaxActionPoints() {
        int n = 0;
        for (Slot slot : this.slots) {
            if (slot.mod == null) continue;
            n += slot.mod.getMaxActionPoints();
        }
        return n;
    }

    public int getMaxHitPoints() {
        int n = 0;
        for (Slot slot : this.slots) {
            if (slot.mod == null) continue;
            n += slot.mod.getMaxHitPoints();
        }
        return n;
    }

    public float getRunAwayChance() {
        float f = 0.0f;
        for (Slot slot : this.slots) {
            if (slot.mod == null) continue;
            f += slot.mod.getRunAwayChance();
        }
        return f;
    }

    public int getVim() {
        int n = 0;
        for (Slot slot : this.slots) {
            if (slot.mod == null) continue;
            n += slot.mod.getVim();
        }
        return n;
    }

    public boolean set(int n, SlotItem.Data data) {
        if (!this.canSet(n, data)) {
            return false;
        }
        this.slots[n].mod = data != null ? new SlotItem(data) : null;
        return true;
    }

    public Slot[] values() {
        return this.slots;
    }
}

