/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.model;

import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.enums.Attribute;
import de.slashbinbash.hexen.factory.TraitFactory;
import de.slashbinbash.hexen.model.Condition;
import de.slashbinbash.hexen.model.ConditionImmunities;
import de.slashbinbash.hexen.model.Damage;
import de.slashbinbash.hexen.model.Modifiers;
import java.util.Collection;

public class Trait {
    public String id;
    public String name;
    public String description;
    public Modifiers modifiers = null;

    public static Trait valueOf(String string) {
        return TraitFactory.getTrait(string);
    }

    public static Collection<Trait> values() {
        return TraitFactory.listTraits();
    }

    public boolean cannotRest() {
        return this.modifiers != null ? this.modifiers.cannotRest : false;
    }

    public int getAbilityScore(Ability ability) {
        return this.modifiers != null ? this.modifiers.getAbilityScore(ability) : 0;
    }

    public int getAttributeScore(Attribute attribute) {
        return this.modifiers != null ? this.modifiers.getAttributeScore(attribute) : 0;
    }

    public float getCritChance() {
        return this.modifiers != null ? this.modifiers.modCritChance : 0.0f;
    }

    public float getCritMultiplier() {
        return this.modifiers != null ? this.modifiers.modCritMultiplier : 0.0f;
    }

    public int getDamageAttack(Damage damage) {
        return this.modifiers != null ? this.modifiers.getDamageAttack(damage) : 0;
    }

    public float getDamageMultiplier(Damage damage) {
        return this.modifiers != null ? this.modifiers.getDamageMultiplier(damage) : 0.0f;
    }

    public int getDamageReduction(Damage damage) {
        return this.modifiers != null ? this.modifiers.getDamageReduction(damage) : 0;
    }

    public float getDamageResistance(Damage damage) {
        return this.modifiers != null ? this.modifiers.getDamageResistance(damage) : 0.0f;
    }

    public float getHitChanceAttacker() {
        return this.modifiers != null ? this.modifiers.modHitChanceAttacker : 0.0f;
    }

    public float getHitChanceDefender() {
        return this.modifiers != null ? this.modifiers.modHitChanceDefender : 0.0f;
    }

    public boolean getImmuneToCondition(Condition condition) {
        return this.modifiers != null && this.modifiers.getImmuneToCondition(condition);
    }

    public boolean getImmuneToCrits() {
        return this.modifiers != null && this.modifiers.modImmuneToCrits;
    }

    public ConditionImmunities getImmunities() {
        return this.modifiers != null ? this.modifiers.modImmunities : null;
    }

    public int getMaxActionPoints() {
        return this.modifiers != null ? this.modifiers.modMaxActionPoints : 0;
    }

    public int getMaxHitPoints() {
        return this.modifiers != null ? this.modifiers.modMaxHitPoints : 0;
    }

    public float getRunAwayChance() {
        return this.modifiers != null ? this.modifiers.modRunAwayChance : 0.0f;
    }

    public int getVim() {
        return this.modifiers != null ? this.modifiers.modVim : 0;
    }

    public boolean hasDamageReductions() {
        return this.modifiers != null && this.modifiers.modDamageReductions != null;
    }

    public boolean hasDamageResistances() {
        return this.modifiers != null && this.modifiers.modDamageResistances != null;
    }
}

