/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.model;

import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.enums.Attribute;
import de.slashbinbash.hexen.model.Condition;
import de.slashbinbash.hexen.model.Damage;
import de.slashbinbash.hexen.model.Trait;
import java.util.HashSet;

public class Traits
extends HashSet<Trait> {
    private static final long serialVersionUID = -8720498248631144006L;

    public boolean cannotRest() {
        for (Trait trait : this) {
            if (!trait.cannotRest()) continue;
            return true;
        }
        return false;
    }

    public int getAbilityScore(Ability ability) {
        int n = 0;
        for (Trait trait : this) {
            n += trait.getAbilityScore(ability);
        }
        return n;
    }

    public int getAttributeScore(Attribute attribute) {
        int n = 0;
        for (Trait trait : this) {
            n += trait.getAttributeScore(attribute);
        }
        return n;
    }

    public float getCritChance() {
        float f = 0.0f;
        for (Trait trait : this) {
            f += trait.getCritChance();
        }
        return f;
    }

    public float getCritMultiplier() {
        float f = 0.0f;
        for (Trait trait : this) {
            f += trait.getCritMultiplier();
        }
        return f;
    }

    public int getDamageAttack(Damage damage) {
        int n = 0;
        for (Trait trait : this) {
            n += trait.getDamageAttack(damage);
        }
        return n;
    }

    public float getDamageMultiplier(Damage damage) {
        float f = 0.0f;
        for (Trait trait : this) {
            f += trait.getDamageMultiplier(damage);
        }
        return f;
    }

    public int getDamageReduction(Damage damage) {
        int n = 0;
        for (Trait trait : this) {
            n += trait.getDamageReduction(damage);
        }
        return n;
    }

    public float getDamageResistance(Damage damage) {
        float f = 0.0f;
        for (Trait trait : this) {
            f += trait.getDamageResistance(damage);
        }
        return f;
    }

    public float getHitChanceAttacker() {
        float f = 0.0f;
        for (Trait trait : this) {
            f += trait.getHitChanceAttacker();
        }
        return f;
    }

    public float getHitChanceDefender() {
        float f = 0.0f;
        for (Trait trait : this) {
            f += trait.getHitChanceDefender();
        }
        return f;
    }

    public boolean getImmuneToCondition(Condition condition) {
        for (Trait trait : this) {
            if (!trait.getImmuneToCondition(condition)) continue;
            return true;
        }
        return false;
    }

    public boolean getImmuneToCrits() {
        for (Trait trait : this) {
            if (!trait.getImmuneToCrits()) continue;
            return true;
        }
        return false;
    }

    public int getMaxActionPoints() {
        int n = 0;
        for (Trait trait : this) {
            n += trait.getMaxActionPoints();
        }
        return n;
    }

    public int getMaxHitPoints() {
        int n = 0;
        for (Trait trait : this) {
            n += trait.getMaxHitPoints();
        }
        return n;
    }

    public float getRunAwayChance() {
        float f = 0.0f;
        for (Trait trait : this) {
            f += trait.getRunAwayChance();
        }
        return f;
    }

    public int getVim() {
        int n = 0;
        for (Trait trait : this) {
            n += trait.getVim();
        }
        return n;
    }
}

